/* XSEND.CMD - A C-Kermit Rexx program to transmit an entire            */
/*             directory tree from one computer to another.             */
/*                                                                      */
/* Alias: CKOXSE.CMD.                                                   */
/* Author: Jeffrey Altman - Altmania Productions                        */
/* Version 2, July 16, 1994                                             */
/*                                                                      */
/* Format:                                                              */
/*  XSEND <PATH> <FILESPEC>  e.g., XSEND C:\\ *                         */
/*  (Note: backslashes must be doubled.)                                */
/*                                                                      */
/* To send an entire directory tree from one OS/2 System to another:    */
/*                                                                      */
/* REMOTE                                                               */
/*  set file type labeled                                               */
/*  set file collision update                                           */
/*  server                                                              */
/*                                                                      */
/* LOCAL                                                                */
/*  define xsend rexx call xsend.cmd '\%1 \%2'                          */
/*  set file type labeled                                               */
/*  xsend <path> <filespec>                                             */
/*  finish                                                              */
/*                                                                      */
/* CAUTION: The above procedure is not recommended for sending from an  */
/* HPFS volume to a FAT volume.  Any other combination is OK.           */
/*                                                                      */
/* You can also XSEND from OS/2 to DOS or UNIX, but you should use      */
/* BINARY rather than LABELED mode.  When sending to UNIX in this way,  */
/* the resulting text files will still be in OS/2 format (CRLF rather   */
/* than LF line terminators).  You should only XSEND to DOS from a      */
/* FAT volume.                                                          */
/*                                                                      */
/* Homework:  Modify this program for sending directory trees to VMS.   */
/* Hints: "mkdir" -> "create/dir", "cd .." -> "cd [-]", etc.            */
/*                                                                      */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

PARSE ARG path filespec

IF path = "" | filespec = "" THEN DO
   SAY "XSEND <path> <filespec>"
   RETURN 
END

SAY "Sending all files" filespec "in directory tree" path "to the Server"

call XSEND path, filespec
RETURN

XSEND: PROCEDURE 
path = ARG(1) 
filespec = ARG(2) 

startdir = DIRECTORY( path ) 

call SysFileTree filespec, 'file', 'FO'
do i=1 to file.0
  'send' FILESPEC('name',file.i)
  end

call SysFileTree '*', 'dir', 'DO'
do i=1 to dir.0
  directory = FILESPEC('name',dir.i)
  'remote host mkdir' directory
  'remote cd'         directory
  call XSEND directory, filespec
  'remote cd ..'
  end

call DIRECTORY startdir 
RETURN 
