{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O-,R-,S-,V-,X+}
{$M 4096,0,655360}

   (* Copyright by Jare/Iguana in 1993, but given to the public domain. *)
   (* Want more comments? Write'em!                                     *)

   (*   Main program. Does too many things not taken to separate units, *)
   (* but anyway it works.                                              *)

USES
   DOS,
   Devices, Menus, Output, Detections, Gfx, HexConversions, Reader;

VAR
   cfg : TCfg;

CONST
   rateit : ARRAY [1..13] OF TMenuIt = (
         (Text: ' 8000   386SX or Trident VGA'; Val: 8000),
         (Text: '10000                    '  ; Val:10000),
         (Text: '12000                    '  ; Val:12000),
         (Text: '14000                    '  ; Val:14000),
         (Text: '16000   Our 386/25+ET-4000'  ; Val:16000),
         (Text: '18000                    '  ; Val:18000),
         (Text: '20000                    '  ; Val:20000),
         (Text: '22000                    '  ; Val:22000),
         (Text: '26000                    '  ; Val:26000),
         (Text: '32000                    '  ; Val:32000),
         (Text: '38000                    '  ; Val:38000),
         (Text: '44000   486 or higher.    '  ; Val:44000),
         (Text: 'Accept previous selection'   ; Val:$FFFF)
   );
PROCEDURE ChooseRate;
  VAR
     ch : WORD;
     i  : INTEGER;
  BEGIN
     IF (cfg.SoundDevice = NONE) OR (cfg.SoundDevice = GUS) THEN
        EXIT;
     ClearArea;
     ClearMenu(mm^);
     FOR i := 1 TO 13 DO
        AddItem(mm^, rateit[i]);
     ch := DoMenu(mm^, cfg.ReplayRate);
     IF ch <> $FFFF THEN
        cfg.ReplayRate := ch;
     ClearArea
  END;


CONST
   devit : ARRAY [1..9] OF TMenuIt = (
        (Text:'Stereo SoundBlaster 16 ASP'; Val:ORD(S_SB16ASP)),
        (Text:'Mono SoundBlaster 16 ASP'  ; Val:ORD(M_SB16ASP)),
        (Text:'Stereo SoundBlaster Pro'   ; Val:ORD(S_SBPRO)),
        (Text:'Mono SoundBlaster Pro'     ; Val:ORD(M_SBPRO)),
        (Text:'Plain SoundBlaster'        ; Val:ORD(SB)),
        (Text:'Gravis Ultrasound'         ; Val:ORD(GUS)),
        (Text:'PAS (SB emulation, sorry)' ; Val:ORD(PAS)),
        (Text:'No Sound'                  ; Val:ORD(NONE)),
        (Text: 'Accept previous selection'; Val:$FFFF)
   );
PROCEDURE SelectDevice;
  VAR
     ch : WORD;
     i  : INTEGER;
  BEGIN
     ClearArea;
     ClearMenu(mm^);
     FOR i := 1 TO 9 DO
        AddItem(mm^, devit[i]);
     ch := DoMenu(mm^, ORD(cfg.SoundDevice));
     IF ch <> $FFFF THEN
        cfg.SoundDevice := TDevices(ch);
     ClearArea;
  END;


PROCEDURE SetPort;
  VAR
     portit: TMenuIt;
     ch : WORD;
     i  : INTEGER;
  BEGIN
     IF cfg.SoundDevice >= NONE THEN
        EXIT;
     ClearArea;
     ClearMenu(mm^);
     FOR i := 1 TO 12 DO BEGIN
        portit.Text := 'Port number 2'+HexByte((i-1)*16)+'h';
        portit.Val  := (i-1)*16 + $200;
        AddItem(mm^, portit);
     END;
     AddItem(mm^, rateit[13]);
     ch := DoMenu(mm^, cfg.Port);
     IF ch <> $FFFF THEN
        cfg.Port := ch;
     ClearArea;
  END;


PROCEDURE SetIRQ;
  VAR
     irqit : TMenuIt;
     ch    : WORD;
     i     : INTEGER;
     s     : STRING;
  BEGIN
     IF cfg.SoundDevice >= NONE THEN
        EXIT;
     ClearArea;
     ClearMenu(mm^);
     FOR i := 2 TO 15 DO
        IF (i <> 6) AND (i <> 9) THEN BEGIN
           Str(i : 2, s);
           irqit.Text := 'IRQ number '+s;
           irqit.Val  := i;
           AddItem(mm^, irqit)
        END;
     AddItem(mm^, rateit[13]);
     ch := DoMenu(mm^, cfg.IRQ);
     IF ch <> $FFFF THEN
        cfg.IRQ := ch;
     ClearArea;
  END;

PROCEDURE SetDMA;
  VAR
     dmait : TMenuIt;
     ch    : WORD;
     i     : INTEGER;
     s     : STRING;
  BEGIN
     IF (cfg.SoundDevice >= NONE) OR (cfg.SoundDevice = GUS) THEN
        EXIT;
     ClearArea;
     ClearMenu(mm^);
     FOR i := 0 TO 7 DO
        IF (i <> 2) AND (i <> 4) THEN BEGIN
           Str(i : 2, s);
           dmait.Text := 'DMA channel '+s;
           dmait.Val  := i;
           AddItem(mm^, dmait)
        END;
     AddItem(mm^, rateit[13]);
     ch := DoMenu(mm^, cfg.DMA);
     IF ch <> $FFFF THEN
        cfg.DMA := ch;
     ClearArea;
  END;



FUNCTION Cfg2Text: STRING;
  VAR
     s1, s2 : STRING;
  BEGIN
     s1 := 'Device: '+devit[ORD(cfg.SoundDevice)+1].Text;
     IF cfg.SoundDevice <> NONE THEN BEGIN
        s1 := s1;
        IF cfg.SoundDevice <> GUS THEN BEGIN
           Str(cfg.ReplayRate, s2);
           s1 := s1 + ', Rate = ' + s2
        END;
        s1 := s1 + ', Port ' + HexWord(cfg.Port) + 'h, IRQ ';
        Str(cfg.IRQ, s2);
        s1 := s1 + s2;
        IF cfg.SoundDevice <> GUS THEN BEGIN
           Str(cfg.DMA, s2);
           s1 := s1 + ', DMA ' + s2
        END
     END;
     Cfg2Text := s1
  END;


CONST
   mainit : ARRAY [1..8] OF TMenuIt = (
         (Text:'Run the demo'; Val:0),
         (Text:'Select sound device'; Val:1),
         (Text:'Choose sampling rate'; Val:2),
         (Text:'Set soundcard port number'; Val:3),
         (Text:'Set soundcard IRQ'; Val:4),
         (Text:'Set soundcard DMA channel'; Val:5),
         (Text:'Notes of interest'; Val:6),
         (Text:'Exit to DOS'; Val:$FFFF)
   );
PROCEDURE MainMenu;
  VAR
     ch : WORD;
     i  : INTEGER;
  BEGIN
     ch := 0;
     IF cfg.SoundDevice = DEV_INVALID THEN BEGIN
        cfg.SoundDevice := NONE;
        SelectDevice;
        ChooseRate;
        SetPort;
        SetIRQ;
        SetDMA
     END;
     REPEAT
        DumpDevice(CFG2Text);
        ClearMenu(mm^);
        FOR i := 1 TO 8 DO
           AddItem(mm^, mainit[i]);
        ch := DoMenu(mm^, ch);
        CASE ch OF
           1 : SelectDevice;
           2 : ChooseRate;
           3 : SetPort;
           4 : SetIRQ;
           5 : SetDMA;
           6 : ReadText;
           $FFFF : BEGIN EndScreen; HALT(1); END;
        END;
     UNTIL ch = 0;
  END;


PROCEDURE Usage;
   BEGIN
      WriteLn(#13#10'     This demo detects the soundcard settings via the environment variables',
              #13#10'BLASTER and ULTRASND. If that fails, it will ask you.');

      WriteLn(#13#10'     After first running this demo, a file called DVT.CFG will contain',
              #13#10'the sound settings. Then you can execute  the demo again, passing something',
              #13#10'as a parameter, and the demo will run without going thru the setup process.',
              #13#10'This is useful in a slideshow, for example.');

      WriteLn(#13#10'     Arbitrary greetings JMP to: Nstor Matas, Carlos Fernandez Sanz,  Paco',
              #13#10'Carrascosa, Patxi O''larte ;-D, Ascanio Bros, Mario Elkati, Juananton Roque,',
              #13#10'Marcos Sagrado ("party member" of Iguana :)), Manuel Petit, Oscar G, Javier',
              #13#10'Olmo, Alejandro Lopez, Antonio Ropero, and all other people that has helped',
              #13#10'in the development of the VangeliSTracker.  Modplaying greetings JMP to the',
              #13#10'creators of the great Visual Player. Looking forward to see VP version 3...');

      Write  (#13#10'     Group greetings to: <odeNation, Postumum (still alive), Capt.Bit/Eniac',
              #13#10'Dust, Gore and all Future Crew, Triton, Silents PC, Renaissance (and ex-ren',
              #13#10'Tran and White  Shadow), Timo and Xography, Cascada, Dan Potter, Pallbearer',
              #13#10'Chicken and Pentagon, EMF, Avalanche, Avatar, Irresistible  Works, Imphobia',
              #13#10'Extreme,  Epical, Darkzone, 3oo1 and  DeaD Memory, British Knights, Synergy',
              #13#10'Design, iCE, Gregg and Phantom, all at Surprise! Productions, Otto Chrons &',
              #13#10'Virtual Visions, etc. If you''re not in this list, feel free to add yourself');

      HALT(1);
   END;


VAR
   fcfg : FILE OF TCfg;
   fvto : TEXT;
   i, j : INTEGER;
   s    : STRING;

CONST
   VTDevs : ARRAY [TDevices] OF STRING = (
         'DMA-SB-Stereo',
         'DMA-SB-Mono',
         'DMA-SB-Stereo',
         'DMA-SB-Mono',
         'DMA-SB-Mono',
         'GUS',
         'DMA-SB-Mono',
         'Silence',
         'Silence'    (* If you don't know which card, then no card. *)
   );

CONST
   ThereIsCfg : BOOLEAN = FALSE;


BEGIN
   WriteLn('DemoVT example (C) 1993 by Iguana/VangeliSTeam'#13#10,
           '   Use DVT /? to see the help text.'#13#10);

   IF ParamCount > 0 THEN
      FOR j := 1 TO ParamCount DO BEGIN
         s := ParamStr(j);
         FOR i := 1 TO Length(s) DO
            IF (s[i] = '?') OR (UpCase(s[i]) = 'H') THEN
               Usage
      END;

   CheckFilesOK;

   Assign(fcfg, 'DVT.CFG');
   Reset(fcfg);
   IF IOResult = 0 THEN BEGIN
      ThereIsCfg := TRUE;
      Read(fcfg, cfg);
      Close(fcfg)
   END ELSE
      DetectSoundEnvironment(cfg);

   Assign(fvto, 'DVT.VTO');
   ReWrite(fvto);
   WriteLn(fvto, '; This file is generated by the DemoVT setup program.');
   WriteLn(fvto);
   Close(fvto);
   IF IOResult <> 0 THEN BEGIN
      Erase(fvto);
      WriteLn;
      WriteLn('I need at least 2 clusters of disk space to run the demo.');
      WriteLn('Reboot during the demo if you feel curious about it, but give me that space.');
      HALT(1);
   END;
   Erase(fvto);

   IF (ParamCount < 1) OR NOT ThereIsCfg THEN BEGIN
      IF NOT IsVGA THEN BEGIN
         WriteLn(#13'                                              ');
         WriteLn('I think you don''t have the required VGA card.');
         Write(' Continue anyway? (y/N) ');
         IF UpCase(CHAR(GetKey)) <> 'Y' THEN BEGIN
            WriteLn;
            WriteLn('Go buy a cool ET-4000 or something like that.');
            HALT(1)
         END
      END;

      IF NOT Is386 THEN BEGIN
         WriteLn(#13'                                              ');
         WriteLn('I can''t find a 386SX or higher in your machine. I need one.');
         Write(' Continue anyway? (y/N) ');
         IF UpCase(CHAR(GetKey)) <> 'Y' THEN BEGIN
            WriteLn;
            WriteLn('Have a sad DOS (without a 386 it sure will be).');
            HALT(1)
         END
      END;

      IF IsProtMode THEN BEGIN
         WriteLn(#13'                                              ');
         WriteLn('You are running in protected mode (EMM386, QEMM, Windows, OS/2, DesqView).'#13#10,
                 'It might slow down the demo or cause some flickery.');
         Write(' Continue anyway? (Y/n) ');
         IF UpCase(CHAR(GetKey)) = 'N' THEN BEGIN
            WriteLn;
            WriteLn('Reboot with a clean DOS (you can use HIMEM).');
            HALT(1)
         END
      END;

      ASM
        MOV  AX,3
        INT  10h
      END;

      InitScreen;
      SplitIn;

      MainMenu;

      SplitOut;
      EndScreen;

      Assign(fcfg, 'DVT.CFG');
      ReWrite(fcfg);
      IF IOResult = 0 THEN BEGIN
         Write(fcfg, cfg);
         Close(fcfg)
      END;

      IF (cfg.SoundDevice = NONE) AND HasMouse THEN BEGIN
         WriteLn('You have selected silent mode, but your mouse driver may cause conflicts.');
         WriteLn('If you experience any problems, you must remove the mouse driver.');
         Write(' Continue anyway? (Y/n) ');
         IF UpCase(CHAR(GetKey)) = 'N' THEN BEGIN
            WriteLn;
            WriteLn('Reboot without the mouse driver.');
            HALT(1)
         END;
         WriteLn(#13'                                              ');
      END;
   END;

   Assign(fvto, 'DVT.VTO');
   ReWrite(fvto);
   WriteLn(fvto, '; This file is generated by the DemoVT setup program.');
   WriteLn(fvto);

     (* First we set the sound options for DemoVT.   *)

   WriteLn(fvto, '/d:', VTDevs[cfg.SoundDevice]);
   WriteLn(fvto, '/port:', cfg.Port);
   WriteLn(fvto, '/irq:', cfg.IRQ);
   WriteLn(fvto, '/dma:', cfg.DMA);
   WriteLn(fvto, '/f:', cfg.ReplayRate);
   WriteLn(fvto);

     (* Then we place each MOD and the program that runs under it.   *)

   WriteLn(fvto, '/nobf');
   WriteLn(fvto, '/v:80');
   WriteLn(fvto, '  DVT.003 /off:2430          /sh:DVT.003');
(*
   WriteLn(fvto, '/ inconexi.mus /off:42380         /sh:inconexi.006');
   WriteLn(fvto, '/ inconexi.mus /off:105614        /sh:inconexi.007');
   WriteLn(fvto, '/ inconexi.mus /off:239518 /v:128 /sh:inconexi.015');
*)
   Close(fvto)
END.

