{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O-,R-,S-,V-,X+}
UNIT Output;

   (* Copyright by Jare/Iguana in 1993, but given to the public domain. *)
   (* Want more comments? Write'em!                                     *)

   (*   Performs screen output functions tailor-made for this setup. I  *)
   (* don't see much of this unit reused for other programs, but anyway *)
   (* who knows?                                                        *)


INTERFACE

PROCEDURE InitScreen;

PROCEDURE EndScreen;

PROCEDURE DumpLine(s : STRING; col : BYTE; y : BYTE);

PROCEDURE DumpDevice(s : STRING);

PROCEDURE ClearArea;

PROCEDURE ClearScreen(VAR p); 

PROCEDURE DumpScreen(VAR p);

PROCEDURE SetScanStart(i : WORD);

PROCEDURE SplitOut;

PROCEDURE SplitIn;



TYPE
   TScr = ARRAY [1..25*8,1..80,0..1] OF BYTE;

VAR
   scr : TScr ABSOLUTE $B800:0;

CONST
   lens : ARRAY [1..13] OF INTEGER = (
      47,
      42, 42, 42, 42,
      58, 58, 58, 58, 58, 58,
      58, 58);

   defcol = 6*16+15;



   (* ========================================= *)

IMPLEMENTATION

USES Gfx;


PROCEDURE InitScreen;
  BEGIN
     ASM
        CLD
        PUSH ES
        MOV  AX,3
        INT  10h
        MOV  AX,SEG(scr)
        MOV  ES,AX
        MOV  CX,80*25*4
        XOR  DI,DI
        XOR  AX,AX
        REP STOSW
        POP  ES
     END;
  {   SetScrStart(80*25*2)}
  END;

PROCEDURE EndScreen;
  BEGIN
     ASM
        MOV  AX,3
        INT  10h
     END
  END;




PROCEDURE DumpLine(s : STRING; col : BYTE; y : BYTE);
  VAR
     i : BYTE;
     len : INTEGER;
  BEGIN
     IF (y >= 13) THEN EXIT;
     INC(y);
     IF (col = 0) THEN col := defcol;
     IF (Length(s) < lens[y]) THEN
        len := Length(s)
     ELSE
        len := lens[y];

     FOR i := 1 TO len DO BEGIN
         Scr[9+y, 8+i, 0] := BYTE(s[i]);
         Scr[9+y, 8+i, 1] := col
     END;
     IF len < Lens[y] THEN
        FOR i := len+1 TO Lens[y] DO BEGIN
           Scr[9+y, 8+i, 0] := 32;
           Scr[9+y, 8+i, 1] := col
        END;
  END;


PROCEDURE DumpDevice(s : STRING);
  VAR
     i : INTEGER;
  BEGIN
     FOR i := 1 TO Length(s) DO BEGIN
         Scr[24, i, 0] := BYTE(s[i]);
         Scr[24, i, 1] := 2
     END;
     IF Length(s) < 80 THEN
        FOR i := Length(s)+1 TO 80 DO BEGIN
           Scr[24, i, 0] := 32;
           Scr[24, i, 1] := 2
        END;
  END;

PROCEDURE ClearArea;
  VAR
     i,j : BYTE;
  BEGIN
     FOR i := 1 TO 13 DO
        FOR j := 1 TO lens[i] DO BEGIN
           Scr[9+i, 8+j, 0] := 32;
           Scr[9+i, 8+j, 1] := defcol
        END;
  END;


PROCEDURE ClearScreen(VAR p); ASSEMBLER;
  ASM
       CLD
       PUSH ES
       LES DI,p
       MOV CX,80*25
       XOR AX,AX
       REP STOSW
       POP ES
  END;


PROCEDURE DumpScreen(VAR p); ASSEMBLER;
  ASM
       CLD
       PUSH ES
       PUSH DS
       MOV AX,CS
       MOV DS,AX
       MOV SI,OFFSET @@scr
       LES DI,p
       MOV CX,80*25
       REP MOVSW
       POP DS
       POP ES
       JMP @@bye
     @@scr:

; (*----- File created with BIN2DB from file setup.pan. -----*)

 DB 32,0,218,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30
 DB 196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30
 DB 196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30
 DB 196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30
 DB 196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30
 DB 196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30
 DB 196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30
 DB 196,30,196,30,191,30,32,15,32,15,32,15,32,15,32,15,32,15,32,15
 DB 32,0,179,30,32,30,219,26,219,26,219,26,219,26,219,26,219,26,220,26
 DB 32,26,32,26,32,26,32,26,32,26,32,26,32,26,32,26,32,26,32,26
 DB 32,26,32,26,32,26,32,26,32,26,32,26,32,26,32,26,32,26,32,26
 DB 32,26,32,26,32,26,32,26,32,26,32,26,32,26,32,26,32,26,32,26
 DB 32,26,32,26,32,26,32,26,32,26,32,26,32,26,32,26,32,26,219,26
 DB 219,26,32,26,32,26,32,26,32,26,32,26,32,26,32,26,219,26,219,26
 DB 32,26,219,26,219,26,219,26,219,26,219,26,219,26,219,26,219,26,219,26
 DB 219,26,32,30,179,30,32,15,32,15,32,15,32,15,32,15,32,15,32,15
 DB 32,0,179,30,32,30,219,26,219,26,32,26,32,26,32,26,223,26,219,26
 DB 219,26,32,26,32,26,219,26,219,26,219,26,219,26,219,26,219,26,219,26
 DB 32,26,32,26,219,26,219,26,220,26,32,26,32,26,32,26,220,26,219,26
 DB 219,26,32,26,32,26,32,26,220,26,219,26,219,26,219,26,219,26,219,26
 DB 220,26,32,26,32,26,32,26,32,26,32,26,32,26,32,26,32,26,223,26
 DB 219,26,219,26,32,26,32,26,32,26,32,26,32,26,219,26,219,26,223,26
 DB 32,26,32,26,32,26,32,26,32,26,219,26,219,26,32,26,32,26,32,26
 DB 32,26,32,30,179,30,32,15,32,15,32,15,32,15,32,15,32,15,32,15
 DB 32,0,179,30,32,30,219,26,219,26,32,26,32,26,32,26,32,26,219,26
 DB 219,26,32,26,32,26,219,26,219,26,220,26,220,26,220,26,32,26,32,26
 DB 32,26,32,26,219,26,219,26,219,26,219,26,220,26,219,26,219,26,219,26
 DB 219,26,32,26,32,26,219,26,219,26,223,26,32,26,32,26,32,26,223,26
 DB 219,26,219,26,32,26,32,26,220,26,220,26,220,26,220,26,32,26,32,26
 DB 223,26,219,26,219,26,32,26,32,26,32,26,219,26,219,26,223,26,32,26
 DB 32,26,32,26,32,26,32,26,32,26,219,26,219,26,32,26,32,26,32,26
 DB 32,26,32,30,179,30,196,60,196,60,196,60,196,60,196,60,196,60,191,60
 DB 32,0,179,30,32,30,219,18,219,18,32,18,32,18,32,18,220,18,219,18
 DB 219,18,32,18,32,18,219,18,219,18,223,18,223,18,223,18,32,18,32,18
 DB 32,18,32,18,219,18,219,18,32,18,223,18,219,18,223,18,32,18,219,18
 DB 219,18,32,18,32,18,219,18,219,18,220,18,32,18,32,18,32,18,220,18
 DB 219,18,219,18,32,18,32,18,223,18,223,18,223,18,223,18,32,18,32,18
 DB 32,18,223,18,219,18,219,18,32,18,219,18,219,18,223,18,32,18,32,18
 DB 32,18,32,18,32,18,32,18,32,18,219,18,219,18,32,18,32,18,32,18
 DB 32,18,32,18,179,30,32,60,32,60,32,60,32,60,32,60,32,60,179,60
 DB 32,0,179,30,32,30,219,18,219,18,219,18,219,18,219,18,219,18,223,18
 DB 32,18,32,18,32,18,219,18,219,18,219,18,219,18,219,18,219,18,219,18
 DB 32,18,32,18,219,18,219,18,32,18,32,18,32,18,32,18,32,18,219,18
 DB 219,18,32,18,32,18,32,18,223,18,219,18,219,18,219,18,219,18,219,18
 DB 223,18,32,18,32,18,32,18,32,18,32,18,32,18,32,18,32,18,32,18
 DB 32,18,32,18,223,18,219,18,219,18,219,18,223,18,32,18,32,18,32,18
 DB 32,18,32,18,32,18,32,18,32,18,219,18,219,18,32,18,32,18,32,18
 DB 32,18,32,18,179,30,32,60,32,60,32,60,32,60,32,60,32,60,179,60
 DB 32,0,192,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30
 DB 196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30
 DB 196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30
 DB 196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30
 DB 196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30
 DB 196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30
 DB 196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30,196,30
 DB 196,30,196,30,217,30,32,60,32,60,32,60,32,60,32,60,32,60,179,60
 DB 32,0,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15
 DB 32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15
 DB 32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15
 DB 32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15
 DB 32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15
 DB 32,15,32,15,32,15,32,15,32,15,179,60,32,48,32,48,84,48,104,48
 DB 101,48,32,48,86,48,97,48,110,48,103,48,101,48,108,48,105,48,83,48
 DB 84,48,101,48,97,48,109,48,32,48,104,48,97,48,115,48,32,60,179,60
 DB 32,0,32,15,32,15,32,15,32,15,32,15,32,15,201,106,205,106,205,106
 DB 205,106,205,106,205,106,205,106,205,106,205,106,205,106,205,106,205,106,205,106
 DB 205,106,205,106,205,106,205,106,205,106,205,106,205,106,205,106,205,106,205,106
 DB 205,106,205,106,205,106,205,106,205,106,205,106,205,106,205,106,205,106,205,106
 DB 205,106,205,106,205,106,205,106,205,106,205,106,205,106,205,106,205,106,205,106
 DB 205,106,205,106,205,106,205,106,205,106,179,60,32,48,102,48,105,48,110,48
 DB 97,48,108,48,108,48,121,48,32,48,32,48,114,48,101,48,108,48,101,48
 DB 97,48,115,48,101,48,100,48,32,48,116,48,104,48,101,48,32,60,179,60
 DB 32,0,32,15,32,15,32,15,32,15,32,15,32,15,186,106,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,179,60,32,48,68,48,101,48,109,48
 DB 111,48,86,48,84,48,32,48,109,48,117,48,115,48,105,48,99,48,32,48
 DB 115,48,121,48,115,48,116,48,101,48,109,48,46,48,32,48,32,48,179,60
 DB 32,0,32,15,32,15,32,15,32,15,32,15,32,15,186,106,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 218,60,196,60,196,60,196,60,196,60,217,60,32,48,73,48,116,48,32,48
 DB 99,48,97,48,110,48,32,48,98,48,101,48,32,48,102,48,114,48,101,48
 DB 101,48,108,48,121,48,32,48,117,48,115,48,101,48,100,48,32,48,179,60
 DB 32,0,32,15,32,15,32,15,32,15,32,15,32,15,186,106,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 179,60,32,48,105,48,110,48,32,48,110,48,111,48,110,48,45,48,99,48
 DB 111,48,109,48,109,48,101,48,114,48,99,48,105,48,97,48,108,48,32,48
 DB 112,48,114,48,111,48,106,48,101,48,99,48,116,48,115,48,32,48,179,60
 DB 32,0,32,15,32,15,32,15,32,15,32,15,32,15,186,106,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 179,60,32,48,97,48,110,48,100,48,32,48,100,48,101,48,109,48,111,48
 DB 110,48,115,48,116,48,114,48,97,48,116,48,105,48,111,48,110,48,115,48
 DB 46,48,32,48,32,48,32,48,32,48,32,48,32,48,32,48,32,48,179,60
 DB 32,0,32,15,32,15,32,15,32,15,32,15,32,15,186,106,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 192,60,196,60,196,60,196,60,196,60,196,60,196,60,196,60,196,60,196,60
 DB 196,60,196,60,196,60,196,60,196,60,196,60,196,60,196,60,196,60,196,60
 DB 196,60,196,60,196,60,196,60,196,60,196,60,196,60,196,60,196,60,217,60
 DB 32,0,32,15,32,15,32,15,32,15,32,15,32,15,186,106,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,186,106,32,15,32,15,32,15
 DB 32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15
 DB 32,0,32,15,32,15,32,15,32,15,32,15,32,15,186,106,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,186,106,32,15,32,15,32,15
 DB 32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15
 DB 32,0,32,15,32,15,32,15,32,15,32,15,32,15,186,106,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,186,106,32,15,32,15,32,15
 DB 32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15
 DB 32,0,32,15,32,15,32,15,32,15,32,15,32,15,186,106,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,186,106,32,15,32,15,32,15
 DB 32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15
 DB 32,0,32,15,32,15,32,15,32,15,32,15,32,15,186,106,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,186,106,32,15,32,15,32,15
 DB 32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15
 DB 32,0,32,15,32,15,32,15,32,15,32,15,32,15,186,106,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,186,106,32,15,32,15,32,15
 DB 32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15
 DB 32,0,32,15,32,15,32,15,32,15,32,15,32,15,186,106,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,186,106,32,15,32,15,32,15
 DB 32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15
 DB 32,0,32,15,32,15,32,15,32,15,32,15,32,15,186,106,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111,32,111
 DB 32,111,32,111,32,111,32,111,32,111,32,111,186,106,32,15,32,15,32,15
 DB 32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15
 DB 32,0,32,15,32,15,32,15,32,15,32,15,32,15,200,106,205,106,205,106
 DB 205,106,205,106,205,106,205,106,205,106,205,106,205,106,205,106,205,106,205,106
 DB 205,106,205,106,205,106,205,106,205,106,205,106,205,106,205,106,205,106,205,106
 DB 205,106,205,106,205,106,205,106,205,106,205,106,205,106,205,106,205,106,205,106
 DB 205,106,205,106,205,106,205,106,205,106,205,106,205,106,205,106,205,106,205,106
 DB 205,106,205,106,205,106,205,106,205,106,205,106,205,106,205,106,205,106,205,106
 DB 205,106,205,106,205,106,205,106,205,106,205,106,188,106,32,15,32,15,32,15
 DB 32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15
 DB 32,0,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15
 DB 32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15
 DB 32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15
 DB 32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15
 DB 32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15
 DB 32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15
 DB 32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15
 DB 32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15,32,15
 DB 32,8,32,8,32,8,32,8,32,8,32,8,32,8,32,8,32,8,32,8
 DB 32,8,32,8,32,8,32,8,32,8,32,8,32,8,32,8,32,8,32,8
 DB 32,8,32,8,32,8,32,15,32,15,32,15,32,15,32,15,68,8,101,8
 DB 109,8,111,8,86,8,84,8,32,8,105,8,115,8,32,8,40,8,67,8
 DB 41,8,255,8,67,8,111,8,112,8,121,8,114,8,105,8,103,8,104,8
 DB 116,8,32,8,49,8,57,8,57,8,50,8,45,8,57,8,51,8,32,8
 DB 98,8,121,8,32,8,116,8,104,8,101,8,32,8,86,8,97,8,110,8
 DB 103,8,101,8,108,8,105,8,83,8,84,8,101,8,97,8,109,8,46,8

     @@bye:
  END;


PROCEDURE SetScanStart(i : WORD);
  VAR
     j : INTEGER;
  BEGIN
     WaitForDisplay;
     SetScrStart(((i DIV 16))*80);
     WaitForRetrace;
     PresetRowScan(i);
  END;


CONST
   wh : BOOLEAN = TRUE;
PROCEDURE SetSplitScan(s : INTEGER);
   VAR
      i : WORD;
   BEGIN
      IF wh THEN
         i := s
      ELSE
         i := 2*25*16-s;
      SetScanStart(i);
      wh := NOT wh
   END;

VAR
   Poss  : ARRAY [1..100] OF WORD;
   NPoss : INTEGER;


PROCEDURE SplitOut;
  VAR
     i   : INTEGER;
  BEGIN
     DumpScreen(scr[26]);
     SetScanStart(25*16);
     ClearScreen(scr[1]);
     ClearScreen(scr[51]);

     FOR i := 1 TO NPoss DO
        SetSplitScan(Poss[i]);
  END;


PROCEDURE SplitIn;
  VAR
     i : INTEGER;
  BEGIN
     DumpScreen(scr[26]);
     ClearScreen(scr[1]);
     ClearScreen(scr[51]);
     FOR i := NPoss DOWNTO 1 DO
        SetSplitScan(Poss[i]);

     DumpScreen(scr[1]);
     SetScanStart(0);
     ClearScreen(scr[26])
  END;


VAR
   vel, i, n : INTEGER;

BEGIN
   n := 1;
   vel := 0;
   i := 25*16;
   REPEAT
      Poss[n] := i;
      i := i - vel DIV 5;
      vel := vel+1;
      INC(n);
   UNTIL i <= 0;
   NPoss := n-1;
END.

