/*---------------------------------------
   EMF12.C -- Enhanced Metafile Demo #12
              (c) Charles Petzold, 1994
  ---------------------------------------*/

#include <windows.h>
#include <string.h>

char szClass [] = "EMF12" ;
char szTitle [] = "EMF12: Enhanced Metafile Demo #12" ;

void DrawRuler (HDC hdc, int cx, int cy)
     {
     char    ch ;
     HFONT   hFont ;
     int     i, iHeight ;
     LOGFONT lf ;

     Rectangle (hdc, 0, 0, cx + 1, cy + 1) ;

     for (i = 0 ; i < 96 ; i++)
          {
               if (i % 16 == 0) iHeight = cy /  2 ;    // inches
          else if (i %  8 == 0) iHeight = cy /  3 ;    // half inches
          else if (i %  4 == 0) iHeight = cy /  5 ;    // quarter inches
          else if (i %  2 == 0) iHeight = cy /  8 ;    // eighths
          else                  iHeight = cy / 12 ;    // sixteenths

          MoveToEx (hdc, i * cx / 96, 0, NULL) ;
          LineTo   (hdc, i * cx / 96, iHeight) ;
          }

     memset (&lf, 0, sizeof (lf)) ;

     lf.lfHeight = cy / 2 ;

     strcpy (lf.lfFaceName, "Times New Roman") ;

     hFont = CreateFontIndirect (&lf) ;

     SelectObject (hdc, hFont) ;
     SetTextAlign (hdc, TA_BOTTOM | TA_CENTER) ;
     SetBkMode    (hdc, TRANSPARENT) ;

     for (i = 1 ; i <= 5 ; i++)
          {
          ch = (char) (i + '0') ;

          TextOut (hdc, i * cx / 6, cy / 2, &ch, 1) ;
          }

     SelectObject (hdc, GetStockObject (SYSTEM_FONT)) ;
     DeleteObject (hFont) ;
     }

void CreateRoutine (HWND hwnd)
     {
     HDC          hdcEMF ;
     HENHMETAFILE hemf ;

     hdcEMF = CreateEnhMetaFile (NULL, "emf12.emf", NULL,
                                 "EMF12\0EMF Demo #12\0") ;

     SetMapMode (hdcEMF, MM_LOENGLISH) ;

     DrawRuler (hdcEMF, 600, 100) ;

     hemf = CloseEnhMetaFile (hdcEMF) ;

     DeleteEnhMetaFile (hemf) ;
     }

void PaintRoutine (HWND hwnd, HDC hdc, int cxArea, int cyArea)
     {
     ENHMETAHEADER emh ;
     HENHMETAFILE  hemf ;
     int           cxMms, cyMms, cxPix, cyPix, cxImage, cyImage ;
     RECT          rect ;

     cxMms = GetDeviceCaps (hdc, HORZSIZE) ;
     cyMms = GetDeviceCaps (hdc, VERTSIZE) ;
     cxPix = GetDeviceCaps (hdc, HORZRES) ;
     cyPix = GetDeviceCaps (hdc, VERTRES) ;

     hemf = GetEnhMetaFile ("emf12.emf") ;

     GetEnhMetaFileHeader (hemf, sizeof (emh), &emh) ;

     cxImage = emh.rclFrame.right - emh.rclFrame.left ;
     cyImage = emh.rclFrame.bottom - emh.rclFrame.top ;

     cxImage = cxImage * cxPix / cxMms / 100 ;
     cyImage = cyImage * cyPix / cyMms / 100 ;

     rect.left   = (cxArea - cxImage) / 2 ;
     rect.top    = (cyArea - cyImage) / 2 ;
     rect.right  = (cxArea + cxImage) / 2 ;
     rect.bottom = (cyArea + cyImage) / 2 ;

     PlayEnhMetaFile (hdc, hemf, &rect) ;

     DeleteEnhMetaFile (hemf) ;
     }
