*************************************************************************
*                                                                       *
*                       **   **   ****  *****                           *
*                       * * * *  *      *                               *
*                       *  *  *  *  **  ***                             *
*                       *     *  *   *  *                               *
*                       *     *   ****  *****                           *
*                                                                       *
*                   MGE - My Grob Editor -  v 1.0                       *
*                         (c) September 1996                            *
*                                                                       *
*   Iigo Serna Robledo             Telephone: 34 -(9)4 - 430.40.28     *
*   Avda. de los Chopos 41, 2C      E-mail: imaseroi@s835cc.bi.ehu.es   *
*   48.990 - GETXO ( BIZKAIA )                                          *
*         BASQUE COUNTRY                                                *
*             SPAIN                                                     *
*                                                                       *
*************************************************************************


*********
* MGE.S	*
*********

ASSEMBLE

* Unsupported entries
SYSSTOF		EQU	#1C731
ONEPOS$		EQU	#15EF6
STOPLOOP	EQU	#07321
ARCLIST		EQU	#4FD2C

=GPDropLoop	EQU	#62467
=OUTCIN		EQU	#01EEC

RPL

********************************

xROMID 974
xTITLE MGE - My Grob Editor 1.0\n      (c) September 1996\n      I\F1igo Serna\n      imaseroi@s835cc.bi.ehu.es
xCONFIG LibCfg3CE

********************************

EXTERNAL xMGE
EXTERNAL xFILL
EXTERNAL xPATS
EXTERNAL xPATPOS
EXTERNAL xPATGROBS
EXTERNAL xOrder
EXTERNAL xToBak
EXTERNAL xGetStr
EXTERNAL xGetStr1
EXTERNAL xShwMsg
EXTERNAL xSavArea
EXTERNAL xRstArea
EXTERNAL xSetAnns
EXTERNAL xChkGrb&!

******************************** 

LABEL LibCfg3CE
   :: 974 TOSRRP ;

********************************

*************************************************
* MGE: This is the main routine
*      It controls the display and key
*************************************************

xNAME MGE
::

* Check stack for grobs

 ::
  DEPTH

  ZERO #=casedrop                       * Nothing in stack
  ::
   CK0NOLASTWD
   CHECKPICT
   GBUFF
   ZEROZERO MAKEGROB
  ;

  ONE #=casedrop                        * 1 argument in stack
  ::
   DUPTYPEGROB? ITE
   ::
    DUPGROBDIM
    2DUP 131 #= SWAP 64 #= ANDITE
    ::                                  * STK1 => grob
     2DROP
     CK1NOLASTWD
     CHECKPICT
     ZEROZERO MAKEGROB
    ;
    ::
     131 #> SWAP 64 #> OR ITE           * No valid grob
     ::
      CK0NOLASTWD
      CHECKPICT
      GBUFF
      ZEROZERO MAKEGROB
     ;
     ::                                 * STK1 => subgrob
      CK1NOLASTWD
      CHECKPICT
      GBUFF
      SWAP
     ;
    ;
   ;
   ::
    CK0NOLASTWD                         * No grob
    CHECKPICT
    GBUFF
    ZEROZERO MAKEGROB
   ;
  ;

  ONE #>case                            * 2 or more arguments in stack
  ::
   DUPTYPEGROB? ITE
   ::
    DUPGROBDIM
    131 #= SWAP 64 #= ANDITE
    ::
     SWAP
     DUPTYPEGROB? ITE
     ::
      DUPGROBDIM
      132 #< SWAP 65 #< ANDITE
      ::
       CK2NOLASTWD                      * STK1 => grob , STK2 => subgrob
       CHECKPICT
      ;
      ::
       SWAP                             * STK1 => grob
       CK1NOLASTWD
       CHECKPICT
       ZEROZERO MAKEGROB
      ;
     ;
     ::
      SWAP                              * STK1 => grob
      CK1NOLASTWD
      CHECKPICT
      ZEROZERO MAKEGROB
     ;
    ;
    ::
     DUPGROBDIM
     131 #> SWAP 64 #> ANDITE
     ::
      CK0NOLASTWD                       * No valid grobs
      CHECKPICT
      GBUFF
      ZEROZERO MAKEGROB
     ;
     ::
      CK1NOLASTWD                       * STK1 => subgrob
      CHECKPICT
      GBUFF
      SWAP
     ;
    ;
   ;
   ::
    CK0NOLASTWD                         * no valid grobs
    CHECKPICT
    GBUFF
    ZEROZERO MAKEGROB
   ;
  ;
 ;
* Now:  2: subgrob
*       1: grob 131x64

* Prepare lambda variables

 OVER TOTEMPOB
 1
 GROB 3A 8000051000000000000000000000000000000000000000000000000000
 HXS 10 08110041100454C7
 65 32
 ZEROZERO
 ONE
 ZERO ONEONE
 RCLSYSF
 {
  LAM grb
  LAM sgrb
  LAM grb.bak
  LAM fpat
  LAM userpat.grb
  LAM userpat
  LAM x LAM y
  LAM mx LAM my
  LAM stepsize
  LAM dot LAM menu LAM cursor
  LAM sysflags
 }
 BIND

 HXS 10 0FF0000008300880 SYSSTOF        * Save system flags
 FALSE SetAnns                          * Turn anns off
 ClrDA1IsStat TOGDISP TURNMENUOFF       * Prepare PICT display

********************************

* Main loop: control display and keys

 BEGIN

 LAM grb TOTEMPOB
 LAM x LAM y
 LAM stepsize
 LAM dot LAM menu LAM cursor

 INCLUDE DRAW.S                         * Draw and key routine

 8UNROLL                                * Save key
 ' LAM cursor STOLAM                    * Save results
 ' LAM menu STOLAM
 ' LAM dot STOLAM
 ' LAM stepsize STOLAM
 ' LAM y STOLAM
 ' LAM x STOLAM
 ' LAM grb STOLAM

* Key handler

 ::

* Info menu key ('E')
* General info about grob, position, mark, pattern, ...

  FIVE #=casedrop
  ::
   ZEROZERO
   GROB 88A 0400038000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF70FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF70FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF70F300000000000000000000000000000E70F100000000000000000003000060C30C70F080000000000000C38997000070E70870708102000F100030C38997000870660070708303008F100030C08103E078606700707087830381000030C1E913F97060E60070708DC3338107C1F0C1F913B91060660070708973338D97E3F1C0B913F91066E7007070813333899163B1C3F913E81066C30070708103338991E3F1C3E910000000000070708103F38F91C1F000008FFFFFFFFF0070708103E30F10000EFFFF7000000000007070810303008FFFF1000000000000000070708103E30E70000844C047100600000070708103E1E100802CAA20408901663300707081030C10004C48CC6043551271540070708100830000424888A045951411570070F081006000008C28884245190361570870F100001000000000000000C00000000C70F300000000000000000000000000000E70FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF70FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF70FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003020000000000000
0000000000EFFFFF70537720000000000000000000002FD3FF6054270000000000000000000000CFDDFF6057212000000000000000000000A5959D40372600000000000000000000006555DA20000000000000000000000000008B9BDD400000000000000000000000EFFFFFFFFF701100000000001020003000200000000040BDD3200000003567780BB32000000000405D550000000055273898B32000000000401545200000005621488880200000000040195500000000342678803320000000004000000000000003000000002000000000400000000000000000000000200000000040500004450000000000000020000000004052000C652000000000000020000000004020000452000008FFFFF3002000000000405200044520000800000200200000000040500004450000080000020020000000004000000000000008000002002000000000400000000000000800000200200000000040500004450000080000020020000000004052000C65200008000002002000000000402000045200000800000200200000000040220004422000080000020020000000004020000442000008FFFFF30020000000004000000000000000000000002000000000400000000000000000000000200000000040620085000008BA810110002000000000401773407720080A8A9BB3B12000000000402275844700089A81219B
822000000000404215053120088A883198822000000000403263C47600088A88311B8220000000004000010000000000000000002000000000400000000000000000000000EFFFFFFFFF70
   XYGROBDISP
   DATE TOD TIMESTR $>grob              * date
   GBUFF 22 29 GROB!
*  GARBAGE                              * Commented to avoid a large
   MEM #2/ #>$ $>grob                   * waiting if lib under port > 2
   GBUFF 22 36 GROB!
   LAM x #>$ $>grob                     * x
   GBUFF 9 43 GROB!
   LAM y #>$ $>grob                     * y
   GBUFF 9 50 GROB!
   LAM mx #>$ $>grob                    * mark x
   GBUFF 37 43 GROB!
   LAM my #>$ $>grob                    * mark y
   GBUFF 37 50 GROB!
   LAM stepsize #>$ $>grob              * step size
   GBUFF 37 57 GROB!
   LAM sgrb GBUFF 91 37 ChkGrb&!        * subgrob
   LAM fpat #0=ITE                      * selected pattern
   LAM userpat.grb   
   :: PATGROBS LAM fpat NTHCOMPDROP ;
   GBUFF 56 46 GROB!
   FLUSHKEYS
   FALSE
  ;

* Showbox (' ')
* Show a box between (x,y) and (mx,my)
* NOTE: This code has been extracted from Randy Ding's GRAPHEDIT

  FORTYEIGHT #=casedrop
  ::
   ::
    LAM x LAM y
    LAM menu #1= IT #7+
    LAM mx LAM my
    LAM menu #1= IT #7+
    ORDERXY#
    OVER5PICK #=case TOGLINE3
    3PICKOVER #=case TOGLINE3
    2OVER 4PICKOVER TOGLINE3
    4PICKOVER 2OVER TOGLINE3
    3PICK #1+ OVER#< NOTcase 4DROP
    #1- 2SWAP #1+ 4ROLL 2DUP
    6PICK TOGLINE3
    OVER 4ROLL TOGLINE3
   ;
   FALSE
  ;

* ->(x,y) ('C')
* Move to position

  THREE #=casedrop
  ::
   ::
    $ "X,Y: " TWELVE GetStr             * Get string
    DUPNULL$? IT :: DROP RDROP ;
    DUP CAR$ CHR @ EQUAL ITE            * Relative coords.?
    :: CDR$ LAM x LAM y ;
    ZEROZERO
    ROT 1LAMBIND
    1GETLAM CHR_Space ONEPOS$ #0=       * Rect. coords?
    1GETLAM CHR_Angle ONEPOS$ #0=       * Polar coords?
    AND IT
    ::
     2DROP ABND
     $ "Invalid Co-ordinates !!!"
     ShwMsg RDROP
    ;
    ::
     ' ::
        DUP 1GETSWAP #1+LAST$
        1GETLAM ROT 1_#1-SUB$
       ;
     1GETLAM CHR_Angle ONEPOS$
     DUP#0=ITE
     ::
      DROP
      1GETLAM CHR_Space ONEPOS$
      FALSE
     ;
     TRUE
     SWAPROT EVAL                       * Get 2 substrings
     palparse NOT IT                    * Check for real numbers
     ::
      7DROP
      $ "Invalid Co-ordinates !!!"
      ShwMsg
      ABND RDROP RDROP
     ;
     DUPTYPEREAL? NOT IT
     ::
      5DROP
      $ "Invalid Co-ordinates !!!"
      ShwMsg
      ABND RDROP RDROP
     ;
     SWAP
     palparse NOT IT
     ::
      7DROP
      $ "Invalid Co-ordinates !!!"
      ShwMsg
      ABND RDROP RDROP
     ;
     DUPTYPEREAL? NOT IT
     ::
      5DROP
      $ "Invalid Co-ordinates !!!"
      ShwMsg
      ABND RDROP RDROP
     ;
     ROT IT :: %CHS %POL>%REC ;         * If polar => convert
     DUP %0< ITE                        * Negative coords?
     :: %ABS COERCE ROTSWAP #- ;
     :: COERCE ROT#+ ;
     DUP # 7FFFF #>ITE                  * Check for grob limits
     DROPZERO
     ::
      DUP 63 #> IT :: DROP 63 ;
     ;
     UNROTDUP %0< ITE
     :: %ABS COERCE #- ;
     :: COERCE #+ ;
     DUP # 7FFFF #>ITE
     DROPZERO
     ::
      DUP 130 #> IT :: DROP 130 ;
     ;
     ' LAM x STOLAM                     * Finally, store new coords
     ' LAM y STOLAM
    ;
    ABND
   ;
   FALSE
  ;

* Undo Key ('D')

  FOUR #=casedrop
  ::
   LAM grb.bak ' LAM grb STOLAM
   FALSE
  ;

* Menu Key ('F')
* This key drives us to other menues

  SIX #=casedrop
    INCLUDE MENU.S

* Hot SUB key (''')

  THIRTEEN #=casedrop
  ::
   LAM grb Order SUBGROB
   ' LAM sgrb STOLAM 
   FALSE
  ;
  
* Hot REPL Key ('STO')

  FOURTEEN #=casedrop
  ::
   ToBak
   LAM sgrb LAM grb LAM x LAM y
   ChkGrb&!
   FALSE
  ;

* Mark Key ('*')
  
  THIRTYNINE #=casedrop
  ::
   LAM x ' LAM mx STOLAM
   LAM y ' LAM my STOLAM
   FALSE
  ;

* Exit key ('<=')
  
  TWENTYNINE #=case
    TRUE
 ;

 UNTIL

* End of main loop 
 
********************************

* Exit
 
 ZEROZERO LAM grb XYGROBDISP            * Store grob in PICT
 LAM sgrb LAM grb                       * subgrob => STK2 , grob => STK1
 LAM sysflags SYSSTOF                   * Recover initial system flags
 ABND
 TRUE SetAnns                           * Turn anns on
 %2 InitMenu%                           * VAR menu
 TURNMENUON TOADISP RECLAIMDISP         * Stack diplay
;


*************************************************************************
*************************************************************************

*************************************************
* FILL: Fill routine
*       This routine has been extracted from
*       Randy Ding's GRAPHEDIT
*************************************************

NULLNAME FILL
::
 DUP ' LAM fpat STOLAM                  * Store pattern number
 TURNMENUOFF
 ToBak                                  * Store grob for Undo
 LAM grb GBUFF ZEROZERO GROB!           * Fill in PICT
 #0=ITE                                 * User pattern?
 LAM userpat
 :: PATS LAM fpat NTHCOMPDROP ;
 LAM x LAM y
 ROT DUPTYPEBINT? ITE                   * Solid pattern?

 ::                                     * Solid fill
  DROP
  HARDBUFF GROBDIM
  4PICKOVER #<
  4PICK 4PICK #<
  AND NOTcase 4DROP
  SWAP
  CODE
LA5ECE	GOSBVL	=POP#
	R4=A
	GOSBVL	=POP#
	R3=A
	GOSBVL	=POP#
	R2=A
	GOSBVL	=POP#
	R1=A
	GOSBVL	=SAVPTR
	SETHEX
	P=	0
	C=0	W
	LC(3)	#828
	GOSBVL	=MAKE$N
	P=	0
	AD0EX
	B=A	A
	GOSBVL	=D0->Row1
	CD0EX
	D=C	A
	C=R1.F	A
	A=B	A
	D0=A
	DAT0=C	A
	C=R2.F	A
	D0=D0+	5
	DAT0=C	A
	C=R3.F	A
	D0=D0+	5
	DAT0=C	A
	C=R4.F	A
	D0=D0+	5
	DAT0=C	A
	C=0	A
	D0=D0+	5
	DAT0=C	A
	C=R3.F	A
	SB=0
	CSRB.F	A
	CSRB.F	A
	?SB=0
	GOYES	LA5F77
	C=C+1	A
LA5F77	?CBIT=0	0
	GOYES	LA5F80
	C=C+1	A
LA5F80	D0=D0+	5
	DAT0=C	A
	GOTO	LA5FEA
LA5F8A	P=	0
	LA(5)	#14
	A=A+B	A
	D0=A
	A=DAT0	A
	?A#0	A
	GOYES	LA5FAA
	GOVLNG	=GETPTRLOOP
LA5FAA	A=A-1	A
	DAT0=A	A
	A=A+A	A
	A=A+A	A
	A=A+A	A
	LC(5)	#28
	A=A+C	A
	A=A+B	A
	D0=A
	LA(5)	0
	A=A+B	A
	D1=A
	A=0	A
	P=	3
	A=DAT0	WP
	DAT1=A	A
	D0=D0+	4
	D1=D1+	5
	A=DAT0	WP
	DAT1=A	A
LA5FEA	P=	0
	ST=1	11
	ST=1	10
	ST=0	6
	LA(5)	0
	A=A+B	A
	D0=A
	C=DAT0	A
	LA(5)	#23
	A=A+B	A
	D0=A
	DAT0=C	A
	GOSUB	LA6177
	GOSUB	LA620E
	?ST=0	9
	GOYES	LA602A
	GOTO	LA5F8A
LA602A	?ST=0	5
	GOYES	LA6051
	?ST=1	11
	GOYES	LA6051
	?ST=0	8
	GOYES	LA6051
	LA(5)	5
	A=A+B	A
	D0=A
	C=DAT0	A
	C=C-1	A
	GOSUB	LA610D
LA6051	?ST=0	4
	GOYES	LA6078
	?ST=1	10
	GOYES	LA6078
	?ST=0	7
	GOYES	LA6078
	LA(5)	5
	A=A+B	A
	D0=A
	C=DAT0	A
	C=C+1	A
	GOSUB	LA610D
LA6078	LA(5)	#23
	A=A+B	A
	D0=A
	A=DAT0	A
	?ST=1	6
	GOYES	LA60D1
	?A=0	A
	GOYES	LA60A6
	A=A-1	A
	DAT0=A	A
	GOSUB	LA620E
	?ST=1	9
	GOYES	LA60A6
	GOTO	LA602A
LA60A6	LA(5)	0
	A=A+B	A
	D1=A
	LA(5)	#23
	A=A+B	A
	D0=A
	A=DAT1	A
	DAT0=A	A
	ST=1	6
	GOSUB	LA620E
LA60D1	LA(5)	#23
	A=A+B	A
	D0=A
	A=DAT0	A
	A=A+1	A
	DAT0=A	A
	LC(5)	#A
	C=C+B	A
	D0=C
	C=DAT0	A
	?C<=A	A
	GOYES	LA6109
	GOSUB	LA620E
	?ST=1	9
	GOYES	LA6109
	GOTO	LA602A
LA6109	GOTO	LA5F8A
LA610D	R0=C
	LA(5)	#14
	A=A+B	A
	D0=A
	A=DAT0	A
	LC(5)	=BITOFFSET
	?C<=A	A
	RTNYES
	A=A+1	A
	DAT0=A	A
	A=A-1	A
	A=A+A	A
	A=A+A	A
	A=A+A	A
	A=A+B	A
	LC(5)	#28
	A=A+C	A
	D1=A
	C=R0
	CSL	W
	CSL	W
	CSL	W
	CSL	W
	LA(5)	#23
	A=A+B	A
	D0=A
	P=	3
	C=DAT0	WP
	P=	7
	DAT1=C	WP
	P=	0
	RTN
LA6177	P=	0
	C=D	W
	R0=C
	LA(5)	#19
	A=A+B	A
	D0=A
	C=DAT0	A
	D=C	A
	LA(5)	5
	A=A+B	A
	D0=A
	A=DAT0	A
	ST=1	5
	ST=1	4
	?A#0	A
	GOYES	LA61B3
	ST=0	5
LA61B3	LC(5)	#F
	C=C+B	A
	D0=C
	C=DAT0	A
	C=C-1	A
	?C>A	A
	GOYES	LA61CC
	ST=0	4
LA61CC	P=	14
	C=0	A
LA61D0	SB=0
	DSRB.F	A
	?SB=0
	GOYES	LA61DF
	C=C+A	A
LA61DF	?D=0	A
	GOYES	LA61ED
	A=A+A	A
	P=P-1
	?P#	0
	GOYES	LA61D0
LA61ED	P=	0
	A=R0
	C=C+A	A
	LA(5)	#1E
	A=A+B	A
	D0=A
	DAT0=C	A
	C=R0
	D=C	W
	RTN
LA620E	P=	0
	LA(5)	#23
	A=A+B	A
	D0=A
	C=DAT0	A
	LA(5)	#1E
	A=A+B	A
	D0=A
	A=DAT0	A
	SB=0
	CSRB.F	A
	?SB=0
	GOYES	LA6243
	P=P+1
LA6243	SB=0
	CSRB.F	A
	?SB=0
	GOYES	LA6254
	P=P+1
	P=P+1
LA6254	A=A+C	A
	D1=A
	C=0	A
	C=C+1	A
LA625D	?P=	0
	GOYES	LA626B
	C=C+C	B
	P=P-1
	GOTO	LA625D
LA626B	A=B	W
	R0=A
	LA(5)	#19
	A=A+B	A
	D0=A
	A=DAT0	A
	B=A	A
	ST=0	8
	ST=0	7
	?ST=0	11
	GOYES	LA6293
	ST=1	8
LA6293	?ST=0	10
	GOYES	LA629B
	ST=1	7
LA629B	ST=0	9
	A=DAT1	P
	A=A&C	P
	?A=0	P
	GOYES	LA62AE
	ST=1	9
LA62AE	A=DAT1	P
	A=A!C	P
	DAT1=A	P
	?ST=0	5
	GOYES	LA62E9
	ST=0	11
	AD1EX
	R1=A.F	A
	A=A-B	A
	AD1EX
	A=DAT1	P
	A=A&C	P
	?A=0	P
	GOYES	LA62E0
	ST=1	11
LA62E0	A=R1.F	A
	D1=A
LA62E9	?ST=0	4
	GOYES	LA6309
	ST=0	10
	AD1EX
	A=A+B	A
	AD1EX
	A=DAT1	P
	A=A&C	P
	?A=0	P
	GOYES	LA6309
	ST=1	10
LA6309	A=R0
	B=A	W
	RTN
ENDCODE
 ;

 ::                                     * Pattern fill
  UNROT
  HARDBUFF GROBDIM
  4PICKOVER #<
  4PICK 4PICK #<
  AND NOTcase 5DROP
  SWAP
  HARDBUFF TOTEMPOB
  5UNROLL
  CODE
	GOTO	LA5ECE
ENDCODE
  FALSE HARDBUFF 3PICK ZEROZERO GROB+#
  DROPSWAP
  HARDBUFF GROBDIM SWAP
  CODE
	GOSBVL	=POP#
	R4=A
	GOSBVL	=POP#
	R3=A
	GOSBVL	#53F8D
	R2=A
	P=	0
	GOSBVL	=D0->Row1
	A=R2
	C=R3.F	A
	SB=0
	CSRB.F	A
	CSRB.F	A
	?SB=0
	GOYES	LA63F4
	C=C+1	A
LA63F4	?CBIT=0	0
	GOYES	LA63FD
	C=C+1	A
LA63FD	R3=C.F	A
	C=R4.F	A
	B=C	A
LA640B	C=R3.F	A
	D=C	A
LA6413	C=DAT0	P
	C=C&A	P
	DAT0=C	P
	D0=D0+	1
	P=P+1
	?P#	2
	GOYES	LA642B
	P=	0
LA642B	D=D-1	A
	?D#0	A
	GOYES	LA6413
	P=	0
	ASRC
	ASRC
	B=B-1	A
	?B#0	A
	GOYES	LA640B
	GOVLNG	=GETPTRLOOP
ENDCODE
  TRUE HARDBUFF ROT ZEROZERO GROB+#
  DROP
 ;

 GBUFF ' LAM grb STOLAM                 * Save grob
;


*************************************************************************
*************************************************************************

*************************************************
* PATS: Fill patterns in hxs form
*       These patterns are also from GRAPHEDIT
*************************************************

NULLNAME PATS
{
 ONE                                    * Solid fill
 HXS 10 55AA55AA55AA55AA                * 'grob-ed' fills
 HXS 10 2211884422118844
 HXS 10 4488112244881122
 HXS 10 9942249999244299
 HXS 10 5500550055005500
 HXS 10 5005288250052882
 HXS 10 98A4C28FF1432519
 HXS 10 2277220022772200
 HXS 10 F00FF00FF00FF00F
 HXS 10 55555555AAAAAAAA
 HXS 10 3DDBA4366C25DBBC
 HXS 10 66FFFF6666FFFF66
 HXS 10 0081C3E7E7C38100
 HXS 10 AAFFAAFFAAFFAAFF
 HXS 10 11AA44AA11AA44AA
}


*************************************************************************
*************************************************************************

*************************************************
* PATGROBS: List of fill pattern grobs
*           Their only utility is to choose one
*************************************************

NULLNAME PATGROBS
{
 GROB 3A 8000051000FFFFF1FFFFF1FFFFF1FFFFF1FFFFF1FFFFF1FFFFF1FFFFF1
 GROB 3A 8000051000555551AAAAA0555551AAAAA0555551AAAAA0555551AAAAA0
 GROB 3A 8000051000222220111111888880444440222220111111888880444440
 GROB 3A 8000051000444440888880111111222220444440888880111111222220
 GROB 3A 8000051000999991424240242420999991999991242420424240999991
 GROB 3A 8000051000555551000000555551000000555551000000555551000000
 GROB 3A 8000051000505050050501282820828280505050050501282820828280
 GROB 3A 8000051000989890A4A4A0C2C2C08F8F81F1F1F1434341252521191911
 GROB 3A 8000051000222220777771222220000000222220777771222220000000
 GROB 3A 8000051000F0F0F00F0F01F0F0F00F0F01F0F0F00F0F01F0F0F00F0F01
 GROB 3A 8000051000555551555551555551555551AAAAA0AAAAA0AAAAA0AAAAA0
 GROB 3A 80000510003D3D31DBDBD1A4A4A03636306C6C60252521DBDBD1BCBCB0
 GROB 3A 8000051000666660FFFFF1FFFFF1666660666660FFFFF1FFFFF1666660
 GROB 3A 8000051000000000818181C3C3C1E7E7E1E7E7E1C3C3C1818181000000
 GROB 3A 8000051000AAAAA0FFFFF1AAAAA0FFFFF1AAAAA0FFFFF1AAAAA0FFFFF1
 GROB 3A 8000051000111111AAAAA0444440AAAAA0111111AAAAA0444440AAAAA0
}


*************************************************************************
*************************************************************************

*************************************************
* PATPOS: Fill pattern positions in choosing time
*************************************************

NULLNAME PATPOS
{
 { TWENTY FOURTEEN }
 { FORTYTHREE FOURTEEN }
 { # 42 FOURTEEN }
 { # 59 FOURTEEN }
 { TWENTY TWENTYFOUR }
 { FORTYTHREE TWENTYFOUR }
 { # 42 TWENTYFOUR }
 { # 59 TWENTYFOUR }
 { TWENTY THIRTYFOUR }
 { FORTYTHREE THIRTYFOUR }
 { # 42 THIRTYFOUR }
 { # 59 THIRTYFOUR }
 { TWENTY # 2C }
 { FORTYTHREE # 2C }
 { # 42 # 2C }
 { # 59 # 2C }
}


*************************************************************************
*************************************************************************

*************************************************
* Order: Order properly x, y, mx and my
*        for subgrobs utilities
*************************************************

NULLNAME Order
::
 LAM x LAM mx 2DUP #<ITE #1+ SWAP#1+
 LAM y LAM my 2DUP #<ITE #1+ SWAP#1+
 ROTSWAP ORDERXY#
;


*************************************************************************
*************************************************************************

*************************************************
* ToBak: Make a back-up of grob for Undo
*************************************************

NULLNAME ToBak
::
 LAM grb TOTEMPOB
 ' LAM grb.bak STOLAM
;


*************************************************************************
*************************************************************************

*************************************************
* GetStr: Prepare screen for GetStr1, that is
          the real GetString routine
*************************************************

NULLNAME GetStr
::
 TRUE SetAnns                           * Turn anns on
 FIFTYTHREE SavArea                     * Clear bottom screen area
 GetStr1                                * Get string
 UnLockAlpha
 RstArea                                * Restore bottom screen area
 FALSE SetAnns                          * Turn anns off again
;


*************************************************************************
*************************************************************************

*************************************************
* GetStr1: Fill routine
*************************************************

NULLNAME GetStr1
::
 NULL$SWAP
 0 55 130 55 LINEON3
 0 54 130 54 LINEON3

* Loop for each char
 ZERO_DO
   GBUFF 0 57 130 64 GROB!ZERODRP       * Clear screen area
   2DUP &$ CHR_UndScore >T$             * Display string and cursor
   $>GROB GBUFF 0 57 ChkGrb&!
   WaitForKey                           * Get key
   DUP#1= OVER FOUR #= OR IT            * Check for special keys
   ::
    OVER TWENTYFIVE #=casedrop          * ENTER => end, return string
    ::
     2DROP SWAPDROP
     STOPLOOP FLUSHKEYS COLA
    ;
    FORTYFIVE #=casedrop                * ON => exit if null$ else null$
    ::
     2DROP NULL$? IT
     ::
      DROP NULL$ STOPLOOP
      FLUSHKEYS RDROP COLA
     ;
     NULL$
     MINUSONE INDEXSTO
     COLA LOOP
    ;
    TWENTYNINE #=case                   * <= => del last char
    ::
     2DROP
     DUPNULL$? IT
     ::
      MINUSONE INDEXSTO
      RDROP COLA LOOP
     ;
     DUPLEN$ 1_#1-SUB$
     INDEX@ #2- INDEXSTO
     COLA LOOP
    ;
   ;
   CODE                                 * Convert #key #plane => ascii
	GOSBVL	=POP2#
	RSTK=C
	GOSBVL	=SAVPTR
	C=RSTK                          * C.A = plane , A.A = key
	C=C-1	A
	C=C+C	A
	A=A-1	A
	A=A+A	A
	R0=A.F	A
	LA(5)	#31                     * 31h = 49d ( 49 keys in HP48 )
	GOSBVL	=MUL#
	A=R0.F	A
	A=A+B	A
	GOSUB	+
* Next is the table of ascii char associated with each key and plane 
* in keyboard. Each plane consists in 49d char (98 nibbles), and they
* are organized by rows. (f.e. first is '14' = '41h' = 'A', 
* '24' = '42h' = 'B', ... )
	NIBHEX	142434445464748494A409C472E4F4E8F8D835455538E58500D2540000C8738393F200435363A200132333D20003E202B2142434445464748494A4B4C4D4E4F40515253545556575850095A50000007383938292435363B5D5132333BABBD3C2C9B7142434445464748494A4B4C4D4E4F40515258848586575850095A50000007383933200435363F5001323332200D80008A3142434445464748494A4B4C4D4E4F40515253545556575850095A5000000738393F200435363A200132333D20003E202B2162636465666768696A6B6C6D6E6F60717273747576777870097A70000007383939200423A4AD500D3C398BB00D3B378D7C8FDB92939591949F9C70969725BD9E8F879899952E7A918041BC91AFB0073839332002A5A0BF500B8E3A82200D80008A3
+	C=RSTK
	C=C+A	A
	A=0	A
	D0=C
	A=DAT0	B
	GOSBVL	=PUSH#ALOOP             * Push to stack key char code
   ENDCODE
   #>CHR >T$                            * Add char to string
 LOOP

 SWAPDROP FLUSHKEYS
;


*************************************************************************
*************************************************************************

*************************************************
* ShwMsg: Show a message in bottom of screen
*         using smallest font
*         IN:   1: message_string
*************************************************

NULLNAME ShwMsg
::
 FIFTYEIGHT SavArea
 DUPLEN$
 THIRTYFOUR #>ITE
 :: THIRTYSIX 1_#1-SUB$ ;
 ::
  DUPLEN$ THIRTYFIVE SWAP#- #2/
  ZERO_DO
    CHR_Space >H$ APPEND_SPACE
  LOOP
 ;
 $>grob INVGROB
 GBUFF ZERO FIFTYNINE ChkGrb&!
 VERYSLOW VERYSLOW VERYSLOW
 VERYSLOW VERYSLOW
 RstArea
;


*************************************************************************
*************************************************************************

*************************************************
* SavArea: Save last rows of screen
*          IN:   1: #1st_row_to_be_saved
*************************************************

NULLNAME SavArea
::
 GBUFF ZERO 3PICK 131 64 SUBGROB
 { NULLLAM NULLLAM } BIND               * Save initial line and subgrob
 GBUFF 0 2GETLAM 131 64 GROB!ZERODRP    * Clear area
;


*************************************************************************
*************************************************************************

*************************************************
* RstArea: Restore previously saved screen area
*************************************************

NULLNAME RstArea
::
 2GETLAM 1GETABND                       * Get 1st line of area and subgrob
 GBUFF ZERO 4ROLL GROB!                 
;


*************************************************************************
*************************************************************************

*************************************************
* SetAnns: Turn on(TRUE) / off(FALSE) anns.
*          IN:   1: TRUE/FALSE
*************************************************

NULLNAME SetAnns
CODE
	GOSBVL	=SAVPTR
	LC(5)	=ANNCTRL
	D0=C
	GOSBVL	=popflag                * Get flag
	A=DAT0	B
	GONC	+
	LC(2)	#80                     * Anns on
	A=A!C	B
	GOTO	++
+	LC(2)	#7F                     * Anns off
	A=A&C	B
++	DAT0=A	B
	GOSBVL	=GPDropLoop
ENDCODE


*************************************************************************
*************************************************************************

*************************************************
* ChkGrb&!: Check if grob1 fits in grob2 at the
*           specified coords and modifies it if
*           it's big enough. Then, GROB!
*           IN:   4: grob1
*                 3: grob2
*                 2: #x
*                 1: #y
*************************************************

NULLNAME ChkGrb&!
::
 4ROLL UNROT CKGROBFITS
 ROT 4UNROLL GROB!
;



*************************************************************************
*************************************************************************
*************************************************************************
*************************************************************************
*************************************************************************

**********
* DRAW.S *
**********

* This is the main routine in MGE. It's coding in ML.
* This routine displays grob and main menu, move cursor,
* control stepsize, draw pixel, handle keys, ...

ASSEMBLE

sMENU	EQU	0
sDOT+	EQU	1
sDOT-	EQU	2
sCURSOR	EQU	3
sLIMIT	EQU	4

DELAY#	EQU	#2400

RPL

CODE
	GOSUBL	UpKey                   * Wait until key unpressed

	CLRST
	INTOFF                          * Disable keyboard ints
	ST=0	15

	GOSBVL	=POP2#                  * Pop MENU and CURSOR flags
	?A=0	B
	GOYES	+
	ST=1	sMENU
	GOTO	++
+	ST=0	sMENU
++	?C=0	B
	GOYES	+
	ST=1	sCURSOR
	GOTO	++
+	ST=0	sCURSOR
++	GOSBVL	=POP#                   * Pop DOT+/- flag
	?A#0	B
	GOYES	+
	ST=0	sDOT+
	ST=0	sDOT-
	GOTO	cont
+	?ABIT=0	0
	GOYES	++
	ST=1	sDOT+
	ST=0	sDOT-
	GOTO	cont
++	ST=0	sDOT+
	ST=1	sDOT-
cont	GOSBVL	=POP#                   * Pop stepsize
	R2=A.F	A
	GOSBVL	=POP2#                  * Pop x,y coords.
	R1=C.F	A
	R0=A.F	A
	GOSBVL	=SAVPTR
	A=DAT1	A
	LC(5)	20
	A=A+C	A
	R3=A.F	A                       * R3.A = @grob(0,0)
	

* Main Loop. Draw all and get key
DrLoop	?ST=1	sMENU                   * Draw menu and cursor
	GOYES	+
	GOSUBL	DrScr
	GOTO	++
+	GOSUBL	DrMenSc
++	GOSUBL	DrCurs

Sleep	D1=(5)	=TIMERCTRL.1            * Wait in sleep mode until
	LC(1)	4                       * one key is pressed
	DAT1=C	P
	D1=(2)	=TIMER1
	LC(1)	5
	DAT1=C	P
	LC(3)	#1FF
	OUT=C
-	SHUTDN
	LC(3)	#1FF
	LA(5)	#803F
	GOSBVL	=OUTCIN
	C=C&A	A
	?C#0	A
	GOYES	Keys
	D1=(2)	=TIMERCTRL.1
	C=DAT1	X
	?CBIT=0	3
	GOYES	-
	GOTO	Sleep


* Key handler	
Keys	GOSUB	KeyCr                   * Check for cursor keys

	LC(3)	1
	GOSBVL	=OUTCIN
	?CBIT=0	0	                * +: turn display off
	GOYES	++
	GOSBVL	=DispOff
-	LC(3)	#400
	LA(5)	#8000
	GOSBVL	=OUTCIN
	C=C&A	A
	?C=0	A
	GOYES	-
	GOSBVL	=DispOn
	GOTO	DrLoop
++	?CBIT=0	1	                * SPC: show box
	GOYES	+
	LC(5)	48
	GOTO	Exit
+	?CBIT=0	3	                * 0: stepsize = 10
	GOYES	++
	LC(5)	10
	R2=C.F	A
	GOSUB	UpKey
	GOTO	DrLoop
++	?CBIT=0	4
	GOYES	++
	LC(5)	13
	GOTO	Exit

++	LC(3)	2
	GOSBVL	=OUTCIN
	?CBIT=0	1	                * 3: stepsize = 3
	GOYES	+
	LC(5)	3
	R2=C.F	A
	GOSUB	UpKey
	GOTO	DrLoop
+	?CBIT=0	2	                * 2: stepsize = 2
	GOYES	++
	LC(5)	2
	R2=C.F	A
	GOSUB	UpKey
	GOTO	DrLoop
++	?CBIT=0	3	                * 1: stepsize = 1
	GOYES	+
	LC(5)	1
	R2=C.F	A
	GOSUB	UpKey
	GOTO	DrLoop

+	?CBIT=0	4	                * A: dot+
	GOYES	++
	?ST=1	sDOT+
	GOYES	+
	ST=1	sDOT+
	ST=0	sDOT-
	GOTO	L001
+	ST=0	sDOT+
L001	GOSUB	UpKey
	A=R3.F	A
	R4=A.F	A
	C=R0.F	A
	A=R1.F	A
	GOSUBL	DrPoint
	GOTO	DrLoop

++	LC(3)	4
	GOSBVL	=OUTCIN
	?CBIT=0	0	                * *: set mark
	GOYES	+
	LC(5)	39
	GOTO	Exit
+	?CBIT=0	1	                * 6: stepsize = 6
	GOYES	++
	LC(5)	6
	R2=C.F	A
	GOSUB	UpKey
	GOTO	DrLoop
++	?CBIT=0	2	                * 5: stepsize = 5
	GOYES	+
	LC(5)	5
	R2=C.F	A
	GOSUB	UpKey
	GOTO	DrLoop
+	?CBIT=0	3	                * 4: stepsize = 4
	GOYES	++
	LC(5)	4
	R2=C.F	A
	GOSUB	UpKey
	GOTO	DrLoop
++	LC(3)	8
	GOSBVL	=OUTCIN
	?CBIT=0	1	                * 9: stepsize = 9
	GOYES	+
	LC(5)	9
	R2=C.F	A
	GOSUB	UpKey
	GOTO	DrLoop
+	?CBIT=0	2	                * 8: stepsize = 8
	GOYES	++
	LC(5)	8
	R2=C.F	A
	GOSUB	UpKey
	GOTO	DrLoop
++	?CBIT=0	3	                * 7: stepsize = 7
	GOYES	+
	LC(5)	7
	R2=C.F	A
	GOSUB	UpKey
	GOTO	DrLoop

+	LC(3)	#10
	GOSBVL	=OUTCIN
	?CBIT=0	0	                * <=: exit
	GOYES	++
	LC(5)	29
	GOTO	Exit
++	?CBIT=0	2	                * EEX: toggle menu
	GOYES	+
	?ST=0	sMENU
	GOYES	++
	ST=0	sMENU
	GOTO	L002
++	ST=1	sMENU
L002	GOSUB	UpKey
	GOTO	DrLoop
+	?CBIT=0	3	                * +/-: toggle cursor
	GOYES	++
	?ST=0	sCURSOR
	GOYES	+
	ST=0	sCURSOR
	GOTO	L003
+	ST=1	sCURSOR
L003	GOSUB	UpKey
	GOTO	DrLoop
++	?CBIT=0	4	                * ENTER: xor pixel
	GOYES	+
	C=R3.F	A
	R4=C.F	A
	C=R0.F	A
	A=R1.F	A
	GOSUBL	InvPix
L004	GOSUB	UpKey
	GOTO	DrLoop

+	LC(3)	#40
	GOSBVL	=OUTCIN
	?CBIT=0	4
	GOYES	+
	LC(5)	14
	GOTO	Exit
	
+	LC(3)	#100
	GOSBVL	=OUTCIN
	?CBIT=0	0	                * F: Menu key
	GOYES	++
	LC(5)	6
	GOTO	Exit
++	?CBIT=0	1	                * E: Info key
	GOYES	+
	LC(5)	5
	GOTO	Exit
+	?CBIT=0	2	                * D: Undo key
	GOYES	++
	LC(5)	4
	GOTO	Exit
++	?CBIT=0	3	                * C: ->(x,y) key
	GOYES	+
	LC(5)	3
	GOTO	Exit
+	?CBIT=0	4	                * B: dot-
	GOYES	++
	?ST=1	sDOT-
	GOYES	+
	ST=0	sDOT+
	ST=1	sDOT-
	GOTO	L005
+	ST=0	sDOT-
L005	GOSUB	UpKey
	A=R3.F	A
	R4=A.F	A
	C=R0.F	A
	A=R1.F	A
	GOSUBL	DrPoint

++	GOTO	DrLoop                  * Go to Main Loop

*******************************

KeyEnd	C=RSTK
KeyEnd1	GOSUB	UpKey
	GOTO	DrLoop

KeyEnd2	C=RSTK
	GOTO	DrLoop

*******************************

* Cursor keys handler.
* Display cursor in next position, drawing
* or clearing points if necessary

KeyCr	LC(3)	2                       * RightShift => cursor to edge
	GOSBVL	=OUTCIN
	?CBIT=1	5
	GOYES	+
	ST=0	sLIMIT
	GOTO	KeyCr00
+	ST=1	sLIMIT

KeyCr00	A=R2.F	B                       * Recover stepsize
	B=A	B
	B=B-1	B

KeyCr01	LC(3)	#80                     * NEXT => NE
	GOSBVL	=OUTCIN
	?CBIT=0	0
	GOYES	KeyCr11
	?ST=0	sLIMIT                  * Check for RightShift
	GOYES	KeyCr02
	LA(2)	130                     * Cursor to NE edge
	R0=A.F	B
	A=0	B
	R1=A.F	B
	GOTO	KeyCr04
KeyCr02	C=R0.F	A                       * Check screen limit
	C=C+1	X
	LA(3)	130
	?C>A	X
	GOYES	KeyCr03
	A=R1.F	A
	A=A-1	X
	?ABIT=1	11
	GOYES	KeyCr03
	R0=C.F	X
	R1=A.F	X
	GOSUB	DrPoint                 * Draw/Clear point
	B=B-1	B                       * Check for loop end
	GONC	KeyCr02
KeyCr03	GOSUB	Delay                   * Delay
KeyCr04	C=RSTK                          * Return to stepsize loop
	GOTO	DrLoop

KeyCr11	LC(3)	#80                     * CursUP => N
	GOSBVL	=OUTCIN
	?CBIT=0	1
	GOYES	KeyCr21
	?ST=0	sLIMIT
	GOYES	KeyCr12
	A=0	B
	R1=A.F	B
	GOTO	KeyCr14
KeyCr12	A=R1.F	A
	A=A-1	X
	?ABIT=1	11
	GOYES	KeyCr13
	R1=A.F	X
	C=R0.F	A
	GOSUB	DrPoint
	B=B-1	B
	GONC	KeyCr12
KeyCr13	GOSUB	Delay
KeyCr14	C=RSTK
	GOTO	DrLoop

KeyCr21	LC(3)	#80                     * VAR: NW
	GOSBVL	=OUTCIN
	?CBIT=0	2
	GOYES	KeyCr31
	?ST=0	sLIMIT
	GOYES	KeyCr22
	A=0	B
	R0=A.F	B
	R1=A.F	B
	GOTO	KeyCr24
KeyCr22	C=R0.F	A
	C=C-1	X
	?CBIT=1	11
	GOYES	KeyCr23
	A=R1.F	A
	A=A-1	X
	?ABIT=1	11
	GOYES	KeyCr23
	R0=C.F	X
	R1=A.F	X
	GOSUB	DrPoint
	B=B-1	B
	GONC	KeyCr22
KeyCr23	GOSUB	Delay
KeyCr24	C=RSTK
	GOTO	DrLoop

KeyCr31	LC(3)	#40                     * CursRIGHT: E
	GOSBVL	=OUTCIN
	?CBIT=0	0
	GOYES	KeyCr41
	?ST=0	sLIMIT
	GOYES	KeyCr32
	LA(2)	130
	R0=A.F	B
	GOTO	KeyCr34
KeyCr32	C=R0.F	A
	C=C+1	X
	LA(3)	130
	?C>A	X
	GOYES	KeyCr33
	R0=C.F	X
	A=R1.F	A
	GOSUB	DrPoint
	B=B-1	B
	GONC	KeyCr32
KeyCr33	GOSUB	Delay
KeyCr34	C=RSTK
	GOTO	DrLoop

KeyCr41	LC(3)	#40                     * CursLEFT: W
	GOSBVL	=OUTCIN
	?CBIT=0	2
	GOYES	KeyCr51
	?ST=0	sLIMIT
	GOYES	KeyCr42
	A=0	B
	R0=A.F	B
	GOTO	KeyCr44
KeyCr42	C=R0.F	A
	C=C-1	X
	?CBIT=1	11
	GOYES	KeyCr43
	R0=C.F	X
	A=R1.F	A
	GOSUB	DrPoint
	B=B-1	B
	GONC	KeyCr42
KeyCr43	GOSUB	Delay
KeyCr44	C=RSTK
	GOTO	DrLoop

KeyCr51	LC(3)	#20                     * 1/x: SE
	GOSBVL	=OUTCIN
	?CBIT=0	0
	GOYES	KeyCr61
	?ST=0	sLIMIT
	GOYES	KeyCr52
	LA(2)	130
	R0=A.F	B
	LA(2)	63
	R1=A.F	B
	GOTO	KeyCr54
KeyCr52	A=R1.F	A
	A=A+1	X
	LC(3)	63
	?A>C	X
	GOYES	KeyCr53
	LC(3)	130
	D=C	X
	C=R0.F	A
	C=C+1	X
	?C>D	X
	GOYES	KeyCr53
	R0=C.F	X
	R1=A.F	X
	GOSUB	DrPoint
	B=B-1	B
	GONC	KeyCr52
KeyCr53	GOSUB	Delay
KeyCr54	C=RSTK
	GOTO	DrLoop

KeyCr61	LC(3)	#40                     * SQRT: SW
	GOSBVL	=OUTCIN
	?CBIT=0	1
	GOYES	KeyCr71
	?ST=0	sLIMIT
	GOYES	KeyCr62
	LA(2)	63
	R1=A.F	B
	GOTO	KeyCr64
KeyCr62	A=R1.F	A
	A=A+1	X
	LC(3)	63
	?A>C	X
	GOYES	KeyCr63
	R1=A.F	X
	C=R0.F	A
	GOSUB	DrPoint
	B=B-1	B
	GONC	KeyCr62
KeyCr63	GOSUB	Delay
KeyCr64	C=RSTK
	GOTO	DrLoop

KeyCr71	LC(3)	#20                     * CursDOWN: S
	GOSBVL	=OUTCIN
	?CBIT=0	2
	RTNYES
	?ST=0	sLIMIT
	GOYES	KeyCr72
	A=0	B
	R0=A.F	B
	LA(2)	63
	R1=A.F	B
	GOTO	KeyCr74
KeyCr72	A=R1.F	A
	A=A+1	X
	LC(3)	63
	?A>C	X
	GOYES	KeyCr73
	C=R0.F	A
	C=C-1	X
	?CBIT=1	11
	GOYES	KeyCr73
	R1=A.F	X
	R0=C.F	A
	GOSUB	DrPoint
	B=B-1	B
	GONC	KeyCr72
KeyCr73	GOSUB	Delay
KeyCr74	C=RSTK
	GOTO	DrLoop                  * Go to Main Loop

*******************************

* Wait till key unpressed

UpKey	LC(3)	#1FF
	LA(5)	#803F
	GOSBVL	=OUTCIN
	C=C&A	A
	?C#0	A
	GOYES	UpKey
	RTN

*******************************

* Exit
*     IN:   C.A = keycode

Exit	RSTK=C
	LA(2)	5                       * If Info or ShowBox key =>
	?C=A	B                       * allows mantainint key pressed
	GOYES	+
	LA(2)	48
	?C=A	B
	GOYES	+
	D=C	B
	GOSUB	UpKey
	C=D	B
+	LA(2)	6                       * Menu key?
	?A#C	B
	GOYES	++
	GOSUB	DrMenSc                 * If yes => disp menu and cursor
*	GOSUB	DrCurs2
++	INTON                           * Enables keyboard
	ST=1	15
	GOSBVL	=PUSH2#                 * Push x,y
	GOSBVL	=SAVPTR
	A=R2.F	A                       * Push stepsize and DOT+/- flag
	R0=A.F	A
	?ST=0	sDOT+
	GOYES	+
	LA(5)	1
	GOTO	Exit1
+	?ST=0	sDOT-
	GOYES	++
	LA(5)	2
	GOTO	Exit1
++	A=0	A
Exit1	R1=A.F	A
	GOSBVL	=PUSH2#
	GOSBVL	=SAVPTR
	?ST=0	sMENU                   * Push MENU and CURSOR flags
	GOYES	+
	LC(5)	1
	GOTO	++
+	C=0	A
++	?ST=0	sCURSOR
	GOYES	+
	LA(5)	1
	GOTO	++
+	A=0	A
++	R0=C.F	A
	R1=A.F	A
	GOSBVL	=PUSH2#
	GOSBVL	=SAVPTR
	C=RSTK
	A=C	A
	GOSBVL	=PUSH#ALOOP             * Push keycode and Exit

*****************************

* Draw grob in full screen

DrScr	GOSBVL	=D0->Row1
	A=R3.F	A
	D1=A
	LC(2)	64*34/16-1
-	A=DAT1	W
	DAT0=A	W
	D0=D0+	16
	D1=D1+	16
	C=C-1	B
	GONC	-
	RTN

*******************************

* Draw menu and partially grob

DrMenSc	GOSBVL	=D0->Row1
	GOSUB	+
	NIBHEX	EFFFF8FFFF3EFFFF8FFFF3EFFFF8FFFF309FBFF5EFEF7FFFFFD5F7F7FE7FFDEEFF705B1BF5D6CF7FD57DD533B7F6ABFD426A6055B1F55D6C778BFED55557FA25FDAABA609BBBF5EEEF7FD5BEDB53B7FAABFDE6A670EFFFF8FFFF3EFFDF8FFFF3EFFFF8FFFF300000000000000000000000000000000000
+	C=RSTK
	D1=C
	P=	16-14                   * Draw menu
-	A=DAT1	W
	DAT0=A	W
	D0=D0+	16
	D1=D1+	16
	P=P+1
	GONC	-
	A=DAT1	14
	DAT0=A	14
	D0=D0+	14
	
	A=R3.F	A                       * Calculates which part of
	D1=A                            * grob has to be showed
	LA(5)	63-7
	C=R1.F	A
	?C<=A	A
	GOYES	++
	C=C-A	A
	LA(5)	34
	B=A	A
	A=0	B
-	C=C-1	B
	GOC	+
	A=A+B	A
	GOTO	-
+	CD1EX
	A=A+C	A
	D1=A
++	LC(2)	(64-7)*34/16-1
-	A=DAT1	W
	DAT0=A	W
	D0=D0+	16
	D1=D1+	16
	C=C-1	B
	GONC	-
	A=DAT1	P
	DAT0=A	P
	
	GOSBVL	=D0->Row1               * Show if DOT+ or DOT-
	?ST=0	sDOT+
	GOYES	+
	LC(5)	34*2+4
	A=A+C	A
	AD0EX
	LA(1)	3
-	DAT0=A	P
	D0=D0+	34
	DAT0=A	P
	D0=D0+	34
	DAT0=A	P
	RTN
+	?ST=0	sDOT-
	RTNYES
	LC(5)	34*2+10
	A=A+C	A
	AD0EX
	LA(1)	4
	GOTO	-
	
********************************

* Draw Cursor

DrCurs	?ST=0	sCURSOR
	RTNYES
DrCurs2	GOSBVL	=D0->Row1
	R4=A.F	A
	C=R0.F	A
	A=R1.F	A
	GOSUB	TogPix
	C=R0.F	A
	C=C-1	X
	A=R1.F	A
	GOSUB	TogPix
	C=R0.F	A
	C=C+1	X
	A=R1.F	A
	GOSUB	TogPix
	C=R0.F	A
	A=R1.F	A
	A=A-1	X
	GOSUB	TogPix
	C=R0.F	A
	A=R1.F	A
	A=A+1	X
	GOSUB	TogPix
	RTN

********************************

* Toggle pixel (xor pixel)

TogPix	?CBIT=1	11                      * Exit if < 0 coords
	RTNYES
	?ABIT=1	11
	RTNYES
	B=A	B                       * Exit if exceed limits
	LA(2)	130
	?A<C	B
	RTNYES
	A=B	B
	RSTK=C
	LC(2)	63
	?A<=C	B
	GOYES	+
	C=RSTK
	RTN
+	?ST=1	sMENU                   * Recalculate y coord
	GOYES	++                      * if menu is activated
	C=RSTK
	GOTO	InvPix
++	LC(2)	63-7
	?A>C	B
	GOYES	+
	C=R1.F	B
	D=C	B
	LC(2)	57
	?C#D	B
	GOYES	++
	A=A-1	B
++	C=RSTK
	A=A+CON	B,7
	GOTO	InvPix
+	C=R1.F	B
	?A#C	B
	GOYES	++
	C=RSTK
	LA(5)	63
	GOTO	InvPix
++	?A>C	B
	GOYES	+
	C=RSTK
	LA(5)	62
	GOTO	InvPix
+	C=RSTK
	RTN

********************************

* Converts x,y coords in a screen address
* IN:   C.A = x                 OUT:   D0 = @grob(x,y)
*       A.A = y                        A.0 = data
*       R4.A = @disp/grob              P = times to shift

xy2addr	D=C	A
	A=A+A	X
	B=A	X
	ASL	X
	A=A+B	X
	CSRB.F	B
	CSRB.F	B
	A=A+C	X                       * A.A = 34*y + x/4 (nibb offset)
	C=R4.F	A
	A=A+C	A                       * Add screen/grob address
	D0=A                            * D0 = @grob(x,y) nibble
	A=DAT0	P                       * A.0 = data
	LC(1)	3
	C=C&D	P
	P=C	0                       * P = times to shift
	RTN

********************************

* Delay routine

Delay	LA(5)	DELAY#
-	A=A-1	A
	GONC	-
	RTN

********************************

* Invert pixel
* IN:   C.A = x
*       A.A = y
*       R4.A = @display/grob

InvPix	GOSUB	xy2addr
	?P#	0
	GOYES	InvPix1
	?ABIT=0	0
	GOYES	+
	ABIT=0	0
	GOTO	InvPix4
+	ABIT=1	0
	GOTO	InvPix4
InvPix1	?P#	1
	GOYES	InvPix2
	?ABIT=0	1
	GOYES	+
	ABIT=0	1
	GOTO	InvPix4
+	ABIT=1	1
	GOTO	InvPix4
InvPix2	?P#	2
	GOYES	InvPix3
	?ABIT=0	2
	GOYES	+
	ABIT=0	2
	GOTO	InvPix4
+	ABIT=1	2
	GOTO	InvPix4
InvPix3	?P#	3
	GOYES	InvPix4
	?ABIT=0	3
	GOYES	+
	ABIT=0	3
	GOTO	InvPix4
+	ABIT=1	3
InvPix4	P=	0
	DAT0=A	P
	RTN

********************************

* Draw or Clear pixel
* IN:   C.A = x
*       A.A = y
*       R3.A = @grob(0,0)

DrPoint	BSL	W                       * Save stepsize count
	BSL	W
	BSL	W
	BSL	W
	BSL	W
	RSTK=C
	C=R3.F	A
	R4=C.F	A                       * R4.A = @grob(0,0)
	C=RSTK
	GOSUB	xy2addr                 * Get @grob(x,y)
	?ST=1	sDOT+
	GOYES	Dot+                    * Dot+ (draw pixel)
	?ST=1	sDOT-
	GOYES	Dot-                    * Dot- (clear pixel)

DrPnt1	P=	0                       * Restore stepsize count
	DAT0=A	P
	BSR	W
	BSR	W
	BSR	W
	BSR	W
	BSR	W
	RTN                             * Return

Dot+	?P#	0                       * Dot+ (draw pixel)
	GOYES	Dot+1
	ABIT=1	0
	GOTO	DrPnt1
Dot+1	?P#	1
	GOYES	Dot+2
	ABIT=1	1
	GOTO	DrPnt1
Dot+2	?P#	2
	GOYES	Dot+3
	ABIT=1	2
	GOTO	DrPnt1
Dot+3	?P#	3
	GOYES	DrPnt1
	ABIT=1	3
	GOTO	DrPnt1

Dot-	?P#	0                       * Dot- (clear pixel)
	GOYES	Dot-1
	ABIT=0	0
	GOTO	DrPnt1
Dot-1	?P#	1
	GOYES	Dot-2
	ABIT=0	1
	GOTO	DrPnt1
Dot-2	?P#	2
	GOYES	Dot-3
	ABIT=0	2
	GOTO	DrPnt1
Dot-3	?P#	3
	GOYES	DrPnt1
	ABIT=0	3
	GOTO	DrPnt1

********************************
	
ENDCODE



*************************************************************************
*************************************************************************
*************************************************************************
*************************************************************************
*************************************************************************

**********
* MENU.S *
**********

* This is the routine that manages menues
* once we have pressed Menu Key in main
* menu. It also contains the action for
* each menu or submenu label.

::
* Selection Menu:  File  Block1  Block2 Draw  Fill
 GROB F8 7000038000EFFFF8FFFF3EFFFF8FFFF3EFFFF8FFFF30F15FF56FFE59DFB3DCFFF7F3AAFDFFFF70FD71F54BBA41DEA6DA9CA6FBFAFDFFFF70F95DF555DC55553BDAE917F3BAFDFFFF70FD53F54BBA51DEA2DCE857FBBAFDFFFF70EFFFF8FFFF3EFFFF8FFFF3EFFFF8FFFF300000000000000000000000000000000000
 GBUFF ZEROZERO GROB!

* Display cursor and mark
 LAM mx LAM my LAM x LAM y
 CODE
	GOSBVL	=POP2#
	R0=A.F	A
	R1=C.F	A
	GOSBVL	=POP2#
	R2=A.F	A
	R3=C.F	A
	GOSBVL	=SAVPTR
	ST=1	0

	GOSUBL	DrCurs2
	
	C=R2.F	A
	A=R3.F	A
	GOSUBL	TogPix
	C=R2.F	A
	C=C-1	A
	A=R3.F	A
	A=A-1	A
	GOSUBL	TogPix
	C=R2.F	A
	C=C-CON	A,2
	A=R3.F	A
	A=A-CON	A,2
	GOSUBL	TogPix
	C=R2.F	A
	C=C+1	A
	A=R3.F	A
	A=A-1	A
	GOSUBL	TogPix
	C=R2.F	A
	C=C+CON	A,2
	A=R3.F	A
	A=A-CON	A,2
	GOSUBL	TogPix
	C=R2.F	A
	C=C-1	A
	A=R3.F	A
	A=A+1	A
	GOSUBL	TogPix
	C=R2.F	A
	C=C-CON	A,2
	A=R3.F	A
	A=A+CON	A,2
	GOSUBL	TogPix
	C=R2.F	A
	C=C+1	A
	A=R3.F	A
	A=A+1	A
	GOSUBL	TogPix
	C=R2.F	A
	C=C+CON	A,2
	A=R3.F	A
	A=A+CON	A,2
	GOSUBL	TogPix

	GOSBVL	=GETPTRLOOP
ENDCODE

 WaitForKey DROP

********************************

********************
* File Submenu ('A')
********************

* Clear  Invert  Load  Save     Quit
 ONE #=casedrop
 ::
  GROB F8 7000038000EFFFF8FFFF3EFFFF8FFFF3EFFFF8FFFF307AFFF5FFFF57FFFDD3FFF7FFFFFDBFBD70BB8CC5951907F6ECD99517FFFFFD5BE870BBE9E555DD577D4DD73BD7FFFFFD5BAD707A98E55B3D57C6CCD91B37FFFFFD36BD70EFFFF8FFFF3EFFFF8FFFF3EFFFF8FFFF300000000000000000000000000000000000
  GBUFF ZEROZERO GROB!
  WaitForKey DROP

* Clear grob ('A')
  ONE #=casedrop
  ::
   ToBak                                * Bak grob for Undo
   LAM grb ZEROZERO 131 64 GROB!ZERO
   ' LAM grb STOLAM
   FALSE
  ;

* Inverse grob ('B')  
  TWO #=casedrop
  ::
   ToBak                                * Bak grob for Undo
   LAM grb INVGROB ' LAM grb STOLAM
   FALSE
  ;

* Load grob ('C')
* It uses 'CHOOSE', so it will work on GX only !!!!!

  THREE #=casedrop
  ::
   DOVARS 1LAMBIND NULL{}               * Get all vars in current dir
   1GETLAM LENCOMP #1+_ONE_DO           * Select grob131x64 only
     1GETLAM INDEX@ NTHCOMPDROP
     DUP SAFE@_HERE DROP
     CODE                               * Check for grob131x64
	GOSBVL	=SAVPTR
	A=DAT1	A
	D1=A
	A=DAT1	A
	LC(5)	=DOGROB
	?C#A	A
	GOYES	NoGrb
	D1=D1+	4
	A=DAT1	W
	LCHEX	00083000400088F0        * 131x64
	?C#A	W
	GOYES	NoGrb
	GOSBVL	=GPPushTLoop
NoGrb	GOSBVL	=GPPushFLoop
     ENDCODE
     ITE 
     :: DROP ID>$ >TCOMP ;
     2DROP
   LOOP ABND
   DUPNULLCOMP? IT
   ::                                   * If no valid grobs => exit
    DROPFALSE 
    " No Valid Grobs In Current Dir. !!! "
    ShwMsg RDROP
   ; 
   ' DROPFALSE $ "Choose File"          * GX 'choose' rompointer
   ONE 4ROLL ONE                        * to select among the grobs
   ROMPTR 0B3 0                         * 'CHOOSE'
   ITE
   ::                                   * Valid selection:
    $>ID SAFE@_HERE DROP ToBak          * load grob and store it
    ' LAM grb STOLAM TURNMENUOFF
    FALSE
   ;
   :: TURNMENUOFF FALSE ;               * No valid selection
  ;

* Save current grob ('D')  
  FOUR #=casedrop
  :: 
   "Name: " 15 GetStr                   * Get name
   DUPNULL$? IT
   ::
    DROPFALSE
    "No Grob Saved !!!"
    ShwMsg RDROP
   ;
   $>ID DUP SAFE@_HERE ITE              * Check if exists
   ::
    DROPDUP ID>$ "Overwrite "           * Ask for overwriting
    SWAP&$ "? " &$ 1 GetStr
    CAR$ CHR Y EQUAL ITE
    :: LAM grb SWAP XEQSTOID FALSE ;
    ::
     DROPFALSE
     "No Grob Saved !!!"  ShwMsg
     RDROP RDROP
    ;
   ;
   :: LAM grb SWAP XEQSTOID FALSE ;
  ;

* Exit ('F')  
  SIX #=case
    TRUE

* No menu keys
  FALSE
 ;

********************************

**********************
* Block1 Submenu ('B')
**********************

* Sub Repl VFlip DFlip     Info.subgrob
 TWO #=casedrop
 ::
  GROB F8 7000038000EFFFF8FFFF3EFFFF8FFFF3EFFFF8FFFF30F3FDFD3FFB7754DFD915F7FFFFFDBFDF70F959FDB22B77577ED5DD97FFFFFDB9EE70F755FD3BBA77465DD59557FFFFFDBA4D70F9B9FDB62B7F675ED9D597FFFFFDBAEE70EFFFF8FFBF3EFF7F8FFFD3EFFFF8FFFF300000000000000000000000000000000000
  GBUFF ZEROZERO GROB!
  WaitForKey DROP

* Subgrob ('A')  
  ONE #=casedrop
  :: 
   LAM grb Order SUBGROB
   ' LAM sgrb STOLAM
   FALSE
  ;
  
* Replace ('B')
  TWO #=casedrop
  :: 
   ToBak                                * Bak grob for Undo
   LAM sgrb LAM grb
   LAM x LAM y ChkGrb&!
   FALSE
  ;

* VFlip: vertical mirror of grob ('C')
* NOTE: This code was programmed by Robert Tiismus
*       and included in his pack 'grobflip'
  THREE #=casedrop
  ::
   LAM sgrb DUPGROBDIM 
   2DUP 2#0=OR IT :: 3DROP FALSE RDROP ;
   MAKEGROB
   SWAP
   CODE
	A=DAT1	A
	LC(5)	#14
	C=C+A	A
	RSTK=C
	D1=D1+	5
	D=D+1	A
	C=DAT1	A
	C=C+CON	A,10
	RSTK=C
	GOSBVL	=SAVPTR
	C=RSTK
	D1=C
	C=DAT1	A
	D=C	A
	D1=D1+	5
	C=DAT1	A
	D1=D1+	5
	C=C-1	A
	CSRB.F	A
	CSRB.F	A
	CSRB.F	A
	C=C+1	A
	RSTK=C
	A=C	A
	C=D	A
	GOSBVL	=MUL#
	A=B	A
	C=RSTK
	B=C	A
	A=A-C	A
	A=A+A	A
	CD1EX
	C=C+A	A
	CD1EX
	A=B	A
	A=A+A	A
	A=A+A	A
	R0=A.F	A
	D=D-1	A
	C=RSTK
	D0=C
LA9A2C	C=B	A
	C=C-1	A
LA9A30	A=DAT0	B
	DAT1=A	B
	D1=D1+	2
	D0=D0+	2
	C=C-1	A
	GONC	LA9A30
	A=R0.F	A
	CD1EX
	C=C-A	A
	CD1EX
	D=D-1	A
	GONC	LA9A2C
	GOVLNG	=GETPTRLOOP
   ENDCODE
   ' LAM sgrb STOLAM
   FALSE
  ;

* DFlip: diagonal mirror of grob ('D')
* NOTE: This code was programmed by Robert Tiismus
*       and included in his pack 'grobflip'
  FOUR #=casedrop
  ::
   LAM sgrb DUPGROBDIM 2DUP
   2#0=OR IT :: 3DROP FALSE RDROP ;
   SWAP2DUP 5UNROLL 5UNROLL
   #1- 8 #/ #1+ #8*
   SWAP DROPSWAP
   #1- 8 #/ #1+ #8*
   SWAPDROP MAKEGROB DUPUNROT
   ZEROZERO GROB! DUPGROBDIM
   SWAP MAKEGROB
   CODE
	A=DAT1	A
	LC(5)	#14
	C=C+A	A
	RSTK=C
	C=A	A
	D1=D1+	5
	D=D+1	A
	A=DAT1	A
	DAT1=C	A
	C=A	A
	RSTK=C
	GOSBVL	=SAVPTR
	C=RSTK
	D0=C
	D0=D0+	10
	C=DAT0	A
	D=C	A
	DSRB.F	A
	DSRB.F	A
	D0=D0+	5
	C=DAT0	A
	B=C	A
	BSRB.F	A
	BSRB.F	A
	D0=D0+	5
	CD0EX
	R2=C.F	A
	C=RSTK
	R3=C.F	A
	C=D	A
	C=C-1	A
	RSTK=C
LA9108	C=R2.F	A
	R0=C.F	A
	C=R3.F	A
	R1=C.F	A
	C=B	A
	C=C-1	A
	RSTK=C
LA9126	C=R0.F	A
	D0=C
	C=R1.F	A
	D1=C
	P=	3
LA913A	A=DAT0	P
	AD0EX
	A=A+B	A
	AD0EX
	P=P-1
	GONC	LA913A
	C=0	A
	?ABIT=0	0
	GOYES	LA9159
	CBIT=1	15
LA9159	?ABIT=0	1
	GOYES	LA9165
	CBIT=1	11
LA9165	?ABIT=0	2
	GOYES	LA9171
	CBIT=1	7
LA9171	?ABIT=0	3
	GOYES	LA917D
	CBIT=1	3
LA917D	?ABIT=0	4
	GOYES	LA9189
	CBIT=1	14
LA9189	?ABIT=0	5
	GOYES	LA9195
	CBIT=1	10
LA9195	?ABIT=0	6
	GOYES	LA91A1
	CBIT=1	6
LA91A1	?ABIT=0	7
	GOYES	LA91AD
	CBIT=1	2
LA91AD	?ABIT=0	8
	GOYES	LA91B9
	CBIT=1	13
LA91B9	?ABIT=0	9
	GOYES	LA91C5
	CBIT=1	9
LA91C5	?ABIT=0	10
	GOYES	LA91D1
	CBIT=1	5
LA91D1	?ABIT=0	11
	GOYES	LA91DD
	CBIT=1	1
LA91DD	?ABIT=0	12
	GOYES	LA91E9
	CBIT=1	12
LA91E9	?ABIT=0	13
	GOYES	LA91F5
	CBIT=1	8
LA91F5	?ABIT=0	14
	GOYES	LA9201
	CBIT=1	4
LA9201	?ABIT=0	15
	GOYES	LA920D
	CBIT=1	0
LA920D	P=	3
LA920F	DAT1=C	P
	CD1EX
	C=C+D	A
	CD1EX
	P=P-1
	GONC	LA920F
	C=R0.F	A
	C=C+1	A
	R0=C.F	A
	A=R1.F	A
	C=D	A
	C=C+C	A
	C=C+C	A
	A=A+C	A
	R1=A.F	A
	C=RSTK
	C=C-1	A
	RSTK=C
	GOC	LA924F
	GOTO	LA9126
LA924F	C=RSTK
	C=R3.F	A
	C=C+1	A
	R3=C.F	A
	A=R2.F	A
	C=B	A
	C=C+C	A
	C=C+C	A
	A=A+C	A
	R2=A.F	A
	C=RSTK
	C=C-1	A
	RSTK=C
	GOC	LA9280
	GOTO	LA9108
LA9280	C=RSTK
	P=	0
	GOVLNG	=GETPTRLOOP
   ENDCODE
   UNROT MAKEGROB SWAP
   ZEROZERO CKGROBFITS
   2DROP SWAPDROP
   ' LAM sgrb STOLAM FALSE
  ;

* Info.subgrob ('F')  
  SIX #=case
  ::
   GBUFF ZEROZERO 131 64 GROB!ZERODRP
   "SUBGROB INFO" $>grob INVGROB
   GBUFF 50 0 GROB!
   GROB 192 1300091000FFFFFF10DD66D5109455D51055466B10D555D510D555D510FFFFFF1000000000000000000000000000000000000000000000000000000000FFFFFF10DD66D5109455D51055466B10D555DB10D555DB10FFFFFF1000000000000000000000000000000000000000000000000000000000FFFFFF1077564D10755D6D10755D6C10755D6D10FA5E6D10FFFFFF1000000000000000000000000000000000000000000000000000000000FFFFFF10B2A98A10BABEDA1032BAD810BABADA10B2A9DA10FFFFFF10
   GBUFF 0 6 GROB!
   25 6 130 63 DRAWBOX#
   LAM mx #>$ $>grob                    * mark x
   GBUFF 7 14 GROB!
   LAM my #>$ $>grob                    * mark y
   GBUFF 7 28 GROB!
   LAM sgrb DUPGROBDIM #>$ $>grob
   GBUFF 7 42 GROB!                     * width
   #>$ $>grob
   GBUFF 7 56 GROB!                     * height
   GBUFF 27 8 ChkGrb&!                  * subgrob
   FALSE
  ;
  
  FALSE
 ;

********************************

**********************
* Block2 Submenu ('C')
**********************

 THREE #=casedrop
 ::
  GROB F8 7000038000EFFFF8FFFF3EFFFF8FFFF3EFFFF8FFFF307CFFFDBDFF7F3FFFD3FFF7FBF7FDFFFF70F546FD35CC7FDB9FDD5B97F593FDFFFF70F67BEDB47D7F55DFD5B5D7F155FDFFFF707C47FDBDCC7F3BDFD35BD7F553FDFFFF70EFFFF8FFFD3EFFFF8FFFF3EFFFF8FFFF300000000000000000000000000000000000
  GBUFF ZEROZERO GROB!
  WaitForKey DROP

* Zero subgrob ('A')  
  ONE #=casedrop
  ::
   ToBak                                * Bak grob for Undo
   LAM grb Order GROB!ZERO              * Zero
   ' LAM grb STOLAM                     * Save grob
   FALSE
  ;

* Negative subgrob ('B')  
  TWO #=casedrop
  ::
   ToBak                                * Bak grob for Undo
   LAM grb Order SUBGROB INVGROB        * Invert
   LAM grb Order 2DROP ChkGrb&!         * Save grob
   FALSE
  ;

* Gor subgrob ('C')
  THREE #=casedrop
  ::
   ToBak                                * Bak grob for Undo
   TRUE LAM grb LAM sgrb                * Gor
   LAM x LAM y GROB+#
   ' LAM grb STOLAM                     * Save grob
   FALSE
  ;

* Gxor subgrob ('D')
  FOUR #=casedrop
  ::
   ToBak                                * Bak grob for Undo
   FALSE LAM grb LAM sgrb               * Gxor
   LAM x LAM y GROB+#
   ' LAM grb STOLAM                     * Save grob
   FALSE
  ;

* And subgrob ('E')
  FIVE #=case
  ::
   ToBak                                * Bak grob for Undo
   LAM grb LAM x LAM y                  * Get proper grob area
   LAM sgrb GROBDIM 4PICK#+
   DUP 130 #> IT :: DROP 130 ;
   SWAP3PICK #+DUP
   63 #> IT :: DROP 63 ;
   DUP 4PICK #- 6UNROLL
   OVER5PICK #- 7UNROLL
   SUBGROB #02A2C CHANGETYPE            * Convert in string
   LAM sgrb ZEROZERO 6ROLL 6ROLL        * Get subgrob proper area. Be in
                                        * that maybe the whole subgrob
                                        * doesn't fit in grob area
                                        * => SUBGROB subgrob
   SUBGROB #02A2C CHANGETYPE            * Convert in string
   AND$ #02B1E CHANGETYPE               * AND strings and convert in grob
   LAM grb LAM x LAM y ChkGrb&!         * Put new subgrob in grob
   FALSE
  ;

  FALSE
 ;

********************************

**********************
* Draw Submenu ('D')
**********************

 FOUR #=casedrop
 ::
  GROB F8 7000038000EFFFF8FFFF3EFFFF8FFFF3EFFFF8FFFF307CFFEDBBFF7F9FFFD4FFE7FBFFFDFFFF70F645CDBFC87F9B5F5F9926F599FDFFFF70F6FEEDBBAE7F55BF57DEA7F1DEFDFFFF70FE4DED3AA97F9B5FD4D966F5D9FDFFFF70EFFFF8FFFF3EFFFF8FFFF3EFFFF8FFFF300000000000000000000000000000000000
  GBUFF ZEROZERO GROB!
  WaitForKey DROP

* Text ('A')
  ONE #=casedrop
  ::
   $ "Text: " 17 GetStr                 * Get text
   DUPNULL$? IT
   :: DROP FALSE RDROP ;
   $ "Size: " 1 GetStr                  * Get size
   palparse NOT IT                      * Check for valid size
   ::
    4DROP
    $ "Invalid Size (1-3) !!!"
    ShwMsg FALSE RDROP
   ;
   DUPTYPEREAL? NOT IT
   ::
    2DROP
    $ "Invalid Size (1-3) !!!"
    ShwMsg FALSE RDROP
   ;
   COERCE
   ::                                   * Choose proper size
    1 #=casedrop $>grob
    2 #=casedrop $>GROB
    3 #=casedrop $>BIGGROB
    2DROP
    $ "Invalid Size (1-3) !!!"
    ShwMsg FALSE RDROP
   ;
   ToBak                                * Bak grob for Undo
   LAM grb LAM x LAM y ChkGrb&!         * Put text in grob
   FALSE
  ;

* Line ('B')  
  TWO #=casedrop
  ::
   ToBak                                * Bak grob for Undo
   LAM grb GBUFF ZEROZERO GROB!         * Draw line using an Hp48
   LAM x LAM y LAM mx LAM my DRAWLINE#3 * internal entry, in PICT
   GBUFF TOTEMPOB ' LAM grb STOLAM      * Save grob
   LAM x ' LAM mx STOLAM                * Mark coords to end of line
   LAM y ' LAM my STOLAM
   FALSE
  ;

* Box ('C')
  THREE #=casedrop
  ::
   ToBak                                * Bak grob for Undo
   LAM grb GBUFF ZEROZERO GROB!         * Draw box using an Hp48
   LAM x LAM y LAM mx LAM my DRAWBOX#   * internal entry, in PICT
   GBUFF TOTEMPOB ' LAM grb STOLAM      * Save grob
   FALSE
  ;

* Circle ('D')
  FOUR #=casedrop
  ::
   ToBak                                * Bak grob fro Undo
   LAM grb GBUFF ZEROZERO GROB!         * Draw circle using an Hp48
   LAM mx #>HXS LAM my #>HXS TWO{}N     * internal entry, in PICT
   LAM x LAM mx UNCOERCE2 %-
   LAM y LAM my UNCOERCE2 %-
   %REC>%POL DROP %>#
   %0 %360 ARCLIST
   GBUFF TOTEMPOB ' LAM grb STOLAM      * Save grob
   FALSE
  ;

* Arc ('E')
  FIVE #=case
  ::
   "End Angle: " 5 GetStr               * Get end angle
   DUP CAR$ CHR @ EQUAL ITE             * Check if relative angle
   :: CDR$ TRUE SWAP ;
   :: FALSE SWAP ;
   palparse NOT IT                      * Check for valid angle
   :: 
    3DROP "Invalid Angle !!!"
    ShwMsg FALSE RDROP
   ;
   DUPTYPEREAL? NOT IT
   :: 
    DROPFALSE "Invalid Angle !!!"
    ShwMsg RDROP
   ;
   %360 %MOD
   ToBak                                * Bak grob for Undo
   LAM grb GBUFF ZEROZERO GROB!         * Draw arc using an Hp48
   LAM mx #>HXS LAM my #>HXS TWO{}N     * internal entry, in PICT
   LAM x LAM mx UNCOERCE2 %-
   LAM y LAM my UNCOERCE2 %-
   %REC>%POL %CHS SWAP %># SWAP
   5ROLL ITE
   :: DUP 5ROLL %+ ;
   4ROLL
   ARCLIST
   GBUFF TOTEMPOB ' LAM grb STOLAM      * Save grob
   FALSE
  ;
  
  FALSE
 ;
 
********************************

**********************
* Fill Submenu ('E')
**********************

 FIVE #=case
 ::
  GROB F8 7000038000EFFFF8FFFF3EFFFF8FFFF3EFFFF8FFFF30F3AAFD9FBB77DFFFDFFFF7FFFFFDFFFF70FBFAFD591177D44EDFFFF7FFFFFDFFFF70F3BAFD93BB77D67FDFFFF7FFFFFDFFFF70FBBAFDD1BB6F6E4FDFFFF7FFFFFDFFFF70EFFFF8FFFF3EFFFF8FFFF3EFFFF8FFFF300000000000000000000000000000000000
  GBUFF ZEROZERO GROB!
  WaitForKey DROP

* Fill ('A')  
  ONE #=casedrop
  :: LAM fpat FILL FALSE ;

* Choose pattern ('B')  
  TWO #=casedrop
    INCLUDE CFILL.S
  
* User pattern ('C')
  THREE #=case
  ::
   LAM grb ZEROZERO 21 8 SUBGROB        * To show pattern grob
   LAM grb
   CODE                                 * Get an HXS representing 
	A=DAT1	A                       * the fill pattern
        LC(5)	20
        A=A+C	A
        D=D+1	A
        D1=D1+	5
        GOSBVL	=SAVPTR
        D0=A
        P=	0
-	A=DAT0	P
	D0=D0+	1
	P=P+1
	A=DAT0	P
	D0=D0+	33
	P=P+1
	?P#	0
	GOYES	-
	P=P-1
	GOVLNG	=PUSHhxsLoop
   ENDCODE
   DUP
   HXS 10 FFFFFFFFFFFFFFFF
   HXS#HXS %0= ITE
   2DROP
   ::                                   * Save pattern, grob and number
    ' LAM userpat STOLAM
    ' LAM userpat.grb STOLAM
    0 ' LAM fpat STOLAM
    "User Pattern Saved !!!"
    ShwMsg
   ;
   FALSE                                * Not valid pattern
  ;
  
  FALSE
  ;
  
********************************

 FALSE
;



*************************************************************************
*************************************************************************
*************************************************************************
*************************************************************************
*************************************************************************

***********
* CFILL.S *
***********

* This is a routine used to show the patterns
* and to select easily one of them

::
 GBUFF 16 6 115 57 GROB!ZERODRP         * Clear screen area
 17 7 112 54 DRAWBOX#                   * Draws a box with shadow
 18 55 113 55 LINEON3
 113 8 113 54 LINEON3
 GROB 6A 40000E5000FFF7AFFFFF15D3F77FFFFFF3FFFB37772ED7DB232229FFF3FFFBBAA6BF95D3767BB5FFF3FFF7A6737ED5DB3677A5FFF3
 GBUFF 18 8 GROB!                       * Display title line
 16 #1+_ONE_DO                          * Show the 16 patterns
   PATGROBS INDEX@ NTHCOMPDROP
   GBUFF PATPOS
   INDEX@ NTHCOMPDROP INCOMPDROP
   GROB!
 LOOP
 { NULL$ NULL$ NULL$ NULL$ "CANC" "OK" }
 InitMenu DispMenu                      * Show the menu
 1 1 { NULLLAM NULLLAM } BIND           * Current and previous pattern

 BEGIN                                  * Key handler
   GBUFF PATPOS 2GETLAM                 * Clear cursor over prev. pat.
   NTHCOMPDROP INCOMPDROP
   #1-SWAP #1-SWAP 2DUP #10+
   SWAP 23 #+SWAP GROB!ZERODRP
   PATGROBS 2GETLAM NTHCOMPDROP
   GBUFF PATPOS 2GETLAM
   NTHCOMPDROP INCOMPDROP GROB!
   PATPOS 1GETLAM NTHCOMPDROP           * Draw cursor over current pat.
   INCOMPDROP #1-SWAP #1-SWAP
   2DUP #9+ SWAP 22 #+SWAP DRAWBOX#
   WaitForKey DROP                      * Key handler
   ::
    5 #=casedrop                        * CANCEL
      TRUE

    45 #=casedrop                       * ON
      TRUE

    25 #=casedrop                       * ENTER => Fill
    :: 1GETLAM FILL TRUE ;

    6 #=casedrop                        * OK => Fill
    :: 1GETLAM FILL TRUE ;

    11 #=casedrop			* CursorUP
    ::
     1GETLAM #4- DUPDUP 50 #> SWAP	* 1- and check limits
     #0= OR IT :: DROP 1GETLAM ;
     1GETLAM 2PUTLAM 1PUTLAM		* Save new and previous pattern
     FALSE
    ;

    16 #=casedrop			* CursorLeft
    ::
     1GETLAM #1- DUP#0= IT DROPONE
     1GETLAM 2PUTLAM 1PUTLAM
     FALSE
    ;

    17 #=casedrop			* CursorDown
    ::
     1GETLAM #4+ DUP 16 #> IT
     :: DROP 1GETLAM ;
     1GETLAM 2PUTLAM 1PUTLAM
     FALSE
    ;

    18 #=case				* CursorRight
    ::
     1GETLAM #1+DUP 16 #> IT
     :: DROP 16 ;
     1GETLAM 2PUTLAM 1PUTLAM
     FALSE
    ;
    
    FALSE
   ;
 UNTIL

 ABND TURNMENUOFF
 FALSE
;

*************************************************************************
*************************************************************************
*************************************************************************
*************************************************************************
*************************************************************************
