/*	CMOSTIME Version 1.0
//	Copyright (c) 1994 by David J. Arcand - All rights reserved
//
//	A program to read the PC's RTC and reset the BIOS clock to it.
//	Typically used when running DESQview (tm) with programs that
//	make intensive use of the interrupts.  When run once or twice
//	a day, will make sure that you don't loose BIOS time because the
//	PC was off handling other interupt and your clock stays relatively
//	accurate.
//
//	Released as Freeware to the great unwashed masses of System Operators.
//	David Arcand - July 30, 1994 on 11:22am.
*/

#include <dos.h>
#include <stdio.h>
#include <stdlib.h>


void main(void)
{

	printf( "\nCMOSTIME Ver 1.0 by David J. Arcand. Copyright 1994 All rights reserved.\nRefreshes the DOS Time from the PC's REAL TIME CLOCK.\n");

	union	REGS regs ;
	struct	dostime_t	DOSTIME;		// Destinatin of the RTC time data.
	struct	dostime_t	CMOSTIME;		// Read in from the bios clock.
	struct	dostime_t	DIFFTIME;		// calculating the difference.
	int		DIFFSECONDS ;				// main variable for computing diff.
	char	hexbuffer[8] ;				// a work area for HEX to Decimal.

	// First get the two times.

	regs.h.ah = 2 ;
	int86(0x1A, &regs, &regs );				// The RTC time
	_dos_gettime(&DOSTIME);					// The BIOS time

	// Convert the HEX RTC time to decimal and a standard structure.

	sprintf( hexbuffer, "%0X\n",regs.h.ch );	// Hours
	CMOSTIME.hour    = atoi( hexbuffer );

	sprintf( hexbuffer, "%0X\n",regs.h.cl );	// Minutes
	CMOSTIME.minute  = atoi( hexbuffer );

	sprintf( hexbuffer, "%0X\n",regs.h.dh );	// Seconds
	CMOSTIME.second  = atoi( hexbuffer );

	CMOSTIME.hsecond = 0;


	// Make the RTC time correction.

	_dos_settime(&CMOSTIME);


	// Print the two times.

	printf("Hardware RTC is: %2d:%02d:%02d.%02d\n",
	CMOSTIME.hour, CMOSTIME.minute, CMOSTIME.second, CMOSTIME.hsecond);

	printf("  BIOS clock is: %2d:%02d:%02d.%02d\n",
	DOSTIME.hour, DOSTIME.minute, DOSTIME.second, DOSTIME.hsecond);


	// Compare the difference
	if( abs(CMOSTIME.hour - DOSTIME.hour) < 5 )
	{

		DIFFSECONDS      = CMOSTIME.hour   - DOSTIME.hour   ;
		DIFFSECONDS     *= 60 ;

		DIFFSECONDS      = CMOSTIME.minute - DOSTIME.minute + DIFFSECONDS ;
		DIFFSECONDS     *= 60 ;

		DIFFSECONDS      = CMOSTIME.second - DOSTIME.second + DIFFSECONDS ;

		DIFFTIME.hour	 = DIFFSECONDS / 360 ;
		DIFFSECONDS 	-= DIFFTIME.hour * 360 ;

		DIFFTIME.minute  = DIFFSECONDS / 60 ;
		DIFFSECONDS     -= DIFFTIME.minute * 60 ;

		DIFFTIME.second  = DIFFSECONDS ;

		printf("  Time Diff of : %2d:%02d:%02d\n",
		abs(DIFFTIME.hour), abs(DIFFTIME.minute), abs(DIFFTIME.second) );
	}
	else printf("The times are wildly out of sync.\n" );  // Too far to even bother calculate.

	printf( "The BIOS time has been set to the RTC.\n" );	// All done.

}

