PROGRAM FAT_Editor;

USES Dos,HtScreen,HtString,Keyboard;

CONST BufSize    = 512;
      FATSize    = 4608;
      HexRow     = 2;
      HexCol     = 5;
      HexRows    = 18;
      HexCols    = 52;
      FATRows    = 8;
      BootRow    = 7;
      BootCol    = 25;
      BootRows   = 13;
      BootCols   = 31;
      BootAttr   = White+CyanBG;
      HexAttr    : BYTE = White+BlueBG;
      ActiveAttr : BYTE = Yellow+BlueBG;

TYPE String2 = STRING[2];
     BufType = ARRAY[0..BufSize-1] OF BYTE;
     FATType = ARRAY[0..FATSize-1] OF BYTE;

VAR Regs       : REGISTERS;
    FATBuf1,
    FATBuf2    : FATType;
    BootBuffer : BufType;
    BootScr    : ARRAY[1..BootRows+3,1..BootCols+4] OF WORD;
    FAT1Addr,
    FAT2Addr,
    Drive,
    Cylinder,
    Sector,
    Head,
    Status     : BYTE;
    I,Offset,
    MaxOffset,
    WindOffset : INTEGER;
    BytesPerSector,
    ReservedSectors,
    RootEntries,
    NumberOfSectors,
    SectorsPerFat,
    SectorsPerTrack,
    NumberOfHeads,
    HiddenSectors      : WORD;
    SectorsPerCluster,
    NumberOfFats,
    MediaDescriptor    : BYTE;
    LogSec1,LogSec2    : WORD;


PROCEDURE InitFATs;
BEGIN
  FOR I := 0 TO FATSize-1 DO
  BEGIN
    FATBuf1[I] := 0;
    FATBuf2[I] := 0;
  END;
END;

(********************************************************************)
(*                                                                  *)
(*  Calculation procedures                                          *)
(*                                                                  *)
(********************************************************************)

FUNCTION HexByte(H : CHAR) : BYTE;
VAR Tmp : BYTE;
BEGIN
  IF H IN ['0'..'9'] THEN
    Tmp := Ord(H)-48;
  IF H IN ['A'..'F'] THEN
    Tmp := Ord(H)-55;
  HexByte := Tmp;
END;


FUNCTION ByteToHex(B : BYTE) : String2;
VAR TmpS : String2;
    TmpB : BYTE;
BEGIN
  TmpB := B DIV 16;
  IF TmpB <=9 THEN
    TmpS[1] := Chr(TmpB+48)
  ELSE TmpS[1] := Chr(TmpB+55);
  TmpB := B MOD 16;
  IF TmpB <=9 THEN
    TmpS[2] := Chr(TmpB+48)
  ELSE TmpS[2] := Chr(TmpB+55);
  ByteToHex := TmpS;
END;


FUNCTION HexToByte(H : String2; VAR InOrder : BOOLEAN) : BYTE;
VAR I,Tmp1,Tmp2 : BYTE;
BEGIN
  InOrder := TRUE;
  H[1] := UpCase(H[1]);
  H[2] := UpCase(H[2]);
  FOR I := 1 TO 2 DO
    IF NOT ((H[I] IN ['0'..'9']) OR (H[I] IN ['A'..'F'])) THEN
    BEGIN
      InOrder := FALSE;
      Exit;
    END;
  Tmp1 := HexByte(H[1]);
  Tmp2 := HexByte(H[2]);
  HexToByte := 16*Tmp1+Tmp2;
END;

(********************************************************************)
(*                                                                  *)
(*  Disk control procedures                                         *)
(*                                                                  *)
(********************************************************************)

PROCEDURE ReadSector(Sylinder,Sector,Head,Drive : BYTE; VAR Buffer : BufType);
BEGIN
  FillChar(Regs,SizeOf(Regs),0);
  Regs.AH := $02;
  Regs.AL := $01;            { Number of sectors }
  Regs.CH := Sylinder;       { track/sylinder number }
  Regs.CL := Sector;         { sector number }
  Regs.DH := Head;           { head/side number }
  Regs.DL := Drive;          { drive number }
  Regs.ES := Seg(Buffer);
  Regs.BX := Ofs(Buffer);
  Intr($13,Regs);
  Status := Regs.AH;
END;


PROCEDURE GetBootInfo(Drive : BYTE);
VAR BSylinder,
    BSector,
    BSide,
    BDrive : BYTE;
BEGIN
  BSylinder := 0;
  BSector := 1;
  BSide := 0;
  BDrive := Drive;
  ReadSector(BSylinder,BSector,BSide,BDrive,BootBuffer);
  BytesPerSector    := BootBuffer[$0C] SHL 8 + BootBuffer[$0B];
  ReservedSectors   := BootBuffer[$0F] SHL 8 + BootBuffer[$0E];
  RootEntries       := BootBuffer[$12] SHL 8 + BootBuffer[$11];
  NumberOfSectors   := BootBuffer[$14] SHL 8 + BootBuffer[$13];
  SectorsPerFat     := BootBuffer[$17] SHL 8 + BootBuffer[$16];
  SectorsPerTrack   := BootBuffer[$19] SHL 8 + BootBuffer[$18];
  NumberOfHeads     := BootBuffer[$1B] SHL 8 + BootBuffer[$1A];
  HiddenSectors     := BootBuffer[$1D] SHL 8 + BootBuffer[$1C];
  SectorsPerCluster := BootBuffer[$0D];
  NumberOfFats      := BootBuffer[$10];
  MediaDescriptor   := BootBuffer[$15];
  FAT1Addr          := 1;
  FAT2Addr          := 1 + SectorsPerFAT;
  MaxOffset         := BytesPerSector*SectorsPerFAT - 1;
END;


PROCEDURE ReadFAT(Drive,FATAddr : BYTE; VAR FATBuf : FATType);
BEGIN
  FillChar(Regs,SizeOf(Regs),0);
  Regs.AH := $02;
  Regs.AL := SectorsPerFat;  { Number of sectors }
  Regs.CH := $00;            { track/sylinder number }
  Regs.CL := FATAddr+1;      { sector number }
  Regs.DH := $00;            { head/side number }
  Regs.DL := Drive;          { drive number }
  Regs.ES := Seg(FATBuf);
  Regs.BX := Ofs(FATBuf);
  Intr($13,Regs);
  Status := Regs.AH;
END;


PROCEDURE WriteFAT(Drive,FATAddr : BYTE; VAR FATBuf1 : FATType);
BEGIN
  FillChar(Regs,SizeOf(Regs),0);
  Regs.AH := $03;
  Regs.AL := SectorsPerFat;  { Number of sectors }
  Regs.CH := $00;            { track/sylinder number }
  Regs.CL := FATAddr+1;      { sector number }
  Regs.DH := $00;            { head/side number }
  Regs.DL := Drive;          { drive number }
  Regs.ES := Seg(FATBuf1);
  Regs.BX := Ofs(FATBuf1);
  Intr($13,Regs);
  Status := Regs.AH;
END;

(********************************************************************)
(*                                                                  *)
(*  Video display procedures                                        *)
(*                                                                  *)
(********************************************************************)

PROCEDURE MainBackGround;
VAR S : STRING;
BEGIN
  HtFill(1,1,25,80,White+BlueBG,'');
  HtFill(1,1,1,80,White+CyanBG,' ');
  HtWriteC(1,40,SameAttr,'FAT Editor  v 1.0');
END;


PROCEDURE Reading;
BEGIN
  Box(12,25,1,30,White+CyanBG,SingleBorder,' ');
  AddShadow(12,25,1,30);
  HtWrite(12,30,SameAttr,'Reading information...');
END;


FUNCTION Confirm(Msg : STRING) : BOOLEAN;
VAR L : BYTE;
BEGIN
  L := (Length(Msg) + 12) DIV 2;
  Box(11,40-L,3,2*L,White+CyanBG,SingleBorder,' ');
  AddShadow(11,40-L,3,2*L);
  HtWrite(12,40-L+3,SameAttr,Msg+' (');
  HtWriteEos(Yellow+CyanBG,'Y');
  HtWriteEos(White+CyanBG,'/');
  HtWriteEos(Yellow+CyanBG,'N');
  HtWriteEos(White+CyanBG,')');
  InKey(Ch,Fk,Key);
  IF UpCase(Ch) = 'N' THEN Confirm := FALSE
    ELSE Confirm := TRUE;
END;


PROCEDURE AskSaveFAT(LogSec1,LogSec2 : LONGINT; FATBuf1,FATBuf2 : FATType);
BEGIN
  IF Confirm('FATs changed. Save') THEN
  BEGIN
    WriteFAT(Drive,FAT1Addr,FATBuf1);
    WriteFAT(Drive,FAT2Addr,FATBuf2);
  END;
END;


PROCEDURE ShowBootInfo;
VAR I : BYTE;
BEGIN
  HtStoreToMem(BootRow-1,BootCol-1,BootRows+3,BootCols+4,BootScr);
  Explode(BootRow,BootCol,BootRows,BootCols,BootAttr,SingleBorder);
  AddShadow(BootRow,BootCol,BootRows,BootCols);
  HtWrite(BootRow,BootCol+4,BootAttr,'BOOT RECORD INFORMATION');
  HtWrite(BootRow+1,BootCol-1,BootAttr,'');
  FOR I := 0 TO BootCols DO
    HtWrite(BootRow+1,BootCol+I,BootAttr,'');
  HtWrite(BootRow+1,BootCol+BootCols,BootAttr,'');
   HtWrite(BootRow+2,BootCol+2,SameAttr,'Bytes per sector    : '+StrL(BytesPerSector));
   HtWrite(BootRow+3,BootCol+2,SameAttr,'Sectors per cluster : '+StrL(SectorsPerCluster));
   HtWrite(BootRow+4,BootCol+2,SameAttr,'Reserved sectors    : '+StrL(ReservedSectors));
   HtWrite(BootRow+5,BootCol+2,SameAttr,'FAT copies          : '+StrL(NumberOfFats));
   HtWrite(BootRow+6,BootCol+2,SameAttr,'Root dir.entries    : '+StrL(RootEntries));
   HtWrite(BootRow+7,BootCol+2,SameAttr,'Total sectors       : '+StrL(NumberOfSectors));
   HtWrite(BootRow+8,BootCol+2,SameAttr,'Media descriptor    : '+ByteToHex(MediaDescriptor));
   HtWrite(BootRow+9,BootCol+2,SameAttr,'Sectors per FAT     : '+StrL(SectorsPerFat));
  HtWrite(BootRow+10,BootCol+2,SameAttr,'Sectors per track   : '+StrL(SectorsPerTrack));
  HtWrite(BootRow+11,BootCol+2,SameAttr,'Sides               : '+StrL(NumberOfHeads));
  HtWrite(BootRow+12,BootCol+2,SameAttr,'Hidden sectors      : '+StrL(HiddenSectors));
  InKey(Ch,Fk,Key);
  HtStoreToScr(BootRow-1,BootCol-1,BootRows+3,BootCols+4,BootScr);
  Key:=NullKey;
END;


PROCEDURE WriteCommands;
BEGIN
  HtFill(22,1,2,80,Black+LightGrayBG,' ');
  HtWrite(23,5,SameAttr,'Floppy disk   A:');
  HtWrite(22,55,SameAttr,'Cyl '+StrL(Cylinder)+', Head '+StrL(Head)+', Sector '+StrL(Sector));
  HtWrite(23,55,SameAttr,'Offset : '+StrL(Offset));
  HtFill(24,1,2,80,White+CyanBG,' ');
  HtWrite(24,5,SameAttr,'PgUp/PgDn - Prev/next sector            Return - edit at cursor');
  HtWrite(25,5,SameAttr,#26+#25+#24+#27'      - Move cursor                 Esc    - quit');
END;


PROCEDURE WriteFATCommands(Equal : BOOLEAN);
CONST CommAttr1 = White+CyanBG;
      CommAttr2 = Yellow+CyanBG;
VAR F1,F2 : BYTE;
BEGIN
  F1 := FAT1Addr + (Offset DIV 16);
  F2 := FAT2Addr + (Offset DIV 16);
  HtFill(22,1,2,80,Black+LightGrayBG,' ');
  HtWrite(22,3,SameAttr,'Floppy disk '+ParamStr(1));
  HtWrite(22,55,SameAttr,'Status : ');
  IF Equal THEN
    HtWriteEos(White+LightGrayBG,'Identical FATs')
  ELSE HtWriteEos(White+LightGrayBG,'Different FATs');
  HtWrite(23,55,SameAttr,'Offset : '+StrL(Offset));
  HtFill(24,1,2,80,CommAttr1,' ');
  HtWrite(24,3,CommAttr2,'F1');    HtWRiteEos(SameAttr,'-Help');
  HtWrite(25,3,CommAttr2,'F2');    HtWRiteEos(SameAttr,'-Save FATs');
  HtWrite(24,18,CommAttr2,'F3');    HtWRiteEos(SameAttr,'-FAT1 '+#26+' FAT2');
  HtWrite(25,18,CommAttr2,'F4');    HtWRiteEos(SameAttr,'-FAT2 '+#26+' FAT1');
  HtWrite(24,37,CommAttr2,'F5');    HtWRiteEos(SameAttr,'-Boot Record info');
  HtWrite(25,37,CommAttr2,'F6');    HtWRiteEos(SameAttr,'-Search');
  HtWrite(24,60,CommAttr2,'Tab');    HtWRiteEos(SameAttr,'-Toggle FAT');
  HtWrite(25,60,CommAttr2,'Esc');    HtWRiteEos(SameAttr,'-Quit');
END;


PROCEDURE WriteFATHexLine(Offset,Row : WORD; Buffer : FATType);
VAR C,Col : WORD;
BEGIN
  Offset := 16*(Offset DIV 16);
  IF (Offset+15) > MaxOffset THEN
    Exit;
  FOR C := Offset TO Offset+15 DO
  BEGIN
    Col := HexCol+3*(C MOD 16);
    IF C MOD 16 = 7 THEN
      HtWrite(Row,Col+4,SameAttr,'-');
    IF C MOD 16 > 7 THEN Inc(Col,4);
    HtWrite(Row,Col,SameAttr,ByteToHex(Buffer[C]));
    Col := HexCol+HexCols+5+(C MOD 16);
    HtWrite(Row,Col,SameAttr,Chr(Buffer[C]));
  END;
END;


PROCEDURE WriteFATHex(WindOffset : WORD;  ActiveFAT : BYTE);
VAR StartRow,K : WORD;
BEGIN
  StartRow := WindOffset DIV 16;
  Box(3,2,FATRows,78,HexAttr,SingleBorder,' ');
  FOR K := 1 TO FATRows DO
    WriteFATHexLine((StartRow+K-1)*16,2+K,FATBuf1);
  Box(5+FATRows,2,FATRows,78,HexAttr,SingleBorder,' ');
  FOR K := 1 TO FATRows DO
    WriteFATHexLine((StartRow+K-1)*16,4+FATRows+K,FATBuf2);
  IF ActiveFAT=1 THEN
    Box(3,2,FATRows,78,ActiveAttr,DoubleBorder,#0)
  ELSE Box(5+FATRows,2,FATRows,78,ActiveAttr,DoubleBorder,#0);
  HtWrite(2,3,SameAttr,'[ FAT copy  1 ]');
  HtWrite(4+FATRows,3,SameAttr,'[ FAT copy  2 ]');
  IF ActiveFAT=1 THEN StartRow:=HexRow+1 ELSE StartRow:=HexRow+FATRows+3;
  HtWrite(StartRow,80,SameAttr,#24);
  HtWrite(StartRow+FATRows-1,80,SameAttr,#25);
  FOR I := 1 TO FATRows-2 DO
    HtWrite(StartRow+I,80,SameAttr,'');
END;


PROCEDURE WriteCursor(WindOffset,Offset : INTEGER; Attr : WORD);
VAR Row,Col : BYTE;
BEGIN
  Row := HexRow + 1 + ((Offset-WindOffset) DIV 16);
  Col := HexCol + 3*(Offset MOD 16);
  IF (Offset MOD 16) > 7 THEN Inc(Col,4);
  HtWrite(Row,Col,Attr,ByteToHex(FATBuf1[Offset]));
  HtWrite(Row+FATRows+2,Col,Attr,ByteToHex(FATBuf2[Offset]));
  HtWrite(Row,HexCol+HexCols+5+(Offset MOD 16),Attr,Chr(FATBuf1[Offset]));
  HtWrite(Row+FATRows+2,HexCol+HexCols+5+(Offset MOD 16),Attr,Chr(FATBuf2[Offset]));
END;


PROCEDURE WriteFATOffset(VAR WindOffset : INTEGER;
                         Offset : INTEGER;
                         FATBuf1,FATBuf2 : FATType);
VAR Attr,Row,Col : BYTE;
BEGIN
  IF (Offset<WindOffset) AND (WindOffset>15) THEN
  BEGIN
    Dec(WindOffset,16);
    HtScrollDown(HexRow+1,HexCol,FATRows,HexCols+21,HexAttr);
    HtScrollDown(HexRow+FATRows+3,HexCol,FATRows,HexCols+21,HexAttr);
    WriteFATHexLine(Offset,HexRow+1,FATBuf1);
    WriteFATHexLine(Offset,HexRow+FATRows+3,FATBuf2);
  END;
  IF Offset>=(WindOffset+16*FATRows) THEN
  BEGIN
    Inc(WindOffset,16);
    HtScrollUp(HexRow+1,HexCol,FATRows,HexCols+21,HexAttr);
    HtScrollUp(HexRow+FATRows+3,HexCol,FATRows,HexCols+21,HexAttr);
    WriteFATHexLine(Offset,HexRow+FATRows,FATBuf1);
    WriteFATHexLine(Offset,HexRow+2*FATRows+2,FATBuf2);
  END;
  IF FATBuf1[Offset] = FATBuf2[Offset] THEN
    Attr := Yellow+CyanBG
  ELSE
    Attr := Yellow+RedBG;
  WriteCursor(WindOffset,Offset,Attr);
END;


PROCEDURE ShowPosition(Offset : WORD; ActiveFAT : BYTE);
VAR Start,I : BYTE;
BEGIN
  HtWrite(23,64,SameAttr,'           ');
  HtWrite(23,64,SameAttr,StrL(Offset));
  LogSec1 := FAT1Addr + (Offset DIV BytesPerSector);
  LogSec2 := LogSec1 + SectorsPerFAT;
  HtWrite(HexRow,65,SameAttr,'[ Sector '+StrLF(LogSec1,3)+' ]');
  HtWrite(HexRow+FATRows+2,65,SameAttr,'[ Sector '+StrLF(LogSec2,3)+' ]');
  IF ActiveFAT=1 THEN Start:=HexRow+1 ELSE Start:=HexRow+FATRows+3;
  I := Round((FATRows-3)*(Offset/MaxOffset));
  IF I>0 THEN  HtWrite(Start+I,80,SameAttr,'');
   HtWrite(Start+I+1,80,SameAttr,'');
  IF I<FATRows-3 THEN HtWrite(Start+I+2,80,SameAttr,'');
  HtWrite(Start+I+1,80,SameAttr,'');
END;

(********************************************************************)
(*                                                                  *)
(*  Menu procedures                                                 *)
(*                                                                  *)
(********************************************************************)

FUNCTION CheckEqual(FATBuf1,FATBuf2 : FATType) : BOOLEAN;
VAR C : WORD;
    T : BOOLEAN;
BEGIN
  T := TRUE;
  FOR C := 0 TO BytesPerSector*SectorsPerFAT-1 DO
    IF FATBuf1[C] <> FATBuf2[C] THEN
      T := FALSE;
  CheckEqual := T;
END;


PROCEDURE EditByte(WindOffset,Offset : INTEGER;
                   ActiveFAT : BYTE;
                   VAR Changed : BOOLEAN);
VAR Tmp,Row,Col : BYTE;
    S       : STRING;
    InOrder : BOOLEAN;
BEGIN
  IF ActiveFAT=1 THEN
    Row := HexRow + 1 + ((Offset-WindOffset) DIV 16)
  ELSE Row := HexRow + 3 + FATRows + ((Offset-WindOffset) DIV 16);
  Col := HexCol + 3*(Offset MOD 16);
  IF (Offset MOD 16) > 7 THEN Inc(Col,4);
  IF ActiveFAT=1 THEN
    S := ByteToHex(FATBuf1[Offset])
  ELSE S := ByteToHex(FATBuf2[Offset]);
  InputString(S,Row,Col,2,White+BlackBG,[Return,Escape]);
  Tmp := HexToByte(S,InOrder);
  IF InOrder THEN
  BEGIN
    IF ActiveFAT=1 THEN
      FATBuf1[Offset] := Tmp
    ELSE FATBuf2[Offset] := Tmp;
    Changed := TRUE;
    HtWrite(24,78,SameAttr,#15);
  END;
END;


PROCEDURE ShowEqual;
CONST EqualAttr = White+CyanBG;
VAR EqualScr : ARRAY[1..4,1..30] OF WORD;
BEGIN
  HtStoreToMem(12,25,4,30,EqualScr);
  Explode(13,26,1,26,EqualAttr,SingleBorder);
  AddShadow(13,26,1,26);
  HtWrite(13,28,SameAttr,'The FATs are identical.');
  InKey(Ch,Fk,Key);
  HtStoreToScr(12,25,4,30,EqualScr);
  Key:=NullKey;
END;


PROCEDURE FindDifference;
CONST DiffRow = 7;
      DiffCol = 25;
      DiffRows = 13;
      DiffCols = 30;
      DiffAttr = White+CyanBG;
VAR Equal : BOOLEAN;
    List  : ARRAY[1..DiffRows-2] OF WORD;
    Ofse,Count,AbsCount,I : WORD;
    DiffScr : ARRAY[1..DiffRows+3,1..DiffCols+4] OF WORD;
BEGIN
  Equal := CheckEqual(FATBuf1,FATBuf2);
  IF Equal THEN
  BEGIN
    ShowEqual;
    Exit;
  END;
  Count := 0;
  I := 0;
  REPEAT                            { Find the 10 first differences and store }
    IF FATBuf1[I]<>FATBuf2[I] THEN  { in list }
    BEGIN
      Inc(Count);
      List[Count] := I;
    END;
    Inc(I);
  UNTIL (Count>=10) OR (I>MaxOffset);
  I := 0;
  AbsCount := 0;                       { Find all differences }
  REPEAT
    IF FATBuf1[I]<>FATBuf2[I] THEN
      Inc(AbsCount);
    Inc(I);
  UNTIL I>MaxOffset;
  HtStoreToMem(DiffRow-1,DiffCol-1,DiffRows+3,DiffCols+4,DiffScr);
  Explode(DiffRow,DiffCol,DiffRows,DiffCols,DiffAttr,SingleBorder);
  AddShadow(DiffRow,DiffCol,DiffRows,DiffCols);
  HtWrite(DiffRow,DiffCol+2,DiffAttr,'Differences : '+StrLF(AbsCount,4));
  HtWrite(DiffRow+1,DiffCol+2,DiffAttr,'Offset    FAT-1    FAT-2');
  HtWrite(DiffRow+2,DiffCol+2,DiffAttr,'        ');
  FOR I := 1 TO Count DO
  BEGIN
    Ofse := List[I];
    HtWrite(DiffRow+2+I,DiffCol+3,DiffAttr,StrLF(Ofse,4));
    HtWrite(DiffRow+2+I,DiffCol+13,DiffAttr,'$'+ByteToHex(FATBuf1[Ofse]));
    HtWrite(DiffRow+2+I,DiffCol+22,DiffAttr,'$'+ByteToHex(FATBuf2[Ofse]));
  END;
  InKey(Ch,Fk,Key);
  Key := NullKey;
  HtStoreToScr(DiffRow-1,DiffCol-1,DiffRows+3,DiffCols+4,DiffScr);
END;


PROCEDURE Help;
CONST HelpAttr = White+LightGrayBG;
      HelpAtt2 = Yellow+LightGrayBG;
      HelpRow  = 5;
      HelpCol  = 20;
      HelpRows = 17;
      HelpCols = 40;
VAR HelpScr : ARRAY[1..HelpRows+3,1..HelpCols+4] OF WORD;
BEGIN
  HtStoreToMem(HelpRow-1,HelpCol-1,HelpRows+3,HelpCols+4,HelpScr);
  Explode(HelpRow,HelpCol,HelpRows,HelpCols,HelpAttr,SingleBorder);
  AddShadow(HelpRow,HelpCol,HelpRows,HelpCols);
  HtWriteC(HelpRow-1,40,SameAttr,' HELP ');
  HtWrite(HelpRow,HelpCol+1,HelpAtt2,'Key');
  HtWrite(HelpRow,HelpCol+7,HelpAttr,'Description');
  HtWrite(HelpRow+1,HelpCol+1,HelpAttr,'');
  HtWrite(HelpRow+2,HelpCol+1,HelpAtt2,#27+#24+#25+#26);
  HtWrite(HelpRow+2,HelpCol+7,HelpAttr,'Move cursor (also : PgUp/PgDn)');
  HtWrite(HelpRow+3,HelpCol+1,HelpAtt2,'Home');
  HtWrite(HelpRow+3,HelpCol+7,HelpAttr,'Go to start of FATs');
  HtWrite(HelpRow+4,HelpCol+1,HelpAtt2,'End');
  HtWrite(HelpRow+4,HelpCol+7,HelpAttr,'Go to end of FATs');
  HtWrite(HelpRow+5,HelpCol+1,HelpAtt2,'Ret');
  HtWrite(HelpRow+5,HelpCol+7,HelpAttr,'Edit byte at cursor');
  HtWrite(HelpRow+6,HelpCol+1,HelpAtt2,'F1');
  HtWrite(HelpRow+6,HelpCol+7,HelpAttr,'This help screen');
  HtWrite(HelpRow+7,HelpCol+1,HelpAtt2,'F2');
  HtWrite(HelpRow+7,HelpCol+7,HelpAttr,'Save both copies of the FAT');
  HtWrite(HelpRow+8,HelpCol+1,HelpAtt2,'F3');
  HtWrite(HelpRow+8,HelpCol+7,HelpAttr,'Copy the original FAT (FAT1) to');
  HtWrite(HelpRow+9,HelpCol+7,HelpAttr,'the backup copy (FAT2)');
  HtWrite(HelpRow+10,HelpCol+1,HelpAtt2,'F4');
  HtWrite(HelpRow+10,HelpCol+7,HelpAttr,'Copy the backup copy of the FAT');
  HtWrite(HelpRow+11,HelpCol+7,HelpAttr,'(FAT2) to the original (FAT1)');
  HtWrite(HelpRow+12,HelpCol+1,HelpAtt2,'F5');
  HtWrite(HelpRow+12,HelpCol+7,HelpAttr,'Display boot record information');
  HtWrite(HelpRow+13,HelpCol+1,HelpAtt2,'F6');
  HtWrite(HelpRow+13,HelpCol+7,HelpAttr,'Search for differences in the');
  HtWrite(HelpRow+14,HelpCol+7,HelpAttr,'two FAT tables');
  HtWrite(HelpRow+15,HelpCol+1,HelpAtt2,'Tab');
  HtWrite(HelpRow+15,HelpCol+7,HelpAttr,'Toggle active FAT for editing');
  HtWrite(HelpRow+16,HelpCol+1,HelpAtt2,'Esc');
  HtWrite(HelpRow+16,HelpCol+7,HelpAttr,'Quit from the FAT Editor');
  InKey(Ch,Fk,Key);
  HtStoreToScr(HelpRow-1,HelpCol-1,HelpRows+3,HelpCols+4,HelpScr);
  Key:=NullKey;
END;


PROCEDURE EditFATs;
VAR  ActiveFAT : BYTE;
     Equal,
     Changed : BOOLEAN;
BEGIN
  Offset     := 0;
  WindOffset := 0;
  ActiveFAT  := 1;
  ReadFAT(Drive,FAT1Addr,FATBuf1);
  ReadFAT(Drive,FAT2Addr,FATBuf2);
  Changed := FALSE;
  Equal := CheckEqual(FATBuf1,FATBuf2);
  WriteFATHex(WindOffset,ActiveFAT);
  WriteFATCommands(Equal);
  WriteFATOffset(WindOffset,Offset,FATBuf1,FATBuf2);
  ShowPosition(Offset,ActiveFAT);
  REPEAT
    InKey(Ch,Fk,Key);
    WriteCursor(WindOffset,Offset,HexAttr);
    CASE Key OF
      TabKey     : BEGIN
                     IF ActiveFAT=1 THEN
                       ActiveFAT:=2
                     ELSE ActiveFAT:=1;
                     WriteFATHex(WindOffset,ActiveFAT);
                   END;
      LeftArrow  : Dec(Offset);
      RightArrow : Inc(Offset);
      UpArrow    : Dec(Offset,16);
      DownArrow  : Inc(Offset,16);
      HomeKey    : BEGIN
                     Offset := 0;
                     WindOffset := 0;
                     WriteFATHex(WindOffset,ActiveFAT);
                   END;
      EndKey     : BEGIN
                     Offset := MaxOffset;
                     WindOffset := Offset - 16*FATRows + 1;
                     WriteFATHex(WindOffset,ActiveFAT);
                   END;
      PgDn       : BEGIN
                     Inc(Offset,16*FATRows);
                     Inc(WindOffset,16*FATRows);
                     IF Offset>=MaxOffset THEN
                     BEGIN
                       Offset := MaxOffset;
                       WindOffset := Offset - 16*FATRows + 1;
                     END;
                     WriteFATHex(WindOffset,ActiveFAT);
                   END;
      PgUp       : BEGIN
                     Dec(Offset,16*FATRows);
                     Dec(WindOffset,16*FATRows);
                     IF Offset<=0 THEN
                     BEGIN
                       Offset := 0;
                       WindOffset := 0;
                     END;
                     WriteFATHex(WindOffset,ActiveFAT);
                   END;
      F1         : Help;
      F2         : BEGIN
                     WriteFAT(Drive,FAT1Addr,FATBuf1);
                     WriteFAT(Drive,FAT2Addr,FATBuf2);
                     Changed := FALSE;
                   END;
      F3         : BEGIN
                     FATBuf2 := FATBuf1;
                     WriteFATHex(WindOffset,ActiveFAT);
                     Equal := TRUE;
                     WriteFATCommands(Equal);
                   END;
      F4         : BEGIN
                     FATBuf1 := FATBuf2;
                     WriteFATHex(WindOffset,ActiveFAT);
                     Equal := TRUE;
                     WriteFATCommands(Equal);
                   END;
      F5         : ShowBootInfo;
      F6         : FindDifference;
      Return     : BEGIN
                     EditByte(WindOffset,Offset,ActiveFAT,Changed);
                     Equal := CheckEqual(FATBuf1,FATBuf2);
                     WriteFATCommands(Equal);
                   END;
    END;
    IF Offset<0 THEN Offset:=0;
    IF Offset>MaxOffset THEN Offset:=MaxOffset;
    IF Key IN [F2,F3] THEN
    BEGIN
      Equal := CheckEqual(FATBuf1,FATBuf2);
      WriteFATCommands(Equal);
    END;
    WriteFATOffset(WindOffset,Offset,FATBuf1,FATBuf2);
    ShowPosition(Offset,ActiveFAT);
  UNTIL Key=Escape;
  IF Changed THEN
    AskSaveFAT(FAT1Addr,FAT2Addr,FATBuf1,FATBuf2);
END;


PROCEDURE WriteInfo;
BEGIN
  WriteLn;
  WriteLn('USAGE : FLOPPY Drive');
  WriteLn;
  WriteLn('        where Drive is the name of the floppy drive');
  WriteLn;
  WriteLn('Ex :    FLOPPY A:');
  WriteLn;
  Halt(1);
END;


FUNCTION DriveOK(Drive : BYTE) : BOOLEAN;
VAR NumDrives : BYTE;
BEGIN
  FillChar(Regs,SizeOf(Regs),0);
  Intr($11,Regs);
  NumDrives := (Regs.AX SHR 6) AND $03;
  IF Drive>NumDrives THEN
    DriveOK := FALSE
  ELSE DriveOK := TRUE;
END;


PROCEDURE GetParam(VAR Drive : BYTE);
VAR C : CHAR;
    S : STRING;
BEGIN
  IF ParamCount<>1 THEN WriteInfo;
  S := ParamStr(1);
  C := S[1];
  IF NOT (C IN ['a','A','b','B']) THEN WriteInfo;
  CASE C OF
    'a','A' : Drive := $00;
    'b','B' : Drive := $01;
  END;
  IF NOT DriveOK(Drive) THEN
  BEGIN
    WriteLn('Error reading drive '+ParamStr(1)+' !');
    Halt(1);
  END;
END;


BEGIN
  GetParam(Drive);
  InitFATs;
  SetCursor(CursorOff);
  Cylinder := 0;  Sector := 1;  Head := 0;
  MainBackground;
  Reading;
  GetBootInfo(Drive);
  GetBootInfo(Drive);
  IF NumberOfFATs=2 THEN  EditFATS;
  SetCursor(CursorUnderLine);
  HtClrScr;
  IF NumberOfFATs<>2 THEN WriteLn('Wrong number of FATs !');
END.
