/***
*general.h - definitions/declarations for general C programs
*
*for Public Domain, 1995, Gregg Jennings.  All wrongs reserved.
*   P O Box 200, Falmouth, MA 02541-0200
*
*Purpose:
*   Compiler specifics.
*
*Notice:
*   This source file may be freely used and distributed without restriction.
*******************************************************************************/

/*

   Versions

   This will change very often (the more compiler testing
   I do, ...).

   Notes:   I like the use of leading underscores for all
            non-ANSI library functions and typedefs.  Only
            CL 7.00+ adheres to this "standard".

*/


#ifndef GENERAL_H
#define GENERAL_H


/* compiler dependencies -- see ALLOC.H for more */

#if defined(_MSC_VER)

 #if defined(M_I86LM) || defined(M_I86CM)       /* determine memory model */
  #define __LARGE__                             /* (easier to remember) */
 #endif

 #if _MSC_VER >= 600
  #define _ASM_DEFINED
 #endif

 #if _MSC_VER < 700
  #define __far    _far
  #define __huge   _huge
  #define _MK_FP(seg, offset) (void __far *)(((unsigned long)seg << 16) \
    + (unsigned long)(unsigned)offset)
 #endif

#elif defined(__BORLANDC__) || defined(__TURBOC__)

 #if !defined(__BORLANDC__)
  #define __BORLANDC__  __TURBOC__              /* stupid Turbo C! */
 #endif

#endif


#if (defined(_MSC_VER) && (_MSC_VER < 700)) || !defined(_MSC_VER)

 #ifndef __WATCOMC__
   #define _ASM_DEFINED
 #endif
 #define __inline
 #define _chdir      chdir
 #define _getcwd     getcwd
 #define _intdos     intdos
 #define _intdosx    intdosx
 #define _int86      int86
 #define _int86x     int86x
 #define _segread    segread
 #ifndef _FP_OFF
   #define _FP_OFF     FP_OFF
   #define _FP_SEG     FP_SEG
 #endif
 #ifndef _MK_FP
   #define _MK_FP(seg, offset) (void __far *)(((unsigned long)seg << 16) \
    + (unsigned long)(unsigned)offset)
 #endif
 #define _REGS       REGS
 #define _SREGS      SREGS
 #define _access     access
 #define _file_t     file_t
 #define _find_t     find_t
 #define _diskfree_t diskfree_t
 #define _open       open
 #define _write      write
 #define _read       read
 #define _close      close
 #define _filelength filelength
 #define _O_RDONLY   O_RDONLY
 #define _O_BINARY   O_BINARY
 #define _O_CREAT    O_CREAT
 #define _O_TRUNC    O_TRUNC
 #define _O_RDWR     O_RDWR
 #define _S_IWRITE   S_IWRITE
 #define _S_IREAD    S_IREAD

#endif

#define OK    1
#define FALSE 0
#define TRUE  1
#define ERROR (-1)
#define ABORT (-2)
#define ESC   0x1b


/*
   These are for (potentially) moving to a 32-bit compiler.
   word will then have to be unsigned short (if done now,
   there will be many "integral mismatch" warnings).
*/

typedef unsigned char byte;
typedef unsigned int word;
typedef unsigned long dword;

#endif
