/***
*error.h - disked definitions/declarations for errno/perror() like error
*          handling.
*
*Copyright (c) 1991-1995, Gregg Jennings.  All wrongs reserved.
*   P O Box 200, Falmouth, MA 02541-0200
*
*Purpose:
*   Error messages.
*
*Notice:
*   This progam may be freely used and distributed.  Any distrubution
*   with modifications must retain the above copyright statement and
*   modifications noted.
*   No pulp-publication, in whole or in part, permitted without
*   permission (magazines or books).
*******************************************************************************/

/* errno-like error information */

struct error_t {
   const char *mod;                 /* module name */
   const char *func;                /* function name */
   const char *msg;                 /* error message */
   const char *arg;                 /* error argument */
   const char *info;                /* error or OS information */
   int  num;                        /* error number */
};

/* global (or shared) error conditions */

enum ERROR_MSG {
   REQ_DOS_3,                       /* files.c */
   NO_MEM,
   FAT_PHASE,
   INV_CLUS,
   INV_ST_CLUS,
   NUM_FILES,
   ALLOC_ZERO,                      /* alloc.c */
   FREE_NULL,
   HEAP_ERROR,
   ALLOC_FAIL,
   NUM_ERR_MSG
};

extern struct error_t error;
extern const char *err_msg[NUM_ERR_MSG];

extern void printerror(int ext);
extern void set_error(const char *msg, const char *mod, int err, const char *func);
extern void set_err_num(int error);
extern void set_err_arg(const char *fmt, ...);
extern void set_err_info(const char *fmt, ...);
