/*

   DPMICALL.H

*/

#ifndef _DPMICALL_H
#define _DPMICALL_H

#include "ccommon.h"
#ifdef C_DPMI

#include <stddef.h>

struct _rminfo_struct
{
   long edi;
   long esi;
   long ebp;
	long reserved_by_system;
   long ebx;
   long edx;
   long ecx;
   long eax;
	short flags;
   short es,ds,fs,gs,ip,cs,sp,ss;
};
typedef struct _rminfo_struct rminfo_struct;

#ifdef __386__
#define DPMI_FAR far
#else
#define DPMI_FAR
#endif

void DPMI_FAR *dpmi_get_dos_ptr(short selector);
void dpmi_copy_to_dos(short selector, void *ptr, size_t len);
void dpmi_copy_from_dos(short selector, void *ptr, size_t len);
int dpmi_alloc_dos_memory(int size, short *selector, short *segment );
int dpmi_free_dos_memory(short selector);
unsigned dpmi_simulate_rmi(int int_no, rminfo_struct *rmi);

#endif

#endif
