/*
 * This program implements a simple "calculator" using LONG numbers.
 * It demonstrates the "long" math functions from the library.
 *
 * Copyright 1994-1995 Dave Dunfield
 * All rights reserved.
 *
 * Permission granted for personal (non-commercial) use only.
 *
 * Compile command: cc longcalc -fop
 */
#include <stdio.h>
#include <window.h>

/*
 * Default LONG number size is 4 bytes (32 bits). If you wish to change
 * this (up to 256 bits), edit the 'LSIZE' definitions in the LONGMATH.ASM
 * and LONGRTNS.C files in the library. You also have to adjust the sizes
 * of all array declarations which are to contain LONG numbers. For this
 * demo, just adjust the constant defined below.
 */
#define	LSIZE	4		/* 32 bit numbers */

/*
 * Long number registers
 */
char reg[LSIZE], temp[LSIZE];

/*
 * Input/Output Digit buffer. Note that we use an approximation to
 * compute the number of digits required based on the size of the
 * LONG numbers.
 */
char buffer[(LSIZE*25)/10+1];

/*
 * This temporary variable used by the LONGMATH functions is useful,
 * because it will contain the remainder after a division.
 */
extern char Longreg[];

/*
 * Main calculator program
 */
main()
{
	unsigned char c, op;
	char *ptr;

	wopen(0, 0, 80, 25, WSAVE|WCOPEN|WBOX1|WWRAP|WSCROLL|NORMAL);
	wputs("Long Number Calculator,  Supports: + - * / % = ENTER(clear) ESC(exit)\n");

clear:			/* Clear the calculator by forcing a copy operation */
	wputs("Clear\n");
	op = '=';
	ptr = buffer;						/* Begin processing a number */

	for(;;) {							/* Continue processing a number */
		while(isdigit(c = wgetc())) {		/* Collect digits into string */
			wputc(c);
			*ptr++ = c; }
		*ptr = 0;							/* Zero terminate */
		atol(buffer, temp, 10);				/* Get LONG value for operation */
	
		switch(op) {						/* Perform pending operation */
			case '=' :	longcpy(reg, temp);	break;
			case '+' :	longadd(reg, temp);	break;
			case '-' :	longsub(reg, temp);	break;
			case '*' :	longmul(reg, temp);	break;
			case '/' :	longdiv(reg, temp);	break;
			case '%' :	longdiv(reg, temp); longcpy(reg, Longreg); }
	
operate:									/* Process next operator */
		wputc(c);							/* Echo next command */
		switch(c) {
			case 0x1B:						/* Exit */
				wclose();
				return;
			default:						/* Unrecognized */
				wputs(" ?Invalid input... ");
			case '\n' :						/* Clear */
				goto clear;
			case '=' :						/* Display results */
				ltoa(reg, buffer, 10);
				wputs(buffer);
				if(!isdigit(c = wgetc()))	/* Chained operation */
					goto operate;
				wputc('\n');
				wputc(c);
				op = '=';
				ptr = buffer;
				*ptr++ = c;
				continue;
			case '+' :						/* Addition */
			case '-' :						/* Subtraction */
			case '*' :						/* Multiplication */
			case '/' :						/* Division */
			case '%' :						/* Modulus */
				op = c; }
		ptr = buffer; }						/* Reset number pointer */
}
