/*
* BUZZWORD.C  A public domain Buzzword Generator written by Ken Wetz
* Idea for it found in a fidonet message by Joe Smyth.
* message follows:
* After years of hacking through etymotological thickets at the US Public
* Health Service, a 63 year old official named Phillip Broughton hit upon a
* sure-fire method for converting frustation into fulfillment (jargonwise).
* Euphemistically called the Systematic Buzz Phrase Projector, Broughton's
* system employes a lexican of 30 carefully chosen "buzzwords". To use it
* pick 3 groups of numbers then pick a corresponding buzzword from each
* column. For instance, number 257 produces "systematized logistical
* projection", a phrase that can be dropped into virtually any report or
* conversation with that ring of decisive, knowlegable authority."No one
* will have the foggiest gotest idea of what your talking about", says
* Broughton.  "But the important thing is that they're not about to admit.
* END OF MESSAGE
* This program takes Mr. Broughtons buzzword groups and choses a phase from
* them at random. Can be ran as BUZZWORD DELAY with delay being any whole
* number between 1 and 65535 ms.
*
* Compile command: cc buzz -fop
*/
#include <stdio.h>

#define NELEM(array) (sizeof(array)/sizeof(array[0]))

char *buzz1[] = {
	"integrated", "total", "systematized", "parallel", "functional",
	"responsive", "optional", "synchronized", "compatible", "balanced"
	};
char *buzz2[] = {
	"management", "organizational", "monitored", "reciprocal", "digital",
	"logistical", "transitional", "incremental", "third-generation", "policy"
	};
char *buzz3[] = {
	"options", "flexibility", "capability", "mobility", "programming",
	"concept", "time-phase", "projection", "hardware", "contingency"
	};

main(int argc, char *argv[])
{
	unsigned o;
	o = (argc < 2) ? 1000 : atoi(argv[1]);
	for(;;) {
		printf(" Buzzword : %s %s %s \n",
			buzz1[random(NELEM(buzz1))],
			buzz2[random(NELEM(buzz2))],
			buzz3[random(NELEM(buzz3))]);
		delay(o); }
}
