
//      Cluster of spheres intended to reproduce one of the test
//      images included with RayShade.

#include color.vc

studio {
	from 2.31 1.43 1.65
	at 0 0 -0.1
	up 0 0 1
	angle 45
	res 320 200
	antialias adaptive
	threshold 8
	aspect 1.3333
	background sky_blue
}

light {
	type point
	falloff 0
	position 4 3 2
	color .3 .3 .3
}
light {
	type point
	falloff 0
	position 1 -4 4
	color .3 .3 .3
}
light {
	type point
	falloff 0
	position -3 1 5
	color .3 .3 .3
}

surface {
	amb 0.15 0.1 0.045
	diffuse 1.0 0.75 0.33
}
ring {
	center 0 0 -.5
	normal 0 0 1
	radius 20
}

surface {
	bump {
		turbulence {
			scale .025 .025 .025
			amp .5
			terms 5
		}
	}
	amb 0.035 0.0325 0.025
	diffuse 0.5 0.45 0.35
	spec 0.4 0.4 0.4
	shine 3
}
sphere { radius .5 center 0 0 0 }

surface {
	amb 0.035 0.0325 0.025
	diffuse 0.5 0.45 0.35
	spec 0.4 0.4 0.4
	shine 3
}

sphere { radius 0.166667 center 0.272166 0.272166 0.544331 }
sphere { radius 0.166667 center 0.643951 0.172546 0 }
sphere { radius 0.166667 center 0.172546 0.643951 0 }
sphere { radius 0.166667 center -0.371785 0.0996195 0.544331 }
sphere { radius 0.166667 center -0.471405 0.471405 0 }
sphere { radius 0.166667 center -0.643951 -0.172546 0 }
sphere { radius 0.166667 center 0.0996195 -0.371785 0.544331 }
sphere { radius 0.166667 center -0.172546 -0.643951 0 }
sphere { radius 0.166667 center 0.471405 -0.471405 0 }

