#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <i86.h>
#include <dos.h>

/*
 * TextFX by Jari Komppa
 *
 * Textmode low-level functions (80x43,nb)
 */

/***********************/
/* Compilation options */
/***********************/

#define Use_Real_IBM_Palette
    /* The above gives/may give more accurate results than */
    /* the default one.. */

/********************/
/* Data & variables */
/********************/

#ifdef Use_Real_IBM_Palette

char palette[16*3]={ /* IBM basic palette, 16c, for calcpal */
 0, 0, 0,  0, 0,42,  0,42, 0,  0,42,42, 42, 0, 0, 42, 0,42, 42,21, 0, 42,42,42,
21,21,21, 21,21,63, 21,63,21, 21,63,63, 63,21,21, 63,21,63, 63,63,21, 63,63,63};

#else

char palette[16*3]={ /* This may give better results in some cases.. */
 0, 0, 0,  0, 0,32,  0,32, 0,  0,32,32, 32, 0, 0, 32, 0,32, 32,16, 0, 32,32,32,
16,16,16,  0, 0,63,  0,63, 0,  0,63,63, 63, 0, 0, 63, 0,63, 63,63, 0, 63,63,63};

#endif

/**************/
/* Prototypes */
/**************/

void set80x43(void); /* Sets up 80x43, no blink, no cursor. */

void set80x25(void); /* Resets 80x25, blink, cursor. */

short int calcpal(int red, int green, int blue);
    /* Finds the closest color/char combo for any 0:63,0:63,0:63 value. */
    /* NOT MEANT FOR REALTIME USE, so just calculate your palette with  */
    /* this before effect. */

void border(char color); /* _ONLY_ for debugging! */

void vrc(void); /* Although most if not all should be timer-synced.. */

void writechar(int x, int y, int ch, int col);
    /* Primitive putpixel. */

void writeword(int x, int y, int col);
    /* Better, but you still shoudn't use these.. :) */

/*************/
/* Functions */
/*************/


void writechar(int x, int y, int ch, int col) {
    *(char *)(0xb8000+(x*2)+(y<<7)+(y<<5))=ch;
    *(char *)(0xb8000+(x*2)+(y<<7)+(y<<5)+1)=col;
}

void writeword(int x, int y, int col) {
    *(short int *)(0xb8000+(x*2)+(y<<7)+(y<<5))=col;
}

void vrc(void) {
    while ((inp(0x3da)&8)==0) {}
    while ((inp(0x3da)&8)!=0) {}
}

void border(char color) {
    inp(0x3da);
    outp(0x3c0,17+32);
    outp(0x3c0,color);
}


short int calcpal(int red, int green, int blue) {
int b,c,ch,co;
float lastdist,dist,c1,c2,c3;
        c1=red;
        c2=green;
        c3=blue;
        lastdist=100000000;
        for (c=0;c<16;c++)
        for (b=0;b<16;b++) {
            dist=abs(-c1+((float)(palette[b*3]+palette[c*3])/2))+
                 abs(-c2+((float)(palette[b*3+1]+palette[c*3+1])/2))+
                 abs(-c3+((float)(palette[b*3+2]+palette[c*3+2])/2));
            if (dist<lastdist) {
                lastdist=dist;
                co=b+(c*16);
                ch=177;
            }
            dist=abs(-c1+(float)(palette[b*3]))+
                 abs(-c2+(float)(palette[b*3+1]))+
                 abs(-c3+(float)(palette[b*3+2]));
            if (dist<lastdist) {
                lastdist=dist;
                co=b;
                ch=219;
            }
            dist=abs(-c1+((float)palette[b*3]*0.67+(float)palette[c*3]*0.3))+
                 abs(-c2+((float)palette[b*3+1]*0.67+(float)palette[c*3+1]*0.3))+
                 abs(-c3+((float)palette[b*3+2]*0.67+(float)palette[c*3+2]*0.3));
            if (dist<lastdist) {
                lastdist=dist;
                co=b+(c*16);
                ch=178;
            }
            dist=abs(-c1+((float)palette[b*3]*0.33+(float)palette[c*3]*0.6))+
                 abs(-c2+((float)palette[b*3+1]*0.33+(float)palette[c*3+1]*0.6))+
                 abs(-c3+((float)palette[b*3+2]*0.33+(float)palette[c*3+2]*0.6));
            if (dist<lastdist) {
                lastdist=dist;
                co=b+(c*16);
                ch=176;
            }
        }
    return((co<<8)+ch);
}


void set80x43(void) {
union REGS regs;
        regs.w.ax=0x1201; /* Set scanlines */
        regs.h.bl=0x30;
        int386(0x10,&regs,&regs);
        regs.w.ax=0x3;    /* Set text mode */
        int386(0x10,&regs,&regs);
        regs.w.ax=0x1112; /* Set font */
        regs.w.bx=0;
        int386(0x10,&regs,&regs);
        regs.h.bh=0;      /* Kill cursor - doesn't seem to work.. */
        regs.h.ah=3;
        int386(0x10,&regs,&regs);
        regs.w.cx&=0x2000;
        regs.h.ah=1;
        int386(0x10,&regs,&regs);
        regs.w.ax=0x1003; /* Kill blink */
        regs.h.bl=0;
        int386(0x10,&regs,&regs);
        regs.w.ax=0x0200;   /* Position cursor to 51,80 */
        regs.w.bx=0x0033;
        regs.w.dx=0x004f;
        int386(0x10,&regs,&regs);
}

void set80x25(void) {
union REGS regs;
        regs.w.ax=0x1202; /* Set scanlines */
        regs.h.bl=0x30;
        int386(0x10,&regs,&regs);
        regs.w.ax=0x3;    /* Set text mode */
        int386(0x10,&regs,&regs);
        regs.w.ax=0x1114; /* Set font */
        regs.w.bx=0;
        int386(0x10,&regs,&regs);
        regs.h.bh=0;      /* Ressurrect cursor */
        regs.h.ah=3;
        int386(0x10,&regs,&regs);
        regs.w.cx&=0xdfff;
        regs.h.ah=1;
        int386(0x10,&regs,&regs);
        regs.w.ax=0x1003; /* Enable blink */
        regs.h.bl=1;
        int386(0x10,&regs,&regs);
}
