TAR(1)              UNIX Programmer's Manual               TAR(1)



NAME
     tar - tape (or other media) file archiver

SYNOPSIS
     tar -[BcdDhiklmopRstvxzZ] [-b N] [-f F] [-T F] [ filename or
     regexp ...  ]

DESCRIPTION
     tar provides a way to store many files into a single
     archive, which can be kept in another Unix file, stored on
     an I/O device such as tape, floppy, cartridge, or disk, sent
     over a network, or piped to another program.  It is useful
     for making backup copies, or for packaging up a set of files
     to move them to another system.

     tar has existed since Version 7 Unix with very little
     change.  It has been proposed as the standard format for
     interchange of files among systems that conform to the IEEE
     P1003 ``Portable Operating System'' standard.

     This version of tar supports some of the extensions which
     were proposed in the P1003 draft standards, including owner
     and group names, and support for named pipes, fifos, con-
     tiguous files, and block and character devices.

     When reading an archive, this version of tar continues after
     finding an error.  Previous versions required the `i' option
     to ignore checksum errors.

OPTIONS
     tar options can be specified in either of two ways.  The
     usual Unix conventions can be used: each option is preceded
     by `-'; arguments directly follow each option; multiple
     options can be combined behind one `-' as long as they take
     no arguments.  For compatability with the Unix tar program,
     the options may also be specified as ``keyletters,'' wherein
     all the option letters occur in the first argument to tar,
     with no `-', and their arguments, if any, occur in the
     second, third, ...  arguments.  Examples:

     Normal:  tar -f arcname -cv file1 file2

     Old:  tar fcv arcname file1 file2

     At least one of the -c, -t, -d, or -x options must be
     included.  The rest are optional.

     Files to be operated upon are specified by a list of file
     names, which follows the option specifications (or can be
     read from a file by the -T option).  Specifying a directory
     name causes that directory and all the files it contains to
     be (recursively) processed.  If a full path name is speci-
     fied when creating an archive, it will be written to the
     archive without the initial "/", to allow the files to be
     later read into a different place than where they were



Printed 5/26/91          5 November 1987                        1



TAR(1)              UNIX Programmer's Manual               TAR(1)



     dumped from, and a warning will be printed.  If files are
     extracted from an archive which contains full path names,
     they will be extracted relative to the current directory and
     a warning message printed.

     When extracting or listing files, the ``file names'' are
     treated as regular expressions, using mostly the same syntax
     as the shell.  The shell actually matches each substring
     between ``/''s separately, while tar matches the entire
     string at once, so some anomalies will occur; e.g. ``*'' or
     ``?'' can match a ``/''.  To specify a regular expression as
     an argument to tar, quote it so the shell will not expand
     it.

     -b N Specify a blocking factor for the archive.  The block
          size will be N x 512 bytes.  Larger blocks typically
          run faster and let you fit more data on a tape.  The
          default blocking factor is set when tar is compiled,
          and is typically 20.  There is no limit to the maximum
          block size, as long as enough memory can be allocated
          for it, and as long as the device containing the
          archive can read or write that block size.

     -B   When reading an archive, reblock it as we read it.
          Normally, tar reads each block with a single read(2)
          system call.  This does not work when reading from a
          pipe or network socket under Berkeley Unix; read(2)
          only gives as much data as has arrived at the moment.
          With this option, it will do multiple read(2)s to fill
          out to a record boundary, rather than reporting an
          error.  This option is default when reading an archive
          from standard input, or over a network.

     -c   Create an archive from a list of files.

     -d   Diff an archive against the files in the file system.
          Reports differences in file size, mode, uid, gid, and
          contents.  If a file exists on the tape, but not in the
          file system, that is reported.  This option needs
          further work to be really useful.

     -D   When creating an archive, only dump each directory
          itself; don't dump all the files inside the directory.
          In conjunction with find(1), this is useful in creating
          incremental dumps for archival backups, similar to
          those produced by dump(8).

     -f F Specify the filename of the archive.  If the specified
          filename is ``-'', the archive is read from the stan-
          dard input or written to the standard output.  If the
          -f option is not used, and the environment variable
          TAPE exists, its value will be used; otherwise, a
          default archive name (which was picked when tar was
          compiled) is used.  The default is normally set to the
          ``first'' tape drive or other transportable I/O medium



Printed 5/26/91          5 November 1987                        2



TAR(1)              UNIX Programmer's Manual               TAR(1)



          on the system.

          If the filename contains a colon before a slash, it is
          interpreted as a ``hostname:/file/name'' pair.  tar
          will invoke the commands rsh and dd to access the
          specified file or device on the system hostname.  If
          you need to do something unusual like rsh with a dif-
          ferent user name, use ``-f -'' and pipe it to rsh manu-
          ally.

     -h   When creating an archive, if a symbolic link is encoun-
          tered, dump the file or directory to which it points,
          rather than dumping it as a symbolic link.

     -i   When reading an archive, ignore blocks of zeros in the
          archive.  Normally a block of zeros indicates the end
          of the archive, but in a damaged archive, or one which
          was created by appending several archives, this option
          allows tar to continue.  It is not on by default
          because there is garbage written after the zeroed
          blocks by the Unix tar program.  Note that with this
          option set, tar will read all the way to the end of the
          file, eliminating problems with multi-file tapes.

     -k   When extracting files from an archive, keep existing
          files, rather than overwriting them with the version
          from the archive.

     -l   When dumping the contents of a directory to an archive,
          stay within the local file system of that directory.
          This option only affects the files dumped because they
          are in a dumped directory; files named on the command
          line are always dumped, and they can be from various
          file systems.  This is useful for making ``full dump''
          archival backups of a file system, as with the dump(8)
          command.  Files which are skipped due to this option
          are mentioned on the standard error.

     -m   When extracting files from an archive, set each file's
          modified timestamp to the current time, rather than
          extracting each file's modified timestamp from the
          archive.

     -o   When creating an archive, write an old format archive,
          which does not include information about directories,
          pipes, fifos, contiguous files, or device files, and
          specifies file ownership by uid's and gid's rather than
          by user names and group names.  In most cases, a
          ``new'' format archive can be read by an ``old'' tar
          program without serious trouble, so this option should
          seldom be needed.

     -p   When extracting files from an archive, restore them to
          the same permissions that they had in the archive.  If
          -p is not specified, the current umask limits the



Printed 5/26/91          5 November 1987                        3



TAR(1)              UNIX Programmer's Manual               TAR(1)



          permissions of the extracted files.  See umask(2).

     -R   With each message that tar produces, print the record
          number within the archive where the message occurred.
          This option is especially useful when reading damaged
          archives, since it helps to pinpoint the damaged sec-
          tion.

     -s   When specifying a list of filenames to be listed or
          extracted from an archive, the -s flag specifies that
          the list is sorted into the same order as the tape.
          This allows a large list to be used, even on small
          machines, because the entire list need not be read into
          memory at once.  Such a sorted list can easily be
          created by running ``tar -t'' on the archive and edit-
          ing its output.

     -t   List a table of contents of an existing archive.  If
          file names are specified, just list files matching the
          specified names.  The listing appears on the standard
          output.

     -T F Rather than specifying file names or regular expres-
          sions as arguments to the tar command, this option
          specifies that they should be read from the file F, one
          per line.  If the file name specified is ``-'', the
          list is read from the standard input.  This option, in
          conjunction with the -s option, allows an arbitrarily
          large list of files to be processed, and allows the
          list to be piped to tar.

     -v   Be verbose about the files that are being processed or
          listed.  Normally, archive creation, file extraction,
          and differencing are silent, and archive listing just
          gives file names.  The -v option causes an ``ls
          -l''-like listing to be produced.  The output from -v
          appears on the standard output except when creating an
          archive (since the new archive might be on standard
          output), where it goes to the standard error output.

     -V   Print the version and authors of the program.

     -x   Extract files from an existing archive.  If file names
          are specified, just extract files matching the speci-
          fied names, otherwise extract all the files in the
          archive.

     -z or -Z
          The archive should be compressed as it is written, or
          decompressed as it is read, using the compress(1) pro-
          gram.  This option works on I/O devices and over the
          network, as well as on disk files; data to or from such
          devices is reblocked using a ``dd'' command to enforce
          the specified (or default) block size.  The default
          compression parameters are used; if you need to



Printed 5/26/91          5 November 1987                        4



TAR(1)              UNIX Programmer's Manual               TAR(1)



          override them, avoid the ``z'' option and compress it
          yourself.

AUTHORS
     Tar and compress were integrated for the MS-DOS release by
     Diomidis Spinellis <dds@doc.ic.ac.uk>.
     Tar was written by John Gilmore <gnu@toad.com>.
     Compress was written and improved by Spencer W. Thomas, Jim
     McKie, Steve Davies, Ken Turkowski, James A. Woods, Joe
     Orost and Diomidis Spinellis.

SEE ALSO
     shar(1), tar(5), compress(1), ar(1), arc(1), cpio(1),
     dump(8), restore(8), restor(8), rsh(1), dd(1), find(1)

BUGS
     The r, u, w, X, l, F, C, and digit options of Unix tar are
     not supported.

     Multiple-tape (or floppy) archives should be supported, but
     so far no clean way has been implemented.

     A bug in the Bourne Shell usually causes an extra newline to
     be written to the standard error when using compressed or
     remote archives.

     A bug in ``dd'' prevents turning off the ``x+y records
     in/out'' messages on the standard error when ``dd'' is used
     to reblock or transport an archive.

     On MS-DOS systems filename characters that are not supported
     by most MS-DOS shells (;=+<>|,*?:[]\ ) are silently con-
     verted into a circumflex (^) character.  Filanemes longer
     than the ones supported by MS-DOS are silently truncated and
     can thus overwrite files named with the same initial charac-
     ters.






















Printed 5/26/91          5 November 1987                        5



