
/*
        PC IRQ handeling routines for WatcomC++.

        By Hkan Wallin (the edge/CDA)


        NOTE!
         Routines in this file may be called by interrupt code,
         where SS != DS.
         Therefore, this file must be compiled with the /zu option.

*/

//

#include <conio.h>
#include "irq.h"

//


//
// Sends specific EndOfInterrupt signal to PIC.

void
irq_sendEOI(char nr)
{
        if (nr < 8)
            outp(0x20,0x60 | nr);
        else
        {
            outp(0xa0,0x60 | (nr & 7));
            outp(0x20,0x20);
        }
}

//
// Calls an interrupt handler, given a near pointer to a void far*.

void
call_interrupt(void far** handler)
{
        (*(void(interrupt far*)()) *handler)();
}





//

//

