
/*
   CapaPlay II Unit for C/C++
*/

typedef unsigned char byte;
typedef unsigned int word;
typedef unsigned long int dword;

/****************************** GUS Settings *********************************/

extern "C" far byte CP_GetIRQ();
extern "C" far void CP_SetIRQ(byte NewIRQ);
extern "C" far byte CP_GetDMA();
extern "C" far void CP_SetDMA(byte NewDMA);
extern "C" far word CP_GetBasePort();
extern "C" far void CP_SetBasePort(word NewBasePort);
extern "C" far void CP_SetLineIn(byte LineInState);
extern "C" far void CP_SetMicIn(byte MicInState);

/******************************* Load/Unload *********************************/

extern "C" far byte CP_LoadModule(char *ModName,dword StartOffset,byte TransferMode);
extern "C" far byte CP_LoadOnlyPatterns(char *ModName,dword StartOffset,byte TransferMode);
extern "C" far void CP_FreeModule();

/***************************** Start/Stop/Pause ******************************/

extern "C" far void CP_StartModule(byte Amplification,byte DefaultPanning,byte TimerMode);
extern "C" far void CP_StopModule();
extern "C" far byte CP_PauseModule();

/********************** Set General Module Information ***********************/

extern "C" far void CP_SetSpeedZeroMode(byte SpeedZeroMode);
extern "C" far void CP_SetPanEffectMode(byte PanEffectMode);
extern "C" far void CP_SetVBlankMode(byte VBlankMode);
extern "C" far void CP_SetAmigaLimitsMode(byte AmigaLimitsMode);

/********************** Get General Module Information ***********************/

extern "C" far char *CP_GetModuleName();
extern "C" far byte CP_GetModuleType();
extern "C" far byte CP_GetModuleLength();
extern "C" far word CP_GetNumOfPatterns();
extern "C" far byte CP_GetNumOfInstruments();
extern "C" far byte CP_GetNumOfChannels();
extern "C" far byte CP_GetNumOfUsedChannels();
extern "C" far byte CP_GetRestartPosition();
extern "C" far dword CP_GetUsedPatternMemory();
extern "C" far dword CP_GetUsedInstrumentInfoMemory();
extern "C" far dword CP_GetUsedGUSMemory();			       
extern "C" far dword CP_GetFileSize();

/********************** Set General Playing Information **********************/

extern "C" far void CP_SetPosition(word NewPosition);
extern "C" far void CP_SetGlobalVolume(word NewVolume);
extern "C" far void CP_SetMainVolume(word NewVolume);
extern "C" far void CP_RestoreInitialVolume();
extern "C" far void CP_SetSpeed(word NewSpeed);
extern "C" far void CP_SetTempo(word NewTempo);
extern "C" far void CP_RestoreSpeedAndTempo();
extern "C" far void CP_SetDefaultPanning(char DefaultPanning);

/********************** Get General Playing Information **********************/

extern "C" far byte CP_GetRow();
extern "C" far word CP_GetNumOfRows(word PositionNum);
extern "C" far byte CP_GetPosition();
extern "C" far byte CP_GetPattern();
extern "C" far byte CP_GetGlobalVolume();
extern "C" far byte CP_GetMainVolume();
extern "C" far byte CP_GetSpeed();
extern "C" far byte CP_GetTempo();
extern "C" far word CP_GetPlayingTime();
extern "C" far dword CP_GetTimer();
extern "C" far byte CP_GetLoopCounter();

/************************* Set Channel Information ***************************/

extern "C" far byte CP_SetChannelMute(word ChannelNum,byte MuteState);
extern "C" far void CP_SetChannelPanning(word ChannelNum,byte NewPanning);
extern "C" far void CP_PlaySample(word ChannelNum,word InstrumentNum,word SampleNum,byte Note,byte Octave);
extern "C" far void CP_StopSample(word ChannelNum);

/************************* Get Channel Information ***************************/

extern "C" far byte CP_GetChannelNote(word ChannelNum);
extern "C" far byte CP_GetChannelOctave(word ChannelNum);
extern "C" far byte CP_GetChannelVolume(word ChannelNum);
extern "C" far byte CP_GetChannelEffect(word ChannelNum);
extern "C" far byte CP_GetChannelEffectParams(word ChannelNum);
extern "C" far byte CP_GetChannelInstrument(word ChannelNum);
extern "C" far byte CP_GetChannelSample(word ChannelNum);
extern "C" far byte CP_GetChannelBar(word ChannelNum);
extern "C" far byte CP_GetChannelNoteTrigger(word ChannelNum);
extern "C" far byte CP_GetChannelPanning(word ChannelNum);
extern "C" far byte CP_GetChannelMute(word ChannelNum);

/******************** Set Instrument/Sample Information **********************/

extern "C" far byte CP_SetSampleMute(word InstrumentNum,word SampleNum,byte MuteState);

/******************** Get Instrument/Sample Information **********************/

extern "C" far char *CP_GetInstrumentName(word InstrumentNum);
extern "C" far byte CP_GetNumOfSamples(word InstrumentNum);
extern "C" far char *CP_GetSampleName(word InstrumentNum,word SampleNum);
extern "C" far dword CP_GetSampleSize(word InstrumentNum,word SampleNum);
extern "C" far word CP_GetSampleC4Spd(word InstrumentNum,word SampleNum);
extern "C" far byte CP_GetSampleVolume(word InstrumentNum,word SampleNum);
extern "C" far byte CP_GetSamplePanning(word InstrumentNum,word SampleNum);
extern "C" far byte CP_GetSampleLoopType(word InstrumentNum,word SampleNum);
extern "C" far dword CP_GetSampleLoopBegin(word InstrumentNum,word SampleNum);
extern "C" far dword CP_GetSampleLength(word InstrumentNum,word SampleNum);
extern "C" far byte CP_GetSample16Bit(word InstrumentNum,word SampleNum);
extern "C" far byte CP_GetSampleMute(word InstrumentNum,word SampleNum);

