PROGRAM CodexBump;

{$G+}
{$N+}

(*
 by yzi/fit 6.11.1996 kello 18.15 - 19.30

 Codex-bump compoon

 Tein kki jonkun bumpin ett saan selville MaGiCnUmBeRiN.
 Tll matematiikan laitoksen mikroluokassa oli vain
 Turbo Pascal 7.0, joten ei mitn 100% TASM-hommia tnn.

 Thn meni tasan 1 tunti ja 15 minuuttia kun sen
 tyhjst aloitin.

 Jos spredaat niin laita tm hijeno sorsa mukaan.
 Eiks oo kauniin nkist Pascalia? Koodi on
 valmistettu TY:n TKO:n suositusten mukaisesti.

 En tied, milt nytt nopeassa koneessa...
 kun t on 486/66 ja ISA-gagganytnohjain.

*)

  USES Crt;

  TYPE Plokki = ARRAY[0..65534] OF Byte;
       PlokkiPtr = ^Plokki;

  CONST screen_width = 320;

  VAR bumpmappi, temp : ^Plokki;
      sqrtable : ARRAY [0..1023] OF Word;

  PROCEDURE SetMode (mode : Word);
    ASSEMBLER;
    ASM
        MOV     AX, mode
        INT     $10
    END; (* SetMode *)

  PROCEDURE ZeroBorders (VAR dest);
    VAR i : Integer;
        p : ^Plokki;
    BEGIN
      p := Addr(dest);
      FillChar (p^[0], 320, 0);
      FillChar (p^[199*320], 320, 0);
      FOR i := 1 TO 198 DO
        BEGIN
          p^[i*320] := 0;
          p^[i*320+319] := 0;
        END;
    END; (* ZeroBorders *)

  PROCEDURE Smooth (VAR source, dest);
    VAR i : Word;
        s, d : ^Plokki;
    BEGIN
      s := Addr(source);
      d := Addr(dest);
      FOR i := 321 TO (63679) DO
        d^[i] := (s^[i-320]+s^[i-1]+s^[i+1]+s^[i+320]) SHR 2;
    END; (* Smooth *)

  PROCEDURE DrawBigDot (VAR dest);
    VAR i, i2 : Word;
        p : ^Plokki;
    BEGIN
      p := Addr(dest);
      FOR i := 0 TO 7 DO
        FOR i2 := 0 TO 7 DO
          p^[i2 + i*screen_width] := 80;
    END; (* DrawBigDot *)

  PROCEDURE DrawBigChar (c : Char; VAR dest);
    VAR i, i2 : Word;
        p : ^Plokki;
    BEGIN
      p := Addr(dest);
      FOR i := 0 TO 7 DO
        FOR i2 := 0 TO 7 DO
          IF Mem[$F000:$FA6E+Ord(c)*8+i] AND (128 SHR i2) = (128 SHR i2) THEN
            DrawBigDot (p^[i*8*screen_width+i2*8]);
    END; (* DrawChar *)

  PROCEDURE DrawBigString (s : String; VAR dest);
    VAR i : Word;
        p : ^Plokki;
    BEGIN
      IF Length(s) = 0 THEN Exit;
      p := Addr(dest);
      FOR i := 1 TO Length(s) DO
        DrawBigChar (s[i], p^[(i-1)*64]);
    END; (* DrawBigString *)

  PROCEDURE Env;
    ASSEMBLER;
    ASM
        DB      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        DB      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        DB      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        DB      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        DB      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        DB      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        DB      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        DB      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        DB      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        DB      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        DB      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        DB      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        DB      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        DB      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        DB      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        DB      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    END;

  PROCEDURE MakeEnv (VAR dest; x, y : Integer);
    VAR i, i2 : Integer;
        p : ^Plokki;
    BEGIN
      p := Addr(Env);
      FOR i := 0 TO 15 DO
        FOR i2 := 0 TO 15 DO
          p^[((i+8)MOD 16)*16+(i2+8)MOD 16] :=
            63-sqrtable[(i-y)*(i-y)+(i2-x)*(i2-x)]*3;
    END; (* MakeEnv *)

  PROCEDURE DumpBump (VAR source, dest; size : Word);
    ASSEMBLER;
    ASM
        PUSH    DS
        PUSH    BP
        LDS     SI, source
        LES     DI, dest
        CLD
        MOV     CX, size
        XOR     AX, AX
@@Lupi:
        MOV     AL, DS:[SI+1]
        SUB     AL, DS:[SI-1]
        MOV     DL, DS:[SI+320]
        SUB     DL, DS:[SI-320]
        SAR     DL, 2
        SHL     DL, 4
        SAR     AL, 2
        ADD     AL, DL
        MOV     BP, AX
        MOV     AL, BYTE PTR CS:Env[BP]
        STOSB
        INC     SI
        LOOP    @@Lupi
        POP     BP
        POP     DS
    END; (* DumpBump *)

  PROCEDURE SetC (c, r, g, b : Byte);
    BEGIN
      Port[$3C8] := c;
      Port[$3C9] := r;
      Port[$3C9] := g;
      Port[$3C9] := b;
    END; (* SetC *)

  VAR i : Integer;
      a : Real;

BEGIN
  GetMem (bumpmappi, 65534);
  GetMem (temp, 65534);
  FillChar (bumpmappi^, 65534, 0);
  SetMode ($13);
  DrawBigString ('CODEX', bumpmappi^[5*320]);
  DrawBigString ('COMPO', bumpmappi^[69*320]);
  DrawBigString ('eLiTe', bumpmappi^[133*320]);
  ZeroBorders (bumpmappi^);
  FOR i := 0 TO 1023 DO sqrtable[i] := Round(Sqrt(i));
  FOR i := 0 TO 255 DO SetC (i, i, i DIV 2, Round(Sin(i/10)*31+31));
  FOR i := 1 TO 10 DO
    BEGIN
      Move (bumpmappi^, temp^, 64000);
      Smooth (temp^, bumpmappi^);
    END;
  a := 0;
  REPEAT
    MakeEnv (@Env^, Round(Cos(a)*5+8), Round(Sin(a)*5+8));
    DumpBump (bumpmappi^, Mem[$A000:0000], 64000);
    a := a + 0.175;
  UNTIL KeyPressed;
  SetMode (3);
  WriteLn ('Ei oo kauheen pini. :)');
END.
