/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.usbdm.connections.usbdm;

public class CFVxDeviceData {
    static String[] connectionSpeeds = new String[]{ClockSpeed.F_250KHZ.name, ClockSpeed.F_500KHZ.name, ClockSpeed.F_750KHZ.name, ClockSpeed.F_1MHZ.name, ClockSpeed.F_1_5MHZ.name, ClockSpeed.F_2MHZ.name, ClockSpeed.F_3MHZ.name, ClockSpeed.F_4MHZ.name, ClockSpeed.F_6MHZ.name, ClockSpeed.F_12MHZ.name};
    static CFVxDeviceData defaultDevice = new CFVxDeviceData();

    public static String[] getConnectionSpeeds() {
        return connectionSpeeds;
    }

    public String toString() {
        return "CFVx Device Data";
    }

    static ClockSpeed getClockSpeed(String speed) {
        ClockSpeed[] clockSpeedArray = ClockSpeed.values();
        int n = clockSpeedArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClockSpeed s = clockSpeedArray[n2];
            if (speed.equalsIgnoreCase(s.name)) {
                return s;
            }
            ++n2;
        }
        return ClockSpeed.F_1MHZ;
    }

    static enum ClockSpeed {
        F_250KHZ("250kHz", 250000),
        F_500KHZ("500kHz", 500000),
        F_750KHZ("750kHz", 750000),
        F_1MHZ("1MHz", 1000000),
        F_1_5MHZ("1.5MHz", 1500000),
        F_2MHZ("2MHz", 2000000),
        F_3MHZ("3MHz", 3000000),
        F_4MHZ("4MHz", 4000000),
        F_6MHZ("6MHz", 6000000),
        F_12MHZ("12MHz", 12000000);

        final String name;
        final int frequency;

        private ClockSpeed(String name, int frequency) {
            this.name = name;
            this.frequency = frequency;
        }

        public String toString() {
            return this.name;
        }
    }
}

