/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketInputStream;
import java.net.SocketOutputStream;
import java.net.UnknownHostException;

class PlainSocketImpl
extends SocketImpl {
    int timeout;
    private static final int SOCKS_PROTO_VERS = 4;
    private static final int SOCKS_REPLY_VERS = 4;
    private static final int COMMAND_CONNECT = 1;
    private static final int COMMAND_BIND = 2;
    private static final int REQUEST_GRANTED = 90;
    private static final int REQUEST_REJECTED = 91;
    private static final int REQUEST_REJECTED_NO_IDENTD = 92;
    private static final int REQUEST_REJECTED_DIFF_IDENTS = 93;
    public static final String socksServerProp = "socksProxyHost";
    public static final String socksPortProp = "socksProxyPort";
    public static final String socksDefaultPortStr = "1080";

    protected synchronized void create(boolean bl) throws IOException {
        this.fd = new FileDescriptor();
        this.socketCreate(bl);
    }

    protected void connect(String string, int n) throws UnknownHostException, IOException {
        IOException iOException = null;
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            try {
                this.connectToAddress(inetAddress, n);
                return;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        catch (UnknownHostException unknownHostException) {
            iOException = unknownHostException;
        }
        this.close();
        throw iOException;
    }

    protected void connect(InetAddress inetAddress, int n) throws IOException {
        this.port = n;
        this.address = inetAddress;
        try {
            this.connectToAddress(inetAddress, n);
            return;
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    private void connectToAddress(InetAddress inetAddress, int n) throws IOException {
        if (this.usingSocks()) {
            this.doSOCKSConnect(inetAddress, n);
            return;
        }
        this.doConnect(inetAddress, n);
    }

    public void setOption(int n, Object object) throws SocketException {
        boolean bl = true;
        switch (n) {
            case 128: {
                if (object == null || !(object instanceof Integer) && !(object instanceof Boolean)) {
                    throw new SocketException("Bad parameter for option");
                }
                if (!(object instanceof Boolean)) break;
                bl = false;
                break;
            }
            case 4102: {
                if (object == null || !(object instanceof Integer)) {
                    throw new SocketException("Bad parameter for SO_TIMEOUT");
                }
                int n2 = (Integer)object;
                if (n2 < 0) {
                    throw new IllegalArgumentException("timeout < 0");
                }
                this.timeout = n2;
                return;
            }
            case 15: {
                throw new SocketException("Cannot re-bind socket");
            }
            case 1: {
                if (object == null || !(object instanceof Boolean)) {
                    throw new SocketException("bad parameter for TCP_NODELAY");
                }
                bl = (Boolean)object;
                break;
            }
            default: {
                throw new SocketException("unrecognized TCP option: " + n);
            }
        }
        this.socketSetOption(n, bl, object);
    }

    public Object getOption(int n) throws SocketException {
        if (n == 4102) {
            return new Integer(this.timeout);
        }
        int n2 = this.socketGetOption(n);
        switch (n) {
            case 1: {
                if (n2 == -1) {
                    return new Boolean(false);
                }
                return new Boolean(true);
            }
            case 128: {
                if (n2 == -1) {
                    return new Boolean(false);
                }
                return new Integer(n2);
            }
            case 15: {
                InetAddress inetAddress = new InetAddress();
                inetAddress.address = n2;
                return inetAddress;
            }
        }
        return null;
    }

    private void doSOCKSConnect(InetAddress inetAddress, int n) throws IOException {
        this.connectToSocksServer();
        this.sendSOCKSCommandPacket(1, inetAddress, n);
        int n2 = this.getSOCKSReply();
        switch (n2) {
            case 90: {
                return;
            }
            case 91: 
            case 92: {
                throw new SocketException("SOCKS server cannot conect to identd");
            }
            case 93: {
                throw new SocketException("User name does not match identd name");
            }
        }
    }

    private int getSOCKSReply() throws IOException {
        byte[] byArray;
        InputStream inputStream = this.getInputStream();
        int n = inputStream.read(byArray = new byte[8]);
        if (n != byArray.length) {
            throw new SocketException("Malformed reply from SOCKS server");
        }
        if (byArray[0] != 0) {
            throw new SocketException("Malformed reply from SOCKS server");
        }
        return byArray[1];
    }

    private void connectToSocksServer() throws IOException {
        int n;
        String string = System.getProperty(socksServerProp);
        if (string == null) {
            return;
        }
        InetAddress inetAddress = InetAddress.getByName(string);
        String string2 = System.getProperty(socksPortProp, socksDefaultPortStr);
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            throw new SocketException("Bad port number format");
        }
        this.doConnect(inetAddress, n);
    }

    private void doConnect(InetAddress inetAddress, int n) throws IOException {
        ProtocolException protocolException = null;
        int n2 = 0;
        while (n2 < 3) {
            try {
                this.socketConnect(inetAddress, n);
                return;
            }
            catch (ProtocolException protocolException2) {
                this.close();
                this.fd = new FileDescriptor();
                this.socketCreate(true);
                protocolException = protocolException2;
            }
            catch (IOException iOException) {
                this.close();
                throw iOException;
            }
            ++n2;
        }
        this.close();
        throw protocolException;
    }

    private void sendSOCKSCommandPacket(int n, InetAddress inetAddress, int n2) throws IOException {
        byte[] byArray = this.makeCommandPacket(n, inetAddress, n2);
        OutputStream outputStream = this.getOutputStream();
        outputStream.write(byArray);
    }

    private byte[] makeCommandPacket(int n, InetAddress inetAddress, int n2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(9);
        byteArrayOutputStream.write(4);
        byteArrayOutputStream.write(n);
        byteArrayOutputStream.write(n2 >> 8 & 0xFF);
        byteArrayOutputStream.write(n2 & 0xFF);
        byte[] byArray = inetAddress.getAddress();
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        String string = System.getProperty("user.name");
        byte[] byArray2 = new byte[string.length()];
        string.getBytes(0, string.length(), byArray2, 0);
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        byteArrayOutputStream.write(0);
        return byteArrayOutputStream.toByteArray();
    }

    private boolean usingSocks() {
        return System.getProperty(socksServerProp) != null;
    }

    protected synchronized void bind(InetAddress inetAddress, int n) throws IOException {
        this.socketBind(inetAddress, n);
    }

    protected synchronized void listen(int n) throws IOException {
        this.socketListen(n);
    }

    protected synchronized void accept(SocketImpl socketImpl) throws IOException {
        this.socketAccept(socketImpl);
    }

    protected synchronized InputStream getInputStream() throws IOException {
        return new SocketInputStream(this);
    }

    protected synchronized OutputStream getOutputStream() throws IOException {
        return new SocketOutputStream(this);
    }

    protected synchronized int available() throws IOException {
        return this.socketAvailable();
    }

    protected void close() throws IOException {
        if (this.fd != null) {
            this.socketClose();
            this.fd = null;
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    private native void socketCreate(boolean var1) throws IOException;

    private native void socketConnect(InetAddress var1, int var2) throws IOException;

    private native void socketBind(InetAddress var1, int var2) throws IOException;

    private native void socketListen(int var1) throws IOException;

    private native void socketAccept(SocketImpl var1) throws IOException;

    private native int socketAvailable() throws IOException;

    private native void socketClose() throws IOException;

    private static native void initProto();

    private native void socketSetOption(int var1, boolean var2, Object var3) throws SocketException;

    private native int socketGetOption(int var1) throws SocketException;

    PlainSocketImpl() {
    }

    static {
        System.loadLibrary("net");
        PlainSocketImpl.initProto();
    }
}

