PROGRAM TestGMod;

USES
  CRT,
  LoadMod,   { Needed to load the MOD }
  TPGUSMOD;  { Needed to play the MOD }

VAR
  MyMOD  : MODFile;
  InF    : FILE;
  CH     : char;
  CurVol : BYTE;
  Result : BOOLEAN;

BEGIN
  IF ParamCount <> 1 THEN
    BEGIN
      Writeln;
      Writeln('Need a file name.');
      Halt(1);
    END;
  Assign(InF, ParamStr(1));
  Reset(InF,1);
  Result := LoadModFile(InF,MyMOD,FileSize(InF));
  Close(InF);
  IF Result AND InitMODPlay(TRUE, MyMOD) THEN
    BEGIN
      Writeln('Loaded OK.  Press any key to play');
      CH := readkey;
      SetMODVolume(5);
      CurVol := 5;
      StartMOD;
      Writeln;
      Writeln('Playing.  Press <+>/<-> to change volume, <ESC> to stop.');
      CH := ' ';
      REPEAT
        GotoXY(1,WhereY);
        Write('Pattern: ',MODPattern:2,'   Line: ',MODLine:2);
        IF KeyPressed THEN
          BEGIN
            CH := Readkey;
            CASE CH OF
              '+': IF CurVol < 10 THEN
                     BEGIN
                       INC(CurVol);
                       SetMODVolume(CurVol);
                     END;
              '-': IF CurVol > 0 THEN
                     BEGIN
                       DEC(CurVol);
                       SetMODVolume(CurVol);
                     END;
             END;
          END;
      UNTIL CH=#27;
      StopMOD;
      ShutMODPlay;
      DumpMODFile(MyMOD);
    END
  ELSE
    Writeln('Could not load the MOD file specified correctly.');
END.
