/***************************************************************************
*	NAME:  OPEN16.C
**	COPYRIGHT:
**	"Copyright (c) 1994, by FORTE
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
*  CREATION DATE: 01/01/94
*--------------------------------------------------------------------------*
*     VERSION	DATE	   NAME		DESCRIPTION
*>	1.0	01/01/94		Original
***************************************************************************/
#include <dos.h>
#include <conio.h>

#include "forte.h"
#include "proto16.h"
#include "gf1proto.h"
#include "codec.h" 
#include "gf1os.h" 
#include "gf1hware.h"
#include "codecos.h" 
#include "extern16.h" 
#include "ultraerr.h" 
#include "dma.h"	/* Hardware defs for PC's dma controllers */

extern DMA_ENTRY _gf1_dma[]; /* Structure that holds data on PC's dma chan */
extern ULTRA16_DATA _codec_data; 
extern IMAGE16 _image_codec;
extern ULTRA_DATA _gf1_data;
extern void UltraMaxHandler();

int Ultra16Open(gus_base,config) 
int gus_base;
ULTRA16_CFG *config; 
{ 
int temp; 


_codec_data.base_port = config->base_port; 

temp = Ultra16Probe(gus_base,config); 
if (temp == NO_ULTRA) 
	{
	return(temp);
	}

ENTER_CRITICAL;

_codec_data.play_chan = config->play_dma; 
_codec_data.rec_chan = config->rec_dma; 
_codec_data.irq_num = config->irq_num; 
_codec_data.type = config->type;

Ultra16Xparent();

if (config->type == 1)		/* UltraMax, shares irqs with GF1 ... */
	{
	UltraAuxHandler(UltraMaxHandler);
	Ultra16EnableIrqs();
	}
else
	{
	Set16IrqHandlers(_codec_data.irq_num);
	Set16Irqs(_codec_data.irq_num);
	}

/* Output level = 2.8V Force DAC to zero on overrun ... */
outp(_codec_data.addr,ALT_FEATURE_1);
outp(_codec_data.data,_image_codec.afei);

/* Should I turn on the high pass filter ??? */
outp(_codec_data.addr,ALT_FEATURE_2);
outp(_codec_data.data,_image_codec.afeii);

Ultra16SetFreq(8000U);
Ultra16RecFormat(FALSE,FALSE,0);
Ultra16PlayFormat(FALSE,FALSE,0);

LEAVE_CRITICAL;

return(ULTRA_OK);
}

int
Ultra16Close()
{
ENTER_CRITICAL;

/* Gotta clear out MAX DMA latches ... */
if (_codec_data.type == 1)
	{
	outp(_gf1_data.base_port+0x106,_codec_data.setup & ~0x10);
	outp(_gf1_data.base_port+0x106,_codec_data.setup);
	if (_codec_data.rec_chan < 4)
		outp(_gf1_data.base_port+0x106,_codec_data.setup & ~0x10);

	outp(_gf1_data.base_port+0x106,_codec_data.setup & ~0x20);
	outp(_gf1_data.base_port+0x106,_codec_data.setup);
	if (_codec_data.play_chan < 4)
		outp(_gf1_data.base_port+0x106,_codec_data.setup & ~0x20);
	}

Ultra16DisableIrqs();
Ultra16StopRecordDma();
Ultra16StopPlayDma();
Ultra16StopTimer();

/* clear any pending IRQs */
(void)inp(_codec_data.status);
outp(_codec_data.status,0);

if (_codec_data.type != 1)
	{
	Reset16Irqs(_codec_data.irq_num);
	ReSet16IrqHandlers(_codec_data.irq_num);
	}

LEAVE_CRITICAL;

return(ULTRA_OK);
}


