/***************************************************************************
*	NAME:  CONFIG.C
**	COPYRIGHT:
**	"Copyright (c) 1992, by FORTE
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
*  CREATION DATE: 11/18/92
*--------------------------------------------------------------------------*
*     VERSION	DATE	   NAME		DESCRIPTION
*>	1.0	11/18/92		Original
***************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>

#include "forte.h"
#include "extern.h"

#include "gf1proto.h"

/***************************************************************
 * This function will parse the configuration variable "ULTRASND"
 * to find the settings for the configuration of the board.
 * It returns FALSE if the environment variable couldn't be found.
 ***************************************************************/

int
UltraGetCfg(config)
ULTRA_CFG *config;
{
char *ptr;

config->base_port = 0x220;
config->dram_dma_chan = 1;
config->adc_dma_chan = 1;
config->gf1_irq_num = 11;
config->midi_irq_num = 5;

ptr = getenv("ULTRASND");
if (ptr == NULL)
	{
	return(FALSE);
	}
else
	{
	(void)sscanf(ptr,"%x,%d,%d,%d,%d",&config->base_port,
								&config->dram_dma_chan,
								&config->adc_dma_chan,
								&config->gf1_irq_num,
								&config->midi_irq_num);
	}
return(TRUE);
}


