public _is486

assume  cs:_TEXT

_TEXT   segment byte public 'CODE'

;**************************************************************************	
;       Function:	is486 ()
;
;       Purpose:        Check for presence of a 486 level support.
;
;       Returns:        1 if 486 or better present.
;                       0 if earlier than a 486 is present.
;                       
;**************************************************************************

_is486  proc near

        .486
	pushfd			; save EFLAGS

	pop	eax		; get EFLAGS
	mov	ecx, eax	; temp storage EFLAGS
	xor	eax, 40000h	; change AC bit in EFLAGS

	push	eax		; put new EFLAGS value on stack
	popfd			; replace current EFLAGS value

	pushfd			; get EFLAGS
	pop	eax		; save new EFLAGS in EAX
	cmp	eax, ecx	; compare temp and new EFLAGS

        jz      is_not_80486
	mov	ax, 1	        ; 80486 present 
        jmp     done

is_not_80486:        
        mov     ax, 0           ; 80486 not present

done:
	push	ecx             ; get original EFLAGS
	popfd			; restore EFLAGS 
        ret


_is486  endp
_TEXT   ends

end

