	public	_iscyrixfpu

        assume	cs:_TEXT

_TEXT	segment byte public 'CODE'
;**************************************************************************	
;       Function:       int iscyrixfpu()	
;       Technique:
;               On both the Cyrix and Intel math coprocessor the function
;               2^x-1 is undefined when its argument does not lie between
;               -1 and +1. Therefore, when this function is evaluated at
;               x=pi it is not surprising that the answers returned by the
;               Cyrix and Intel chips are distinct.  This program computes
;               2^PI-1 and stores the result as a single precision number
;               VALUE.  It is possible to distinguish between the Cyrix and
;               Intel math coprocessors by comparing VALUE with the known
;               value obtained when using a Cyrix or Intel math coprocessor.
;
;       Purpose:        Determine if Cyrix FPU is present
;       Inputs:         None
;       Output:         AX=1 if Cyrix FPU Present else AX=0
;**************************************************************************

_iscyrixfpu	proc	near
	push	bp
	mov	bp,sp
	sub	sp,4                    ; get stack space
	push	si                      ; use as temp
	push	di                      ; use as temp

	finit	                        ; inialize fpu
	fldpi	                        ; fpu loads pi           
	f2xm1	                        ; square pi           
	fstp	dword ptr [bp-4]        ; get pi squared

	lea	ax, word ptr [bp-2]     ; get address of pi squared value
	mov	si, ax
	cmp	word ptr [si], 3FC9h    ; compare pi squared to Cyrix
	jne	short not_cyrix
	mov	di, 1                   ; True Cyrix FPU present
	jmp	short done

not_cyrix:
	mov	di, 0                   ; FALSE Cyrix FPU not present

done:
	mov	ax, di                  ; return findings
	pop	di
	pop	si
	mov	sp,bp
	pop	bp
	ret	
_iscyrixfpu	endp
_TEXT	ends
	end
