assume  cs:_TEXT

public	_is_cpuid_supported
public	_get_cpuid_info

_TEXT	segment byte public 'CODE'

;**************************************************************************	
;       Function:	int is_cpuid_supported ()
;
;       Purpose:        Check for existence of CPUID instruction.
;                       If exists execute CPUID with eax==0.
;
;       Inputs:         none
;                       
;       Output:         
;                       
;       Returns:        0 - no CPUID instruction supported
;                       1 - CPUID instruction supported
;**************************************************************************

cpuid macro 
        db 0fh, 0a2h
endm

_is_cpuid_supported        proc	near
.386
	push	bp
	mov	bp, sp
        sub     sp, 40

        push    eax
        push    ebx

        pushfd                  ; get extended flags
        pop     eax
        mov     ebx, eax        ; save current flags

        xor     eax, 200000h    ; toggle bit 21
        push    eax             ; put new flags on stack
        popfd                   ; flags updated now in flags

        pushfd                  ; get extended flags
        pop     eax             
        xor     eax, ebx        ; if bit 21 r/w then eax <> 0

        pop     ebx
        pop     eax

        je      no_cpuid        ; can't toggle id bit (21) no cpuid here

        mov     ax, 1           ; cpuid supported

        jmp     done_cpuid_sup

no_cpuid:
        mov     ax, 0           ; cpuid not supported

done_cpuid_sup:
        mov     sp, bp
        pop     bp
	ret
_is_cpuid_supported        endp

;**************************************************************************	
;       Function:	int cpuid_supported (long level,
;                                            long &reg_eax,
;                                            long &reg_ebx,
;                                            long &reg_ecx,
;                                            long &reg_edx)
;
;       Purpose:        Execute CPUID instruction at level (eax==level)
;
;       Inputs:         level - eax value when CPU is executed
;                       
;       Output:         reg_eax - eax after executing CPUID 
;                       reg_ebx - ebx after executing CPUID 
;                       reg_ecx - ecx after executing CPUID 
;                       reg_edx - edx after executing CPUID 
;**************************************************************************
_get_cpuid_info        proc	near
.386
	push	bp
	mov	bp, sp
        sub     sp, 4

        push    esi

	mov	eax, dword ptr [bp+4]      ; get level

        cpuid                   

        mov     esi, ebx        ; save ebx value 

	mov	bx,word ptr [bp+8]
	mov	dword ptr [bx],eax        ; reg_eax := eax

	mov	bx,word ptr [bp+10]
	mov	dword ptr [bx],esi        ; reg_ebx := ebx (via esi)

        mov	bx,word ptr [bp+12]
	mov	dword ptr [bx],ecx        ; reg_ecx := ecx

        mov	bx,word ptr [bp+14]       ; reg_edx := edx 
	mov	dword ptr [bx],edx

        pop     esi

        mov     sp,bp
        pop     bp
	ret
_get_cpuid_info        endp



_TEXT	ends
	end
