


/*************************************/
/*				     */
/*			*/
/*				     */
/*************************************/

/*
  Western Digital Corp. Format Routine

		Author: Dave Evans
Edited by Tom Devlin

		Creation Date:	08/08/86
		Revision Date:	4/23/90
		Revision: 2.50

	Formats drive based on #cylinders, #heads, #sectors, and
	interleave entered at command line or on screen.  Does low-level format
	followed by a Read-verify of the entire drive.	Shows errors
	detected, then allows user to enter additional blocks to
	format with bad block marks.  The program may be aborted
	with an Escape at both the Format prompt and at the Format
	Bad Block prompt.

	Rev. 1.01   dle
	Added ability to format drive D:, and also the ability to
	specify the precomp cylinder.
	New command line format:
		WDFMT drive #cyls #heads #sectors interleave precomp-cyl

	Rev.2.00    thd
	Added ability to format up to 16 heads.
	fix to enable format of drive 1.
	New drive spec enrty by screen:

	Rev.2.10    thd
	Added Surface test, Skew, Alt sector, and made the program menu
	driven. Surface test does just that. Skew is the diferance in
	sector numbers on adjacent heads. Alt sector when enabled will
	format an extra sector to be used in the verify if a bad sector
	is found. The user can enter drive parameters on the DOS command
	line or in the program.
		 New command line format:
	 WDFMT drive #cyls #heads #sectors interleave precomp-cyl skew

	rev 2.20
	fix surface analisis and make defect entry beter
	rev 2.30 ?
	rev 2.40
	fix more than one sector bad on a track.
	fix alternate hang on 6v.
	rev 2.5
	fix reset bits

*/

#include <dos.h>
#include <stdio.h>
#include <ctype.h>
#include <scancode.h>
#include <color.h>
#include <malloc.h>
#include "structs.h"
#include "defs.h"

/*  Global variables:

		Command parser modifies the tables, and global flags
		indicate to the Main routine the requested action.

*/

struct type_htable hd_table;
struct type_task_file task_file;
struct type_error err_table[300];
struct type_error defect_table[300];

union  REGS inregs, outregs;
union  type_scan scan_code;

char far  *wr_buffer;
char far  *fmt_buffer[16];
int bad_sector_map[100];

int command, err_count, defect_count, errcnt, bad_count, redirection, head;
unsigned char alt_value =00;	   /* this is the sector # of the alt sector */


int int_flag =0;
int int_enable = 0;		      /* interrupt 14 flags */
int i;
/******************************************/
/******************************************/
/******************************************/
/******************************************/



main(argc, argv)

int argc;
char *argv[];

{
   for(i = 0;i<= 15; i++)
   {
      if((fmt_buffer[i] = malloc(buf_length)) == NULL)
      { 				    /* if out of memory */
	 cls();
	 printf(" out of memory !!!!");
	 while(TRUE);
      }
   }

      if((wr_buffer = malloc(buf_length)) == NULL)
      {
	 cls();
	 printf(" out of memory !!!!");
	 while(TRUE);
      }
/*************************************/
/*				     */
/*  start of main body		     */
/*				     */
/*************************************/

	hd_table.sec_number = 1;	      /*initialize hd_table to defalt*/
	hd_table.blk_size   = 1;
	hd_table.max_cyl    = 615;
	hd_table.max_head   = 4;
	hd_table.max_sec    = 17;
	hd_table.precomp    = 306;
	hd_table.retry	    = 0;
	hd_table.step	    = 0;
	hd_table.ileave     = 3;
	hd_table.drv_number = 0;
	hd_table.skew	    = 0;
	hd_table.alt_sector = 0;
	hd_table.ecc	    = 1;	    /* set for ecc in SDH reg */
	hd_table.sec_size   = 0x01;	    /* 01 for 512 bytes/sector */

   redirection = FALSE; 		    /* set redirection of input to false */
   get_spec(argc, argv);		    /* get specs from dos command line */
   screen_update();			    /* out put screen */
   get_2spec(); 			    /* get drive specs from screen */
   hd_table.max_cyl--;			    /* adjust table values */
   hd_table.max_head--;
   hd_table.precomp = (int)((hd_table.precomp + 3)/4); /* ajust precomp */
   for(head=0; head<=hd_table.max_head; head++)
      do_ilt(0,head);/* set up interleave for good blocks */

   command =0;
   while(TRUE)
   {					    /* start of main while loop */
      display_menue();			    /* put menue up on screen */
      command = get_command();		    /* get command on what to do */
      do_command(command);		    /* do that command */
   }					    /* end of main while loop */

}					    /* end of main body */
/*************************************/
/*				     */
/*	eend of main body	     */
/*				     */
/*************************************/


/*************************************/
/*				     */
/*	display_menue() 	     */
/*				     */
/*  put menue on screen 	     */
/*				     */
/*************************************/

display_menue()

{					    /* start of display_menue */
   upscroll(11,13,24,0,79,VNORMAL);	     /* clear portion of screen */
   print_atrb(13,20+h_shift," ENTER MENU CHOICE",VNORMAL);
   print_atrb(15,20,"F",INVERSE);             /* print high light "F" */
   print_atrb(15,21,"ormat disk  CAUTION this will destroy all data on drive !",VNORMAL);     /* print rest of format */
   print_atrb(17,20,"V",INVERSE);             /* print high light "V" */
   print_atrb(17,21,"erify disk",VNORMAL);     /* print rest of Verify */
   print_atrb(19,20,"B",INVERSE);             /* print high light "V" */
   print_atrb(19,21,"ad sector entry",VNORMAL);/* print rest of Verify */
   print_atrb(21,20,"S",INVERSE);             /* print high light "S" */
   print_atrb(21,21,"urface test  CAUTION this will destroy all data on drive !",VNORMAL);    /* print rest of Surface test */
   print_atrb(23,20,"Q",INVERSE);             /* print high light "Q" */
   print_atrb(23,21,"uit",VNORMAL);            /* print rest of Quit */


}					    /* end of display menue */

/*************************************/
/*				     */
/*  get_command()		     */
/*				     */
/*  output :  command value	     */
/*				     */
/*************************************/

int   get_command()

{					    /* start of get_command() */
   int done,old_command;
   char prompt_row;
   unsigned char temp_ch;

   done = FALSE;
   prompt_row = 15;
   old_command = command;
   curs(prompt_row+(2*command),18);ARROW;   /* print arrow */
   curs(prompt_row+(2*command),20);
   while(!done)
   {					    /* start of while */
      temp_ch = get_input(redirection);     /* get input */
      temp_ch = toupper(temp_ch);
      switch(temp_ch)
      { 				    /* start of switch */
	 case 'F'    : old_command = command;
		       command = 0;	    /* format */
		       break;
	 case 'V'    : old_command = command;
		       command = 1;	    /* verify */
		       break;
	 case 'B'    : old_command = command;
		       command = 2;	    /* bad track */
		       break;
	 case 'S'    : old_command = command;
		       command = 3;	    /* surface */
		       break;
	 case 'Q'    : old_command = command;
		       command = 4;	    /* quit */
		       break;
	 case CURUP  : old_command = command;
		       if(command EQL 0) command = 4;	/* up arrow */
		       else --command;
		       break;
	 case CURDN  : old_command = command;
		       if(command EQL 4) command = 0;	 /* down arrow */
		       else ++command;
		       break;
	 case CRG_RTN: done = TRUE;	    /* a <CR> was hit */
		       break;
	 default     : BELL;
      } 				    /* end of switch */
      curs(prompt_row+(2*old_command),18);BLANK_SP;
      curs(prompt_row+(2*command),18);ARROW;	/* print arrow */
      curs(prompt_row+(2*command),20);
   }					    /* end of while */
   return command;			    /* return command */

}					    /* end of get_command() */

/*************************************/
/*				     */
/*  do_command(command) 	     */
/*				     */
/*  input : command		     */
/*				     */
/*  do the command defined by command*/
/*				     */

/*************************************/

do_command(command)

int command;

{					    /* start of do_command */
   switch(command)
   {					    /* start of switch */
      case 0 : do_format();break;	    /* format disk */
      case 1 : do_verify();break;	    /* verify disk */
      case 2 : do_bad_track();break;	    /* get bad track info */
      case 3 : do_surface();break;	    /* do surface test */
      case 4 : cls();			    /* exit program */
	       curs(0,0);printf(" exit WDFMT \n");
	       exit(0);
   }					    /* end of switch */

}					    /* end of do_command */


/********************************************/
/*					    */
/* do_format()				    */
/*					    */
/********************************************/

do_format()

{					    /* start of format */
   char temp;

   upscroll(11,13,24,0,79,VNORMAL);	    /* clear portion of screen */
   curs(13, 20+h_shift);printf(" FORMATTING DISK ");
   curs(20, 12+h_shift);printf("Formatting cylinder: ");
   curs(20, 40+h_shift);printf("head:");
   for(head=0; head<=hd_table.max_head; head++)
      do_ilt(0,head);			/* set up interleave for good blocks */
   init_disk(); 			    /* initialize drive */
   format_all();			    /* do that format */



     curs(16,20+h_shift);printf("Format complete.....");

   if (bad_count > 300) 		    /* more than 300 errors */
   {
     curs(16,20+h_shift);printf("Found more than 300 errors !!!");
   }
   if ((1 < bad_count) AND (bad_count < 300)) /* less than 300 errors */
   {
     curs(16,20+h_shift);printf("Found  %d  errors !",bad_count-1);
   }
   if (1 EQL bad_count) 		    /* no errors found */
   {
     curs(16,20+h_shift);printf("No errors found");
   }
   curs(18,20+h_shift);printf("press any key to continue.");
   temp = get_input(redirection);
}					    /* end of do_format */

/********************************************/
/*					    */
/* do_verify()				    */
/*					    */
/********************************************/

do_verify()

{					    /* start of verify */
   char temp;

   upscroll(11,13,24,0,79,VNORMAL);	    /* clear portion of screen */
   curs(13, 20+h_shift);printf(" VERIFING DISK ");
   curs(20, 12+h_shift);printf("Verifying  cylinder: ");
   curs(20, 40+h_shift);printf("head:");
   init_disk(); 			    /* initialize drive */
   verify_all();			    /* do that verify */
   if (err_count > 300) 		    /* more than 300 errors */
   {
     curs(16,20+h_shift);printf("Found more than 300 errors !!!");
   }
   if ((0 < err_count) AND (err_count < 300)) /* less than 300 errors */
   {
     curs(16,20+h_shift);printf("Found  %d  errors !",err_count);
   }
   if (0 EQL err_count) 		    /* no errors found */
   {
     curs(16,20+h_shift);printf("No errors found");
   }
   curs(18,20+h_shift);printf("press any key to continue.");
   temp = get_input(redirection);
}					    /* end of verify */


/********************************************/
/*					    */
/* do_bad_track()			    */
/*					    */
/*  get bad track info from user	    */
/*					    */
/********************************************/

do_bad_track()

{					    /* start of bad_track*/
   char temp;

   init_disk(); 			    /* reset, recal, idc */
   should_do_errors();			    /* dispaly and mark bad tracks */
   enter_bad_map();			    /* enter manufact. bad tracks */
   curs(22,20+h_shift);printf("press any key to continue.");
   temp = get_input(redirection);
   screen_update();			    /* redraw screen */
   curs( 4,36+h_shift);printf("%4d",hd_table.drv_number);
   curs( 5,36+h_shift);printf("%4d",hd_table.max_cyl+1 );
   curs( 6,36+h_shift);printf("%4d",hd_table.max_head+1);
   curs( 7,36+h_shift);printf("%4d",hd_table.max_sec   );
   curs( 8,36+h_shift);printf("%4d",hd_table.ileave    );
   curs( 9,36+h_shift);printf("%4d",hd_table.precomp*4 );
   curs(10,36+h_shift);printf("%4d",hd_table.skew      );
   if(hd_table.alt_sector)
   {
      curs(11,36+h_shift);printf("Yes");
   }
   else
   {
      curs(11,36+h_shift);printf("  No ");
   }
 }					     /* end of bad_track */


/********************************************/
/*					    */
/* do_surface() 			    */
/*					    */
/* do a surface test			    */
/*					    */
/********************************************/

do_surface()

{					    /* start of do_surface */
   int i;
   unsigned char temp,pattern[6];
   unsigned char  *p;

   err_count = 0;
   upscroll(11,13,24,0,79,VNORMAL);	    /* clear portion of screen */
   curs(13,20+h_shift);printf(" SURFACE TEST ");
   curs(20, 12+h_shift);printf("Testing    cylinder: ");
   curs(20, 40+h_shift);printf("head:");
   init_disk(); 			    /* initialize drive */
   if(hd_table.max_sec <= 17)
   {					    /* if mfm */
      for(hd_table.cyl_number = 0;
	  hd_table.cyl_number <= hd_table.max_cyl;
	  hd_table.cyl_number++)
      { 				    /* start of for cyl_number */
	 curs(20, 33+h_shift);printf("%4d", hd_table.cyl_number);

	 pattern[0] = 0xAA;		    /* low frequency pattern */
	 pattern[1] = 0xAA;
	 pattern[2] = 0xAA;
	 pattern[3] = 0xAA;
	 pattern[4] = 0xAA;
	 pattern[5] = 0xAA;
	 p = (unsigned char *)wr_buffer;     /* set up wr_buffer */
	 for(i = 0;i < 512;i++)
	    *p++ = pattern[i%6];
	 write_cyl();			    /* write pattern to cylinder */
	 write_cyl();			    /* write pattern to cylinder */
	 write_cyl();			    /* write pattern to cylinder */
	 test_cyl();			    /* verify pattern */

	 pattern[0] = 0x00;		    /* hi frequency pattern */
	 pattern[1] = 0x00;
	 pattern[2] = 0x00;
	 pattern[3] = 0x00;
	 pattern[4] = 0x00;
	 pattern[5] = 0x00;
	 p = (unsigned char *)wr_buffer;     /* set up wr_buffer */
	 for(i = 0;i < 512;i++)
	    *p++ = pattern[i%6];
	 write_cyl();			    /* write pattern to cylinder */
	 test_cyl();			    /* verify pattern */

	 pattern[0] = 0xAA;		    /* low frequency pattern */
	 pattern[1] = 0xAA;
	 pattern[2] = 0xAA;
	 pattern[3] = 0xAA;
	 pattern[4] = 0xAA;
	 pattern[5] = 0xAA;
	 p = (unsigned char *)wr_buffer;     /* set up wr_buffer */
	 for(i = 0;i < 512;i++)
	    *p++ = pattern[i%6];
	 write_cyl();			    /* write pattern to cylinder */
	 write_cyl();			    /* write pattern to cylinder */
	 write_cyl();			    /* write pattern to cylinder */
	 test_cyl();			    /* verify pattern */

	 pattern[0] = 0xDB;		    /* max jitter pattern */
	 pattern[1] = 0x6D;
	 pattern[2] = 0xB6;
	 pattern[3] = 0xDB;
	 pattern[4] = 0x6D;
	 pattern[5] = 0xB6;
	 p = (unsigned char *)wr_buffer;     /* set up wr_buffer */
	 for(i = 0;i < 512;i++)
	    *p++ = pattern[i%6];
	 write_cyl();			    /* write pattern to cylinder */
	 write_cyl();			    /* write pattern to cylinder */
	 write_cyl();			    /* write pattern to cylinder */
	 test_cyl();			    /* verify pattern */
      } 				    /* end of for cyl_number */
   }					    /* end if mfm */

   else
   {					    /* if rll */
      for(hd_table.cyl_number = 0;
	  hd_table.cyl_number <= hd_table.max_cyl;
	  hd_table.cyl_number++)
      { 				    /* start of for cyl_number */
	 curs(20, 33+h_shift);printf("%4d", hd_table.cyl_number);

	 pattern[0] = 0x33;		    /* low frequency pattern */
	 pattern[1] = 0x33;
	 pattern[2] = 0x33;
	 pattern[3] = 0x33;
	 pattern[4] = 0x33;
	 p = (unsigned char *)wr_buffer;     /* set up wr_buffer */
	 for(i = 0;i < 512;i++)
	    *p++ = pattern[i%5];
	 write_cyl();			    /* write pattern to cylinder */
	 write_cyl();			    /* write pattern to cylinder */
	 write_cyl();			    /* write pattern to cylinder */
	 test_cyl();			    /* verify pattern */

	 pattern[0] = 0x00;		    /* hi frequency pattern */
	 pattern[1] = 0x00;
	 pattern[2] = 0x00;
	 pattern[3] = 0x00;
	 pattern[4] = 0x00;
	 p = (unsigned char *)wr_buffer;     /* set up wr_buffer */
	 for(i = 0;i < 512;i++)
	    *p++ = pattern[i%5];
	 write_cyl();			    /* write pattern to cylinder */
	 test_cyl();			    /* verify pattern */

	 pattern[0] = 0x33;		    /* low frequency pattern */
	 pattern[1] = 0x33;
	 pattern[2] = 0x33;
	 pattern[3] = 0x33;
	 pattern[4] = 0x33;
	 pattern[5] = 0x33;
	 p = (unsigned char *)wr_buffer;     /* set up wr_buffer */
	 for(i = 0;i < 512;i++)
	    *p++ = pattern[i%6];
	 write_cyl();			    /* write pattern to cylinder */
	 write_cyl();			    /* write pattern to cylinder */
	 write_cyl();			    /* write pattern to cylinder */
	 test_cyl();			    /* verify pattern */

	 pattern[0] = 0x5A;		    /* max jitter pattern */
	 pattern[1] = 0xB6;
	 pattern[2] = 0xB5;
	 pattern[3] = 0xAB;
	 pattern[4] = 0x6B;
	 p = (unsigned char *)wr_buffer;     /* set up wr_buffer */
	 for(i = 0;i < 512;i++)
	    *p++ = pattern[i%5];
	 write_cyl();			    /* write pattern to cylinder */
	 write_cyl();			    /* write pattern to cylinder */
	 write_cyl();			    /* write pattern to cylinder */
	 test_cyl();			    /* verify pattern */
      } 				    /* end of for cyl_number */
   }					    /* end if rll */

   if (err_count > 300) 		    /* more than 300 errors */
   {
     curs(16,20+h_shift);printf("Found more than 300 errors !!!");
   }
   if ((0 < err_count) AND (err_count < 300)) /* less than 300 errors */
   {
     curs(16,20+h_shift);printf("Found  %d  errors !",err_count);
   }
   if (0 EQL err_count) 		    /* no errors found */
   {
     curs(16,20+h_shift);printf("No errors found");
   }
   curs(18,20+h_shift);printf("press any key to continue.");
   temp = get_input(redirection);

}					    /* end of do_surface */



/********************************************/
/*					    */
/* get drive specs from command line in dos */
/*					    */
/********************************************/

get_spec(argc, argv)

int argc;
char *argv[];


{					    /* start of get_spec */
	argc--;

	if (argc > 0)
	{					   /* get drive # */
		sscanf(*++argv, "%d", &hd_table.drv_number);
		argc--;
	};

	if (argc > 0)
	{					   /* get max cylinder # */
		sscanf(*++argv, "%d", &hd_table.max_cyl);
		argc--;
	};

	if (argc > 0)
	{					   /* get max head #  */
		sscanf(*++argv, "%d", &hd_table.max_head);
		argc--;
	};

	if (argc > 0)
	{					   /* get max sectors/track */
		sscanf(*++argv, "%d", &hd_table.max_sec);
		argc--;
	};

	if (argc > 0)
	{					   /* get interleave value */
		sscanf(*++argv, "%d", &hd_table.ileave);
		argc--;
	};

	if (argc > 0)
	{					   /* get precomp cylinder # */
		sscanf(*++argv, "%d", &hd_table.precomp);
		argc--;
	};

	if (argc > 0)
	{					   /* get skew */
		sscanf(*++argv, "%d", &hd_table.skew);
		argc--;
	};
	if (argc > 0)
	{					   /* get alt sector */
		sscanf(*++argv, "%d", &hd_table.alt_sector);
		argc--;
	};
}					    /* end of get_spec */

/*************************************/
/*				     */
/*    screen update		     */
/*				     */
/*************************************/

screen_update()

{
	cls();
	curs(0,0);
	printf("            (C) Copyright 1990 Western Digital Corporation    \n");
	printf("                         AT  Disk Format Utility\n");
	printf("                                Rev. 2.50\n");
	printf("                  Current drive parameters are: ");
	curs( 4,h_shift);printf("                   Drive (0/1) :  ");
	curs( 5,h_shift);printf("                   Cylinders   :  ");
	curs( 6,h_shift);printf("                   Heads       :  ");
	curs( 7,h_shift);printf("                   Sectors     :  ");
	curs( 8,h_shift);printf("                   Interleave  :  ");
	curs( 9,h_shift);printf("                   Precomp     :  ");
	curs(10,h_shift);printf("                   Skew        :  ");
	curs(11,h_shift);printf("                   Alt Sector  :  ");

}

/*************************************/
/*				     */
/*    get_2spec 		     */
/*				     */
/*    get drive spects from user     */
/*				     */
/*************************************/

get_2spec()

{
   int done, valid;
   unsigned char temp;

   done = false;
   while(!done)
   {

      curs(13,5);
      printf("   Enter drive specification at prompt or <CR> for default.              ");

      /* get input from screen */
      valid = FALSE;
      while(!valid)
      {
	 prompt(4, &hd_table.drv_number);
	 if((hd_table.drv_number EQL 0) OR (hd_table.drv_number EQL 1))
	    valid = TRUE;
	 else BELL;
      }
      prompt(5,&hd_table.max_cyl   );
      valid = FALSE;
      while(!valid)
      {
	 prompt(6,&hd_table.max_head  );
	 if((1 <= hd_table.max_head) AND (hd_table.max_head <= 16))
	    valid = TRUE;
	 else BELL;
      }
      prompt(7,&hd_table.max_sec );
      prompt( 8,&hd_table.ileave );
      prompt( 9,&hd_table.precomp);
      prompt(10,&hd_table.skew	 );
      curs(11,17+h_shift);ARROW;
      curs(11,36+h_shift);	       /* print alt sector yes/no */
      if(hd_table.alt_sector) printf("Yes");
      else printf(" No ");
      curs(11,36+h_shift);	       /* get alt sector yes/no */
      temp = get_input(redirection);	    /* get standerd input */
      temp = toupper(temp);
      switch(temp)
      { 				    /* start of switch temp */
	 case 'Y'     : hd_table.alt_sector = TRUE;
			break;
	 case 'N'     : hd_table.alt_sector = FALSE;
	 case CRG_RTN : break;
	 default      : BELL;

      } 				    /* end of switch */
      curs(11,36+h_shift);	       /* get alt sector yes/no */
      if(hd_table.alt_sector) printf("Yes");
      else printf(" No ");
      curs(11,17+h_shift);BLANK_SP;

      curs(13,5);
      printf("Enter <CR> if drive specification OK or enter 'C' for more changes : ");

      temp = get_input(redirection);	    /* get standerd input */
      temp = toupper(temp);
      switch(temp)
      { 				    /* start of switch temp */
	 case 'C'     : break;              /* "C" pressed */
	 case CRG_RTN : done = TRUE;	    /* <CR> was pressed */
			break;
	 default      : BELL;
      } 				    /* end of switch temp */
   };					    /* end of while */
   curs(13,5);
   printf("                                                                      ");
}



/*************************************/
/*				     */
/* prompt(row,def)		     */
/*				     */
/*  input:			     */
/*   row : row to display stand input*/
/*   def : pointer to default valvue */
/*				     */
/*************************************/

prompt(row,def)

char row;
int *def;

{
   char temp_str[8];

   curs(row,17+h_shift);ARROW;
   curs(row,46+h_shift);
  *def = get_dec(row,34+h_shift,4,*def);     /* get decimal value */
   curs(row,17+h_shift);BLANK_SP;
}


/*************************************/
/*				     */
/* format whole disk		     */
/*				     */
/*************************************/
format_all()

{

   int start_head, last_head, head;

   curs(20, 12+h_shift);printf("Formatting cylinder: ");
   curs(20, 40+h_shift);printf("head:");

   hd_table.blk_size = hd_table.max_sec;    /* do all track */

   if(hd_table.max_head > 7) last_head = 7;
    else last_head = hd_table.max_head;     /* set up last head to format this pass */
   start_head = 0;
   for(hd_table.cyl_number = 0; hd_table.cyl_number <= hd_table.max_cyl;
       hd_table.cyl_number++)
   {					    /* format heads 0-7 or less */
     format_loop(start_head,last_head);     /* do that format */
   };					    /* end "for" to  format 0-7 */

   if(hd_table.max_head > 7)
   {					    /* if more than 8 heads on disk drive */
      hd_table.head_number = 8; 	    /* set up SDH to trick controler into */
      load_task_file(); 		    /* thinking that this is a new drive */
      at_rest(0);			    /* recal with 35 micro second rate */
      while(at_ckbsy());		    /* check busy bit in controler */
      while(at_ckbsy());		    /* check busy bit in controler */
      for(hd_table.cyl_number = 0; hd_table.cyl_number <= hd_table.max_cyl;
	  hd_table.cyl_number++)
      {
	 last_head = hd_table.max_head;     /* last head to format */
	 start_head =8; 		    /* first head to format */
	 format_loop(start_head,last_head); /* do that format */
      };				    /* end "for" loop */
   };					    /* end of if > 8*/
}					    /* end of format_all */


/****************************************************/
/*						    */
/* format_loop					    */
/*						    */
/* input: start_head; head # to start formating on  */
/*	  last_head;  last head to format	    */
/*						    */
/****************************************************/

format_loop(start_head,last_head)

int start_head,last_head;

{
   curs(20, 33+h_shift);printf("%4d", hd_table.cyl_number);
   for(hd_table.head_number = start_head;
       hd_table.head_number <= last_head;
       hd_table.head_number++)
   {
     curs(20, 46+h_shift);printf("%2d", hd_table.head_number);

     load_task_file();
     int_flag = 0;			      /* clear interrupt flag */
     at_fmt();
     while(! (0x08 & at_rstat()));/* wait for data request */
     at_wrbfr(0, fmt_buffer[hd_table.head_number]);
     while(at_ckbsy()); 		    /* check busy bit in controler */
     if ((at_rstat() & 0x05)) show_error();
   }					    /* end of for loop */
}					    /* end of format_loop */




/*************************************/
/*				     */
/* verify each sector		     */
/*				     */
/*************************************/
verify_all()

{					    /* start of verify procedure */

 int num_reads;
 int stat_byte,done;
 unsigned char temp_char;

 if(hd_table.alt_sector)		    /* set up block size */
   hd_table.blk_size = hd_table.max_sec - 1;
 else
   hd_table.blk_size = hd_table.max_sec;
 err_count = 0;
 load_task_file();			    /* thinking that this is a new drive */
 at_rest(0);				    /* recal with 35 micro second rate */
 while(at_ckbsy());			    /* check busy bit in controler */
 while(at_ckbsy());			    /* check busy bit in controler */
 for(hd_table.cyl_number = 0;
     hd_table.cyl_number <= hd_table.max_cyl;
     hd_table.cyl_number++)
    test_cyl(); 			    /* verify cyclinder */
}					    /* end of verify procedure */

/*************************************/
/*				     */
/* write_cyl()			     */
/*				     */
/*   input :   none		     */
/*				     */
/*************************************/
write_cyl()


{					    /* start of write_cyl procedure */

 int done,i,num_reads, stat_byte;
 unsigned int *p;
 unsigned char temp_char;

 if(hd_table.alt_sector)		    /* set up block size */
   hd_table.blk_size = hd_table.max_sec - 1;
 else
   hd_table.blk_size = hd_table.max_sec;
 if(err_count >= 300) return;
 for(hd_table.head_number = 0;
     hd_table.head_number <= hd_table.max_head;
     hd_table.head_number++)
 {					    /* start of head loop */
    curs(20, 46+h_shift);printf("%2d", hd_table.head_number);

    load_task_file();
    int_flag = 0;			     /* clear interrupt flag */
    wr_block(wr_buffer);		    /* write sectors to drive */
    if(check_error()) show_error();	    /* check if error */
 }					    /* end of head loop */
}					    /* end of write_cyl procedure */

/*************************************/
/*				     */
/* test_cyl()			     */
/*				     */
/*   input :			     */
/*     pattern : pattern to write    */
/*				     */
/*************************************/
test_cyl()


{					    /* start of test_cyl procedure */

 int done, i, num_reads, stat_byte, last_sector;
 unsigned int *p;
 unsigned char temp_char;

    last_sector = hd_table.max_sec;
    if(hd_table.alt_sector)		       /* set up block size */
      last_sector--;
 if(err_count >= 300) return;
 curs(20, 33+h_shift);printf("%4d", hd_table.cyl_number);
 for(hd_table.head_number = 0;
     hd_table.head_number <= hd_table.max_head;
     hd_table.head_number++)
 {					    /* start of head loop */
    hd_table.sec_number = 1;
    hd_table.blk_size = last_sector;
    curs(20, 46+h_shift);printf("%2d", hd_table.head_number);
    for(num_reads = 0; num_reads < 3; num_reads++)
    {					    /* start of 3 trys to read read */
       load_task_file();
       at_rdver(1);			    /* do that verify with out retry */
       while(at_ckbsy());		    /* check busy bit in controler */
       if(check_error())
       {				    /* check if error */
	  show_error(); 		    /* display error */
	  hd_table.blk_size = 1;
	  while((int)inp(0x1f3) < last_sector)
	  {
	    hd_table.sec_number = (int)inp(0x1f3)+1;
	    load_task_file();
	    at_rdver(1);			 /* do that verify with out retry */
	    while(at_ckbsy());			 /* check busy bit in controler */
	    check_error();
	  }
	  break;
       }				    /* end if check error */
    }					    /* end of 3 tries */
 }					    /* end of head loop */
}					    /* end of test_cyl procedure */

/*************************************/
/*				     */
/* check_error()		     */
/*				     */
/*************************************/
int check_error()

{					    /* start of check_error() */
   unsigned char temp_char;
   int done, temp, temp2, bad_sector, alt_error;

   if((at_rstat() & 0x05) EQL 0) return FALSE;	     /* if no error */
   temp_char = at_rderr();		    /* read error reg */
   if(temp_char & 0x80) return FALSE;	    /* if bad block mark */
   if(previous_error()) return FALSE;	    /* if cyl + head # in err_table */
   if (err_count EQL 100)
   {					    /* if error count = 100 */
      curs(22,1+h_shift);
      printf("         Error count = 100 press Q to quit or <CR> to continue       ");
      done = FALSE;
      while(!done)
      { 				    /* start of switch */
	 temp_char = get_input(redirection);
	 temp_char = toupper(temp_char);
	 switch(temp_char)
	 {
	    case 'Q'     : cls();
			   curs(0,0);printf("exit WDFMT\n");
			   exit(0);
	    case CRG_RTN : done = TRUE;
			   break;
	    default	 : BELL;
	 }				    /* end switch */
      } 				    /* end while !done */
   }					    /* end of if error count  = 100 */
   if (err_count < 300)
   {					    /* start of "if error < 300" */
      err_table[err_count].cyl = hd_table.cyl_number;
      err_table[err_count].head = hd_table.head_number;
      err_table[err_count].sector = inp(SECTN);
      err_count++;
   }					    /* end of "if error < 300" */
   if (err_count >= 300)
   {					    /* start of if error >= 300" */
      curs(22,1+h_shift);
      printf("           Error count exceeded 300 errors!!!                 ");
   }					    /* end of "if error >= 300" */
   return TRUE; 			    /* return error TRUE */
}					    /* end of check_error() */

/*************************************/
/*				     */
/* previous_error()		     */
/*				     */
/*************************************/
int previous_error()

{					    /* start of previous_error() */
   int i;

   for(i=1; i <= 16; i++)
   {					    /* start of check last few entry */
      if((err_count-i) < 0) return FALSE;
      if((err_table[err_count-i].cyl	    EQL hd_table.cyl_number)
	 AND (err_table[err_count-i].head   EQL hd_table.head_number)
	 AND (err_table[err_count-i].sector EQL hd_table.sec_number) )
	 return TRUE;
   }					    /* end of check last few entry */
   return FALSE;			    /* not previous error */
}					    /* end of previous error */


/************************************************/
/* shift_ilt(bad_sector)			*/
/*						*/
/*  input  :					*/
/*	     bad_sector : sector number of bad	*/
/*			  sector		*/
/*						*/
/*  output : none				*/
/*						*/
/* This routine will shift the interleave table */
/* so that sector zero is on the bad sector and */
/* and the rest of the track is shifted by one. */
/*						*/
/************************************************/
shift_ilt(bad_sector)

int bad_sector;

{					    /* start of shift_ilt */
   unsigned char *buff;
   int i, offset;

   buff = fmt_buffer[hd_table.head_number];   /* start address of table */
   for(offset = 1;
       *(buff + offset) != bad_sector;
       offset += 2);			    /* search for sector #*/
   offset--;
   for(i = (hd_table.max_sec * 2)-3; i >= offset; i--)
      *(buff+i+2) = *(buff+i);		    /* shift interleave table */
   *(buff + offset++) = 0x80;		    /* mark bad sector */
   *(buff + offset)   = alt_value;	    /* alt sector number */
}					    /* end of shift_ilt */

