
/************************************************/
/*   this file contains several video routines	*/
/*						*/
/*						*/
/*						*/
/*						*/
/*						*/
/*						*/
/*						*/
/*						*/
/*						*/
/*						*/
/************************************************/


#include <scancode.h>
#include "defs.h"
#include <dos.h>
#include "color.h"


int redirection;
union REGS inregs, outregs;


/*****************************************************/
/* upscroll(lines,top_row,bot_row,l_col,r_col,fill) */
/*						     */
/*  input  :					     */
/*	    lines   : number of lines to scroll      */
/*	    top_row : top row of window 	     */
/*	    bot_row : bottom row of window	     */
/*	    l_col   : left column of window	     */
/*	    r_col   : right column of window	     */
/*	    fill    : filler attribute		     */
/*						     */
/*  output : none				     */
/*						     */
/* this routine will scroll a window up as meny      */
/* lines as told in var lines			     */
/*						     */
/*****************************************************/

upscroll(lines,top_row,bot_row,l_col,r_col,fill)

char lines,top_row,bot_row,l_col,r_col,fill;

{
   inregs.h.ah = 6;			   /* set up registers for interrupt */
   inregs.h.al = lines;
   inregs.h.bh = fill;
   inregs.h.ch = top_row;
   inregs.h.cl = l_col;
   inregs.h.dh = bot_row;
   inregs.h.dl = r_col;
   int86(0x10,&inregs,&outregs);
}


/*****************************************************/
/* downscroll(lines,top_row,bot_row,l_col,r_col,fill) */
/*						     */
/*  input  :					     */
/*	    lines   : number of lines to scroll      */
/*	    top_row : top row of window 	     */
/*	    bot_row : bottom row of window	     */
/*	    l_col   : left column of window	     */
/*	    r_col   : right column of window	     */
/*	    fill    : filler attribute		     */
/*						     */
/*  output : none				     */
/*						     */
/* this routine will scroll a window down as meny    */
/* lines as told in var lines			     */
/*						     */
/*****************************************************/

downscroll(lines,top_row,bot_row,l_col,r_col,fill)

char lines,top_row,bot_row,l_col,r_col,fill;

{
   inregs.h.ah = 7;			   /* set up registers for interrupt */
   inregs.h.al = lines;
   inregs.h.bh = fill;
   inregs.h.ch = top_row;
   inregs.h.cl = l_col;
   inregs.h.dh = bot_row;
   inregs.h.dl = r_col;
   int86(0x10,&inregs,&outregs);
}

/************************************************/
/*						*/
/*  cls()					*/
/*						*/
/*    input  : none				*/
/*						*/
/*    output : none				*/
/*						*/
/*  this routine will clear the whole screen	*/
/*						*/
/************************************************/

cls()

{
   inregs.h.ah = 6;			   /* set up registers for interrupt */
   inregs.h.al = 24;			   /* lines */
   inregs.h.bh = VNORMAL;		   /* fill */
   inregs.h.ch = 0;			   /* top_row */
   inregs.h.cl = 0;			   /* l_col */
   inregs.h.dh = 24;			   /* bot_row */
   inregs.h.dl = 79;			   /* r_col */
   int86(0x10,&inregs,&outregs);
}

/*****************************************************/
/*						     */
/*  curs(row,col)				     */
/*						     */
/* input  :					     */
/*	    row :  row to place curser at (0 = top ) */
/*	    col :  column position  (0 = left)	     */
/*						     */
/* output : none				     */
/*						     */
/* routine will place the cursor on screen	     */
/*						     */
/*****************************************************/

crs(row,col)

int row,col;

{					    /* start of curs */
   inregs.h.ah = 2;			    /* set ah with service # */
   inregs.h.bh = 0;
   inregs.h.dh = (char)row;
   inregs.h.dl = (char)col;
   int86(16,&inregs,&outregs);		    /* do that interrupt */
}					    /* end of curs */


/************************************************/
/*						*/
/* print_atrb(row,col,string,atbute)		*/
/*						*/
/*  input  :					*/
/*	     string : string to output		*/
/*	     atbute : attribute of string	*/
/*	     row    : row to start at		*/
/*	     col    : column to start at	*/
/*						*/
/*  output : none				*/
/*						*/
/*						*/
/*						*/
/************************************************/

print_atrb(row,col,string,atbute)

char row,col,*string,atbute;

{					    /* start of print_atrb */
   inregs.h.ah = 9;			    /* set up regs */
   inregs.h.bh = 0;
   inregs.h.bl = atbute;
   inregs.x.cx = 1;
   while(*string)
   {					    /* start of while */
      inregs.h.ah = 2;			    /* set regs for curs pos */
      inregs.h.bh = 0;
      inregs.h.dh = (char)row;
      inregs.h.dl = (char)col;
      int86(16,&inregs,&outregs);	    /* set curs position  */
      col++;
      inregs.h.ah = 9;			    /* set up regs for print screen */
      inregs.h.bh = 0;
      inregs.h.bl = atbute;
      inregs.x.cx = 1;
      inregs.h.al = *string;
      int86(0x10,&inregs,&outregs);	    /* print char */
      *string++;
   }					    /* end of while */
}					    /* end of print_atrb */

/************************************/

get_curs(row, col)
char *row, *col;
{
	inregs.h.ah = 3;
	inregs.x.bx = 0;
	int86(0x10, &inregs, &outregs);
	*row = (char) outregs.h.dh;
	*col = (char) outregs.h.dl;
}
/*************************
** era_eol()
** erase to end of line
**************************/
era_eol()
{
	char row, col, window[4];
	get_curs(&row, &col);
	upscroll(1,row,row,col,79,VNORMAL);
}
