//	Cirrus Logic header file cirrus.h
//
//	Contains class definitions for Cirrus Logic GD-54xx video boards
//
//

//	The following line denies outside code access to certain
//	member functions of class vga.
#define __cirrus_h
#include "vga.h"


class _cirrus : public vga	{		// Cirrus-Logic family GD542x/3x
protected:
	double get_mclkfreq( void )
		{	return( _OSC * ( read_SR( 0x1F ) & 0x3F ) / 8.0 );	};
		//	Get MCLK frequency from registers
     uchar _SR06;	// Preserve original SR06 value
public:
	message _info( void );		//	Return silicon Revision#
	void _mclk( int cmd );		//	MCLK programming function
//	void _fxn1( int cmd );		//	MCLK timing (read-only)
	_cirrus( vga_info info ) : vga( info )
		{	_SR06 = read_CR( 0x06 );	// Preserve original SR06 value
			write_SR( 0x06, 0x12 );	};	// Unlock Cirrus SVGA registers
     ~_cirrus()
     	{	write_SR( 0x06, _SR06 );	};
};


class _GD5424 : public _cirrus	{	//Cirrus-Logic GD-5424 - 5428
protected:
public:
	_GD5424( vga_info info ) : _cirrus( info )
		{;};	//	Null Constructor
	void _fxn2( int cmd );	//	IO RDY delay...local-bus only!
	void _fxn3( int cmd );	//   RDY mem-write...local-bus only!
//	void _fxn5( int cmd );	//   FIFO threshold...local-bus only!
//	^^^^ removed, because Cirrus BIOS reprograms threshold for every mode!
};


class _GD543x : public _GD5424 {		// Cirrus-Logic 5430
protected:
public:
	_GD543x( vga_info info ) : _GD5424( info )
		{;};	// Null constructor
	void _fxn2( int cmd );	//	IO LRDY delay...VL-bus only!
	void _fxn3( int cmd );	//   LRDY mem-read/write delays...VL-bus only!
};


class _GD5434 : public _GD543x {		// Cirrus-Logic GD-5434
protected:
public:
	void _mclk( int cmd );		//	MCLK programming function
	_GD5434( vga_info info ) : _GD543x( info )
		{;};	// Null constructor
};


class _GD5436 : public _GD543x {		// Cirrus-Logic GD-5436, v084
protected:
public:
	_GD5436( vga_info info ) : _GD543x( info )
		{;};	// Null constructor
	void _fxn1( int cmd );	//	Enable 8-MCLK EDO timing
	void _fxn2( int cmd );	//	Single Cycle RAM refresh timing
};


class _GD5462 : public vga	{		// Cirrus-Logic family GD546x
	// Note, all GD-546X are PCI-only devices
protected:
     uchar far *framebuffer;	// Pointer to VGA framebuffer at A000:0000
	dword baseio;		// Store old mmio base address (PCICFG$10) 32-bit
	word pci_command;	// Store old pci-command register (PCICFG$04)16-bit
     uchar read_base0( uint offset );	// Read byte from { BA0 + offset }
	void write_base0( uint offset, uchar value ); // Write byte to ...
     uchar read_cbyte( const uchar index );
     	// Read PCI-configuration register, index 0-255
     uchar write_cbyte( const uchar index, const uchar value );
     	// Write value -> PCI-config(index)
	uchar get_mclkbyte( void );
		//	Get MCLK frequency from registers
public:
	message _info( void );		//	Return silicon Revision#
	void _mclk( int cmd );		//	MCLK programming function
	pci_bios_type *pci_bios;		//  Needed for PCI autodetect routine
	pci_device_handle_type pci_vga;	// Needed for PCI autodetect

     _GD5462( vga_info info );//	Constructor
     ~_GD5462();	// Destructor

};

class _GD5464 : public _GD5462	{	// Cirrus-Logic GD-5464
	// GD-5464 adds bus-master control
protected:
public:
	void _fxn2( int cmd );		//	PCI Master Latency Timer
     _GD5464( vga_info info ) : _GD5462( info )
     	{;};	// Null constructor
};
