/* MCLK.C program by Royce Liao		05/95	v1.1
 * This program allows the user to change the MEMORY CLOCK (MCLK) register
 * on Cirrus Logic GD-542x/543x video cards.
 *
 * This program assumes the pressence of a supported GD-542x/3x video card:
 * it does NOT check for a Cirrus chip's presence!
 * (All Cirrus GD-543x and most GD-542x are supported.)
 *
 * Compiled with Borland's Turbo C++ 3.0 (MS-DOS), TINY memory model
 *
 * Questions, comments?  leave email to liaor@umich.edu
 */

#include<dos.h>
#include<stdio.h>

#define _OSC		14.31818	/* Reference clock frequency	*/
#define _SRindex	0x3C4	/* VGA Sequencer register index */
#define _SRIO		0x3C5	/* VGA Sequencer register IO	*/

extern int _argc;
extern char **_argv;


unsigned char read_SR(char index)
{
	outportb(_SRindex, index);
		/* Set-up register to load index-register value */
	return( inportb( _SRIO ) );	/* Read & return port value */
}


void write_SR(unsigned char index, unsigned char byte)
{
	outportb(_SRindex, index);
		/* Set-up register to load index-register value */
	outportb(_SRIO, byte);
}


unsigned char read_MCLK(void)	/* Reads 6-bit scalar value */
{
	unsigned char byte= read_SR(0x1F); /* Read MCLK register */

	byte &= 0x3F;	/* XXXX XXXX -> 00XX XXXX ( '0' bits 6-7 ) */

	return( byte );
}


void write_MCLK(unsigned char byte)
{
	unsigned char new_MCLK = read_SR( 0x1F );	/* Read SR register */

	new_MCLK= new_MCLK & 0xC0;
	new_MCLK= byte | new_MCLK;
	write_SR( 0x1F, new_MCLK);
}


double get_MCLK(void)           /* Returns MHz value of MCLK */
{
	unsigned char byte = read_MCLK();	/* Get MCLK scalar-byte */

	return( _OSC * byte / 8.0 );
}


void help_menu(void)
{
	printf("\n\nMCLK v1.1 05/95\n\nMCLK	 [SCALAR]");
	printf("\n\t[ SCALAR ] = MCLK denominator (from 0-63 dec)\n");
	printf("\n        %.5fMHz", _OSC );
	printf("\nMCLK =  -----------  *  [SCALAR]");
	printf("\n             8");

	printf("\n\nMaximum [ SCALAR ] for various Cirrus Logic chipsets:");
	printf("\n\tGD-5422 and below       - NOT SUPPORTED (fixed dotclock)");
	printf("\n\tGD-5424 through GD-5428 - 50MHz ( [ SCALAR ] = 28dec )");
	printf("\n\tGD-5430, GD-5434        - 50MHz ( [ SCALAR ] = 28dec )");
	printf("\n\tGD-5429, GD-5434 Rev E  - 60MHz ( [ SCALAR ] = 34dec )");
}

void main(void)
{
	unsigned char byte;

	printf("\nCurrent MCLK frequency = %.4f MHz ", get_MCLK() );
	printf("\t(MCLK scalar = %ud )", read_MCLK() );

	if ( _argc > 1)
		if ( sscanf( _argv[ 1 ], " %ud", &byte ) != 0 )	{
			write_MCLK( byte );
			printf("\n\n    New MCLK frequency = %.4f MHz ", get_MCLK() );
			printf("\t(MCLK scalar = %ud )",	read_MCLK() );
			exit();	/* Exit program if new MCLK value is written */
			}

	help_menu();	/* Otherwise, display the help_menu */
}
