{
    ViewPreview1.pas - VIEW viewer
    Copyright (C) 1997-1999 Peter Kelly <peter@area51.org.au>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
}

unit ViewPreview1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls, Grids, Outline, DirOutln, ComCtrls, Defines, VolMan2;

var ViewImageInitialTop : word;
    ViewImageInitialLeft : word;
    ViewPreviewPanelInitialWidth : word;
    ViewPreviewPanelInitialHeight : word;

procedure FreePreviewView;
function LoadPreviewView(ViewNum:byte) : boolean;
procedure DisplayPreviewView(Loopno,Celno:byte);
procedure ResizeViewPreviewPanel;

implementation

uses main1, PreviewWin1, ResourceWin1;

{*************************************************************}
procedure ResizeViewPreviewPanel;
{*************************************************************}
var NewWidth : integer;
begin
  NewWidth := PreviewWin.ClientWidth - PreviewWin.ViewPreviewPanel.Left*2;
  if (NewWidth >= PreviewWin.ViewPreviewAdjustPanel.Width)
  and (NewWidth >= PreviewWin.ViewImage.Width)
  and (NewWidth > 0) then
  begin
    PreviewWin.ViewDescription.Width := PreviewWin.ViewPreviewPanel.Width;
    PreviewWin.ViewPreviewAdjustPanel.Left := (PreviewWin.ViewPreviewPanel.Width div 2) - (PreviewWin.ViewPreviewAdjustPanel.Width div 2);
    PreviewWin.ViewPreviewPanel.Height := PreviewWin.ClientHeight - PreviewWin.ViewPreviewPanel.Top * 2;
    PreviewWin.ViewDescription.Height := PreviewWin.ViewPreviewPanel.Height - PreviewWin.ViewDescription.Top;
    if PreviewView.CurrentCelMirrored then
      PreviewWin.ViewImage.Left := (PreviewWin.ViewPreviewPanel.Width div 2) + PreviewView.MaxWidth[PreviewWin.LoopAdjust.Position]*2 - PreviewWin.ViewImage.Width
    else PreviewWin.ViewImage.Left := (PreviewWin.ViewPreviewPanel.Width div 2) - PreviewView.MaxWidth[PreviewWin.LoopAdjust.Position]*2;
  end;
end;
{*************************************************************}
procedure FreePreviewView;
{*************************************************************}
begin
  if PreviewView.InUse then
  begin
    FreeMem(PreviewView.Resource.Data,PreviewView.Resource.Size);
    PreviewView.InUse := False;
  end;
end;

{*************************************************************}
procedure DisplayPreviewView(Loopno,Celno:byte);
{*************************************************************}

var ResPos                  : word;
    CelX, CelY              : byte;
    CelWidth, CelHeight     : byte;
    CurByte                 : byte;
    TransCol                : byte;
    ChunkCol, ChunkWidth    : byte;
    TempX                   : byte;
    TempStr                 : string;
    TempBitmap              : TBitmap;
    TempPalette             : HPalette;
    NumLoopsStr, NumCelsStr : string;
    LoopnoStr, CelnoStr     : string;
    MirrorBitmap            : TBitmap;
    MirrorCel               : boolean;

  function ReadByte : byte;
  begin
    if ResPos < PreviewView.Resource.Size then
    begin
      ReadByte := PreviewView.Resource.Data^[ResPos];
      ResPos := ResPos + 1;
    end
    else ReadByte := 0;
  end;

begin
  PreviewWin.CelAdjust.Max := PreviewView.NumCels[Loopno]-1;
  if PreviewView.NumCels[LoopNo] > 1 then PreviewWin.CelAdjust.Enabled := true
  else PreviewWin.CelAdjust.Enabled := false;
  PreviewWin.LoopAdjust.Position := Loopno;
  PreviewWin.CelAdjust.Position := Celno;
  Str(Loopno,LoopnoStr);
  Str(PreviewView.NumLoops-1,NumLoopsStr);
  Str(Celno,CelnoStr);
  Str(PreviewView.NumCels[Loopno]-1,NumCelsStr);
  PreviewWin.LoopDisplay.Caption := LoopnoStr + '/' + NumLoopsStr;
  PreviewWin.CelDisplay.Caption := CelnoStr + '/' + NumCelsStr;

  ResPos := PreviewView.Loopstart[Loopno] + PreviewView.Celstart[Loopno,Celno];
  CelWidth := ReadByte;
  CelHeight := ReadByte;
  CurByte := ReadByte;
  TransCol := CurByte mod $10;
  if (CurByte >= $80) and (PreviewView.MirrorLoop[Loopno]) then MirrorCel := true
  else MirrorCel := false;

  TempBitmap := TBitmap.Create;
  TempBitmap.Assign(BaseBitmap);
  TempBitmap.Canvas.Brush.Style := bsSolid;
  TempBitmap.Width := CelWidth*2;
  TempBitmap.Height := CelHeight;
//  TempPalette := CreateEGAPalette;
//  TempBitmap.Palette := TempPalette;
  TempBitmap.Palette := CreateEGAPalette;
  SelectPalette(TempBitmap.Canvas.Handle, EGAPalHandle, True);
  PreviewWin.ViewImage.Width := TempBitmap.Width*2;
  PreviewWin.ViewImage.Height := TempBitmap.Height*2;

  PreviewWin.ViewImage.Top := ViewImageInitialTop + PreviewView.MaxHeight[Loopno]*2 - CelHeight*2;
  if PreviewView.MaxWidth[Loopno]*4 > PreviewWin.ViewPreviewPanel.Width then
  begin
    PreviewWin.ViewPreviewPanel.Width := PreviewView.MaxWidth[Loopno]*4;
    PreviewWin.ViewPreviewAdjustPanel.Left := (PreviewWin.ViewPreviewPanel.Width div 2) - (PreviewWin.ViewPreviewAdjustPanel.Width div 2);
  end;
  if PreviewWin.ViewPreviewPanel.Width > PreviewWin.ClientWidth then
    PreviewWin.ClientWidth := PreviewWin.ViewPreviewPanel.Width;
  if MirrorCel then PreviewWin.ViewImage.Left := (PreviewWin.ViewPreviewPanel.Width div 2) + PreviewView.MaxWidth[Loopno]*2 - CelWidth*4
  else PreviewWin.ViewImage.Left := (PreviewWin.ViewPreviewPanel.Width div 2) - PreviewView.MaxWidth[Loopno]*2;
  PreviewView.CurrentCelMirrored := MirrorCel;
  TempBitmap.Canvas.Brush.Color := EGACOL[TransCol];
  TempBitmap.Canvas.FillRect(Rect(0,0,CelWidth*2,CelHeight));
  CelY := 0;
  repeat
  begin
    CelX := 0;
    repeat
    begin
      CurByte := ReadByte;
      if CurByte > 0 then
      begin
        ChunkCol := Curbyte div $10;
        ChunkWidth := Curbyte mod $10;
        for CelX := CelX to CelX + ChunkWidth - 1 do
        begin
          TempBitmap.Canvas.Pixels[CelX*2,CelY] := EGACOL[ChunkCol];
          TempBitmap.Canvas.Pixels[CelX*2+1,CelY] := EGACOL[ChunkCol];
        end;
      end;
    end until CurByte = 0;
    CelY := CelY + 1;
  end; until CelY >= CelHeight;
  if MirrorCel then
  begin
    MirrorBitmap := TBitmap.Create;
    MirrorBitmap.Width := TempBitmap.Width;
    MirrorBitmap.Height := TempBitmap.Height;
    MirrorBitmap.Canvas.StretchDraw(Rect(TempBitmap.Width-1,0,-1,TempBitmap.Height),TempBitmap);
    PreviewWin.ViewImage.Picture.Bitmap.Assign(MirrorBitmap);
    MirrorBitmap.Free;
  end
  else PreviewWin.ViewImage.Picture.Bitmap.Assign(TempBitmap);

//x  PreviewWin.ViewImage.Picture.Bitmap.Width := TempBitmap.Width;
//x  PreviewWin.ViewImage.Picture.Bitmap.Height := TempBitmap.Height;
//x  PreviewWin.ViewImage.Canvas.StretchDraw(Rect(0,0,TempBitmap.Width,TempBitmap.Height),TempBitmap);
//x  PreviewWin.ViewImage.Picture.Bitmap.Palette := EGAPalHandle;


//  PreviewWin.SetFocus;
//  ResourceWin.SetFocus;
//  PreviewWin.Repaint;

  ResourceWin.Image1.Picture.Bitmap.Assign(PreviewWin.ViewImage.Picture.Bitmap);

//  PreviewWin.ViewImage.Assign(TempBitmap);
  TempBitmap.Free;
end;

{*************************************************************}
function LoadPreviewView(ViewNum:byte) : boolean;
{*************************************************************}

var ResPos               : word;
    CurLoop, CurCel      : byte;
    CurByte              : byte;
    TempStr              : string;
    ErrorMessage         : string;
    TempBitmap           : TBitmap;
    TmpLoopNo            : byte;
    DescLoc              : word;
    Description          : string;

    Desc1 : string;

  function ReadByte : byte;
  begin
    if ResPos < PreviewView.Resource.Size then
    begin
      ReadByte := PreviewView.Resource.Data^[ResPos];
      ResPos := ResPos + 1;
    end
    else
    begin
      ReadByte := 0;
      ResPos := 0;
      ErrorMessage := ('Error: Read beyond end of resource.');
    end;
  end;

  function ReadWord : word;
  var lsbyte,msbyte : byte;
  begin
    lsbyte := ReadByte;
    msbyte := ReadByte;
    ReadWord := msbyte * 256 + lsbyte;
  end;

begin
  LoadPreviewView := False;
  PreviewView.Resource := ReadResource(VIEW,ViewNum);
  if PreviewView.Resource.Size > 0 then
  begin
    ErrorMessage := '';
    ResPos := 2;
    PreviewView.NumLoops := ReadByte;
    DescLoc := ReadWord;
    if PreviewView.NumLoops > MaxLoops then ErrorMessage := 'Error: Too many loops';
    if ErrorMessage = '' then
    begin
      str(PreviewView.NumLoops,TempStr);
      ResPos := 5;
      for CurLoop := 0 to PreviewView.NumLoops - 1 do
      begin
        PreviewView.Loopstart[CurLoop] := ReadWord;
        if (PreviewView.Loopstart[CurLoop] > PreviewView.Resource.Size) and (ErrorMessage = '') then
          ErrorMessage := 'Error: Loop start beyond end of resource';
      end;
    end;
    if ErrorMessage = '' then
    begin
      for CurLoop := 0 to PreviewView.NumLoops - 1 do
      begin
        PreviewView.MirrorLoop[CurLoop] := false;
        if CurLoop > 0 then for TmpLoopNo := 0 to CurLoop - 1 do
          if PreviewView.LoopStart[CurLoop]=PreviewView.LoopStart[TmpLoopNo] then
            PreviewView.MirrorLoop[CurLoop] := true;
        PreviewView.MaxWidth[CurLoop] := 0;
        PreviewView.MaxHeight[CurLoop] := 0;
        ResPos := PreviewView.Loopstart[CurLoop];
        PreviewView.NumCels[CurLoop] := ReadByte;
        if (PreviewView.NumCels[CurLoop] > MaxCels) and (ErrorMessage='') then
          ErrorMessage := 'Error: Too many cels (loop '+IntToStr(CurLoop)+')';
        for CurCel := 0 to PreviewView.NumCels[CurLoop] - 1 do
        begin
          PreviewView.Celstart[CurLoop,CurCel] := ReadWord;
          if (PreviewView.Celstart[CurLoop,CurCel] > PreviewView.Resource.Size) and (ErrorMessage = '') then
            ErrorMessage := 'Error: Cel start beyond end of resource';
        end;
        for CurCel := 0 to PreviewView.NumCels[CurLoop] - 1 do
        begin
          ResPos := PreviewView.LoopStart[CurLoop] + PreviewView.CelStart[CurLoop,CurCel];
          CurByte := ReadByte;
          if CurByte > PreviewView.MaxWidth[CurLoop] then PreviewView.MaxWidth[CurLoop] := CurByte;
          CurByte := ReadByte;
          if CurByte > PreviewView.MaxHeight[CurLoop] then PreviewView.MaxHeight[CurLoop] := CurByte;
        end;
      end;
    end;
    if ErrorMessage = '' then
    begin
      PreviewView.SelectedLoop := 0;
      PreviewView.SelectedCel := 0;
      DisplayPreviewView(0,0);
      if DescLoc = 0 then
      begin
        Description := '';
        PreviewWin.ViewDescription.visible := false;
      end
      else if DescLoc < PreviewView.Resource.Size - 1 then
      begin
        Description := '';
        ResPos := DescLoc;
        repeat
        begin
          CurByte := ReadByte;
          if (ResPos <= PreviewView.Resource.Size - 1) and (CurByte>0) and (Length(Description)<255) then
            Description := Description + chr(CurByte)
        end until (ResPos > PreviewView.Resource.Size - 1) or (CurByte=0) or (Length(Description)>=255);
        PreviewWin.ViewDescription.Caption := Description;
        PreviewWin.ViewDescription.Top := PreviewWin.ViewImage.Top + PreviewWin.ViewImage.Height + (PreviewWin.ViewImage.Top - PreviewWin.ViewPreviewAdjustPanel.Top - PreviewWin.ViewPreviewAdjustPanel.Height);
        PreviewWin.ViewDescription.Height := PreviewWin.ViewPreviewPanel.Height - PreviewWin.ViewDescription.Top;
        PreviewWin.ViewDescription.Visible := true;
      end;
      PreviewWin.LoopAdjust.Max := PreviewView.NumLoops - 1;
      if PreviewView.NumLoops > 1 then PreviewWin.LoopAdjust.Enabled := true
      else PreviewWin.LoopAdjust.Enabled := false;
    end;
    if Length(ErrorMessage) > 0 then
    begin
      ShowMessage(ErrorMessage);
    end
    else
      PreviewWin.Caption := 'Preview - ' + ResourceName(VIEW,ViewNum);
    PreviewView.InUse := True;
    LoadPreviewView := True;
  end; {if PreviewView.Resource.Size > 0}
end;

end.
