{
    ViewEditDescription1.pas - Description window for view editor
    Copyright (C) 1997-1999 Peter Kelly <peter@area51.org.au>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
}

unit ViewEditDescription1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TViewEditDescription = class(TForm)
    ViewImage: TImage;
    ButtonPanel: TPanel;
    OKBut: TButton;
    CancelBut: TButton;
    DescriptionEdit: TMemo;
    procedure OKButClick(Sender: TObject);
    procedure CancelButClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    ViewEditorNum : word;
  end;

var
  ViewEditDescription: TViewEditDescription;

implementation

{$R *.DFM}

uses Defines, ViewEdit1;

procedure TViewEditDescription.OKButClick(Sender: TObject);
begin
  ViewEditWin[ViewEditorNum].MainView.Description.Assign(DescriptionEdit.Lines);
  ViewEditWin[ViewEditorNum].ViewModified := True;
  Close;
end;

procedure TViewEditDescription.CancelButClick(Sender: TObject);
begin
  Close;
end;

procedure TViewEditDescription.FormResize(Sender: TObject);
begin
  if ViewEditDescription.ClientWidth > ViewEditDescription.ViewImage.Width then
  begin
    ViewImage.Left := (ViewEditDescription.ClientWidth div 2) - (ViewImage.Width div 2);
    DescriptionEdit.Width := ViewEditDescription.ClientWidth - DescriptionEdit.Left*2;
  end
  else
  begin
    ViewImage.Left := 0;
    ButtonPanel.Left := 0;
  end;
  if ViewEditDescription.ClientWidth > ButtonPanel.Width then
    ButtonPanel.Left := (ViewEditDescription.ClientWidth div 2) - (ButtonPanel.Width div 2)
  else ButtonPanel.Left := 0;
  if ViewEditDescription.ClientHeight - DescriptionEdit.Top - ButtonPanel.Height - ViewImage.Top*2 > 0 then
  begin
    ButtonPanel.Top := ViewEditDescription.ClientHeight - ButtonPanel.Height - ViewImage.Top;
    DescriptionEdit.Height := ViewEditDescription.ClientHeight - DescriptionEdit.Top - ButtonPanel.Height - ViewImage.Top*2;
  end
  else
  begin
    DescriptionEdit.Height := 0;
    ButtonPanel.Top := DescriptionEdit.Top;
  end;
end;

end.
