{
    GetDirName1.pas - Dialog box to get name of new directory
    Copyright (C) 1997-1999 Peter Kelly <peter@area51.org.au>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
}

unit GetDirName1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TGetDirName = class(TForm)
    OKBut: TButton;
    CancelBut: TButton;
    Label1: TLabel;
    DirNameEdit: TEdit;
    procedure CancelButClick(Sender: TObject);
    procedure DirNameEditChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure OKButClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    DirName : string;
    OKPressed : boolean;
  end;

var
  GetDirName: TGetDirName;

implementation

{$R *.DFM}

procedure TGetDirName.CancelButClick(Sender: TObject);
begin
  Close;
end;

procedure TGetDirName.DirNameEditChange(Sender: TObject);
begin
  OKBut.Enabled := (DirNameEdit.Text <> '');
end;

procedure TGetDirName.FormShow(Sender: TObject);
begin
  DirNameEdit.Text := '';
  OKBut.Enabled := False;
  OKPressed := False;
  DirNameEdit.SelectAll;
  DirNameEdit.SetFocus;
end;

procedure TGetDirName.OKButClick(Sender: TObject);
begin
  DirName := DirNameEdit.Text;
  OKPressed := True;
  Close;
end;

end.
