{
    GameDirSelect1.pas
    Copyright (C) 1997-1999 Peter Kelly <peter@area51.org.au>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
}

unit GameDirSelect1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Grids, Outline, DirOutln, ComCtrls, FileCtrl;

type
  TGameDirSelect = class(TForm)
    OKBut: TButton;
    CancelBut: TButton;
    DirectoryListBox1: TDirectoryListBox;
    DriveComboBox1: TDriveComboBox;
    Label1: TLabel;
    CreateBut: TButton;
    procedure CancelButClick(Sender: TObject);
    procedure DriveComboBox1Change(Sender: TObject);
    procedure OKButClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure CreateButClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    DirectorySelected : boolean;
    WindowFunction : (wfOpenGame,wfNewGame);
  end;

var
  GameDirSelect: TGameDirSelect;

implementation

uses GetDirName1;

{$R *.DFM}

function DiskInDrive(Drive: Char): Boolean;
var
  ErrorMode: word;

begin
  Drive := UpCase(Drive);
  if not (Drive in ['A'..'Z']) then
    raise EConvertError.Create('Not a valid drive ID');
  ErrorMode := SetErrorMode(SEM_FailCriticalErrors);
  try
    if DiskSize(Ord(Drive) - $40) = -1 then
      DiskInDrive := False
    else
      DiskInDrive := True;
  finally
    SetErrorMode(ErrorMode);
  end;
end;

procedure TGameDirSelect.CancelButClick(Sender: TObject);
begin
  Close;
end;

procedure TGameDirSelect.DriveComboBox1Change(Sender: TObject);
begin
  if DiskInDrive(DriveComboBox1.Drive) then DirectoryListBox1.Drive := DriveComboBox1.Drive
  else
  begin
    ShowMessage('An error occured reading drive '+DriveComboBox1.Drive+':.');
    if DiskInDrive(DirectoryListBox1.Drive) then
      DriveComboBox1.Drive := DirectoryListBox1.Drive
    else DriveComboBox1.Drive := 'C';
  end;
end;

procedure TGameDirSelect.OKButClick(Sender: TObject);
begin
  DirectoryListBox1.OpenCurrent;
  DirectorySelected := True;
  Close;
end;

procedure TGameDirSelect.FormShow(Sender: TObject);
begin
  DirectorySelected := False;
  if WindowFunction = wfOpenGame then
  begin
    GameDirSelect.Caption := 'Open game';
    Label1.Caption := 'Please select the directory containing the game you wish to open:';
    DirectoryListBox1.Height := CreateBut.Top + CreateBut.Height - DirectoryListBox1.Top;
    CreateBut.Enabled := False;
  end
  else if WindowFunction = wfNewGame then
  begin
    GameDirSelect.Caption := 'New game';
    Label1.Caption := 'Please select the directory you wish to put the new game in:';
    DirectoryListBox1.Height := CreateBut.Top - (OKBut.Top-(CreateBut.Top+CreateBut.Height))-DirectoryListBox1.Top;
    CreateBut.Enabled := True;
  end;
end;

procedure TGameDirSelect.CreateButClick(Sender: TObject);
begin
  GetDirName.Left := GameDirSelect.Left + (GameDirSelect.Width div 2) - (GetDirName.Width div 2);
  GetDirName.Top := GameDirSelect.Top + (GameDirSelect.Height div 2) - (GetDirName.Height div 2);
  GetDirName.ShowModal;
  if GetDirName.OKPressed then
  begin
    if not CreateDir(DirectoryListBox1.Directory+'\'+GetDirName.DirName) then
      ShowMessage('Error creating directory "'+GetDirName.Name+'".');
    DirectoryListBox1.Directory := DirectoryListBox1.Directory+'\'+GetDirName.DirName;
    DirectoryListBox1.Update;
  end;
end;

end.
