/*
 * Copyright (c) 2002 by Ravi Iyengar [ravi.i@softhome.net]
 * Released under the GNU General Public License
 * See LICENSE for details.
 */

#pragma once

/*
 * A list of #defines for application specific messages.
 */

// signifies a change in the play filter
//   wparam = filter index (0-7)
//   lparam = filter bitmask (1 << wparam)
#define SBM_SETFILTER (WM_APP+0)

// notification that plaback has started
#define SBM_PLAYSTARTED (WM_APP+1)

// notification that playback has stopped
#define SBM_PLAYSTOPPED (WM_APP+2)

// notification of a new sound signal
//   wparam = signal
#define SBM_SOUNDSIGNAL (WM_APP+3)

// occurs at 60Hz during playback, accurracy not guaranteed
//   wparam = sound time in ticks
#define SBM_SOUNDTICK (WM_APP+4)

// start playing the loaded resource
//   wparam = player id
#define SBM_PLAY (WM_APP+5)

// stop playing the loaded resource
#define SBM_STOP (WM_APP+6)
