/*
 * Copyright (c) 2002 by Ravi Iyengar [ravi.i@softhome.net]
 * Released under the GNU General Public License
 * See LICENSE for details.
 */

#pragma once

/*
 * Exceptions all derive from std::runtime_error. They have error messages
 * available through the what() method.
 */

#include <stdexcept>

 /*
 * EofException is thrown by DataStream when a read operation fails because
 * there is no more data in the stream.
 */
class EofException : public std::runtime_error
{
public:
	EofException(const std::string &message);
};

 /*
 * DataException is thrown by DataStream when a read operation fails because
 * the data at the read pointer does not match the expected data type.
 */
class DataException : public std::runtime_error
{
public:
	DataException(const std::string &message);
};

 /*
 * LoadException is thrown by SoundResource when a load or import operation
 * encounters an invalid file type. (Load and import operations will also pass
 * along an EofException and DataException thrown from the input stream.)
 */
class LoadException : public std::runtime_error
{
public:
	LoadException(const std::string &message);
};

/*
 * DeviceException is thrown by subclasses of SoundPlayer when there is an
 * error related to the sound hardware.
 */
class DeviceException : public std::runtime_error
{
public:
	DeviceException(const std::string &message);
};
