/////////////////////////////////////////////////////
//
// QuotesPropSheetPage.cpp
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    contains the property page procedure and dialog
//    box procedure for the Quotes property page
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// includes
//
/////////////////////////////////////////////////////

#include "QuotesDlgEventHandlers.h"
#include "QuotesPropSheetPage.h"

/////////////////////////////////////////////////////
//
// QuotesPageProc
//
/////////////////////////////////////////////////////
//
// Purpose:
//    property page procedure for the Quotes property
//    page
// Parameters:
//    consult a Windows API reference for the meanings
//    of the parameters
// Return value:
//    tell ya the truth, I don't really know what it's
//    for
//
/////////////////////////////////////////////////////

UINT CALLBACK QuotesPageProc(HWND hwnd, UINT uiMsg, LPPROPSHEETPAGE ppsp)
{
    switch(uiMsg)
    {
    case PSPCB_CREATE:
        return TRUE;

    case PSPCB_RELEASE:
        return 0;
    }

    return 0;
}

/////////////////////////////////////////////////////
//
// QuotesDlgProc
//
/////////////////////////////////////////////////////
//
// Purpose:
//    dialog box procedure for Quotes property page
// Parameters:
//    consult a Windows API reference for the meanings
//    of the parameters
// Return value:
//    TRUE if the BLG handled the event and Windows
//    doesn't need to; FALSE if Windows should handle
//    the event
// Remarks:
//    to prevent the window procedure from getting
//    too large, this function calls event handler
//    functions to handle specific messages
//
/////////////////////////////////////////////////////

BOOL CALLBACK QuotesDlgProc(HWND hDlg, UINT uiMsg, 
                            WPARAM wParam, LPARAM lParam)
{
    switch(uiMsg)
    {
    case WM_INITDIALOG:
        return OnQuotesDlgWMInitDialog(hDlg, wParam, lParam);
    case WM_NOTIFY:
        return OnQuotesDlgWMNotify(hDlg, wParam, lParam);
    }

    return FALSE;
}
