/////////////////////////////////////////////////////
//
// PositionCtrlDlgEventHandlers.h
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    prototypes for the Position Control dialog's
//    event handler functions
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

// make sure this header can't be included twice
#if !defined(POSITION_CTRL_DLG_EVENT_HANDLERS_H_INCLUDED)
#define POSITION_CTRL_DLG_EVENT_HANDLERS_H_INCLUDED

#include <windows.h>

/////////////////////////////////////////////////////
//
// OnPositionCtrlDlgWMCommand
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_COMMAND handler for the Position Control dialog
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_COMMAND message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_COMMAND message
// Parameter lParam:
//    the lParam sent with the WM_COMMAND message
//
/////////////////////////////////////////////////////

BOOL OnPositionCtrlDlgWMCommand(HWND hDlg, WPARAM wParam, LPARAM lParam);

/////////////////////////////////////////////////////
//
// OnPositionCtrlDlgWMInitDialog
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_INITDIALOG handler for the Position Control
//    dialog
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_INITDIALOG message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_INITDIALOG message
// Parameter lParam:
//    the lParam sent with the WM_INITDIALOG message
//
/////////////////////////////////////////////////////

BOOL OnPositionCtrlDlgWMInitDialog(HWND hDlg, WPARAM wParam, LPARAM lParam);

#endif // !defined(POSITION_CTRL_DLG_EVENT_HANDLERS_H_INCLUDED)