/////////////////////////////////////////////////////
//
// PositionCtrlDlgEventHandlers.cpp
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    implementation of event handlers for the Position
//    Control dialog
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// includes
//
/////////////////////////////////////////////////////

#include "resource.h"
#include "BLGDefs.h"
#include "GeneralUI.h"
#include "PositionCtrlDlgUI.h"
#include "PositionCtrlDlgEventHandlers.h"

/////////////////////////////////////////////////////
//
// defines
//
/////////////////////////////////////////////////////

#define STR_ADD_MODE_TITLE  "Add Ego Position Control"
#define STR_EDIT_MODE_TITLE "Edit Ego Position Control"

/////////////////////////////////////////////////////
//
// global variables
//
/////////////////////////////////////////////////////

HWND g_hwndPositionCtrlDlg;

/////////////////////////////////////////////////////
// defined in PositionCtrlDlg.cpp
extern BOOL g_bPositionCtrlDlgInEditMode;
extern EGOPOSITIONCONTROL g_epcTemp;
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// OnPositionCtrlDlgWMCommand
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_COMMAND handler for the Position Control dialog
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_COMMAND message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_COMMAND message
// Parameter lParam:
//    the lParam sent with the WM_COMMAND message
//
/////////////////////////////////////////////////////

BOOL OnPositionCtrlDlgWMCommand(HWND hDlg, WPARAM wParam, LPARAM lParam)
{
    switch(LOWORD(wParam))
    {
    case IDC_EDIT_SRC_ROOM:
        return OnEditSrcRoom(wParam);
    case IDC_EDIT_EGO_POS_X:
        return OnEditEgoPosX(wParam);
    case IDC_EDIT_EGO_POS_Y:
        return OnEditEgoPosY(wParam);
    case IDC_CHECK_IGNORE_PREV_ROOM:
        return OnIgnorePrevRoom();

    case IDOK:
        return OnOK();

    case IDCANCEL:
        EndDialog(hDlg, LOWORD(wParam));
        return TRUE;
    }

    return FALSE;
}

/////////////////////////////////////////////////////
//
// OnPositionCtrlDlgWMInitDialog
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_INITDIALOG handler for the Position Control
//    dialog
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_INITDIALOG message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_INITDIALOG message
// Parameter lParam:
//    the lParam sent with the WM_INITDIALOG message
//
/////////////////////////////////////////////////////

BOOL OnPositionCtrlDlgWMInitDialog(HWND hDlg, WPARAM wParam, LPARAM lParam)
{
    g_hwndPositionCtrlDlg = hDlg;

    CenterDialogToParent(hDlg);

    SendMessage(GetDlgItem(hDlg, IDC_EDIT_SRC_ROOM), EM_SETLIMITTEXT,
                static_cast<WPARAM>(MAX_DIGITS), 0);
    SendMessage(GetDlgItem(hDlg, IDC_EDIT_EGO_POS_X), EM_SETLIMITTEXT,
                static_cast<WPARAM>(MAX_DIGITS), 0);
    SendMessage(GetDlgItem(hDlg, IDC_EDIT_EGO_POS_Y), EM_SETLIMITTEXT,
                static_cast<WPARAM>(MAX_DIGITS), 0);

    if (g_bPositionCtrlDlgInEditMode)
    {
        char szBuffer[MAX_DIGITS + 1];
        if (g_epcTemp.nSrcRoom >= 0)
        {
            itoa(g_epcTemp.nSrcRoom, szBuffer, 10);
            SetWindowText(GetDlgItem(hDlg, IDC_EDIT_SRC_ROOM), szBuffer);
            EnableWindow(GetDlgItem(hDlg, IDC_CHECK_IGNORE_PREV_ROOM),
                         FALSE);
        }
        else
        {
            EnableWindow(GetDlgItem(hDlg, IDC_EDIT_SRC_ROOM), FALSE);
            SetCheckboxChecked(hDlg, IDC_CHECK_IGNORE_PREV_ROOM, TRUE);
        }

        itoa(g_epcTemp.nPosX, szBuffer, 10);
        SetWindowText(GetDlgItem(hDlg, IDC_EDIT_EGO_POS_X), szBuffer);
        itoa(g_epcTemp.nPosY, szBuffer, 10);
        SetWindowText(GetDlgItem(hDlg, IDC_EDIT_EGO_POS_Y), szBuffer);

        SetWindowText(hDlg, STR_EDIT_MODE_TITLE);
    }
    else
    {
        SetWindowText(hDlg, STR_ADD_MODE_TITLE);
        EnableWindow(GetDlgItem(hDlg, IDOK), FALSE);
    }

    return TRUE;
}