/////////////////////////////////////////////////////
//
// MessageBoxesEventHandlers.h
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    prototypes for the BLG custom message boxes'
//    event handler functions
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

// make sure this header can't be included twice
#if !defined(MESSAGE_BOXES_EVENT_HANDLERS_H_INCLUDED)
#define MESSAGE_BOXES_EVENT_HANDLERS_H_INCLUDED

#include <windows.h>

/////////////////////////////////////////////////////
//
// OnUnescapedQuoteMessageBoxWMCommand
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_COMMAND handler for the Unescaped Quote msg box
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_COMMAND message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_COMMAND message
// Parameter lParam:
//    the lParam sent with the WM_COMMAND message
//
/////////////////////////////////////////////////////

BOOL OnUnescapedQuoteMessageBoxWMCommand(HWND hDlg, WPARAM wParam,
                                         LPARAM lParam);

/////////////////////////////////////////////////////
//
// OnUnescapedQuoteMessageBoxWMInitDialog
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_INITDIALOG handler for the Unescaped Quote msg box
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_INITDIALOG message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_INITDIALOG message
// Parameter lParam:
//    the lParam sent with the WM_INITDIALOG message
//
/////////////////////////////////////////////////////

BOOL OnUnescapedQuoteMessageBoxWMInitDialog(HWND hDlg, WPARAM wParam,
                                            LPARAM lParam);

/////////////////////////////////////////////////////
//
// OnEscapedQuoteMessageBoxWMCommand
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_COMMAND handler for the Escaped Quote msg box
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_COMMAND message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_COMMAND message
// Parameter lParam:
//    the lParam sent with the WM_COMMAND message
//
/////////////////////////////////////////////////////

BOOL OnEscapedQuoteMessageBoxWMCommand(HWND hDlg, WPARAM wParam, 
                                       LPARAM lParam);

/////////////////////////////////////////////////////
//
// OnEscapedQuoteMessageBoxWMInitDialog
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_INITDIALOG handler for the Escaped Quote msg box
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_INITDIALOG message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_INITDIALOG message
// Parameter lParam:
//    the lParam sent with the WM_INITDIALOG message
//
/////////////////////////////////////////////////////

BOOL OnEscapedQuoteMessageBoxWMInitDialog(HWND hDlg, WPARAM wParam,
                                          LPARAM lParam);


#endif // !defined(MESSAGE_BOXES_EVENT_HANDLERS_H_INCLUDED)