/////////////////////////////////////////////////////
//
// MessageBoxesEventHandlers.cpp
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    contains event handlers for the various 
//    custom message boxes of the BLG
//
// Portability information:
//    this file contains code written specifically
//    for a Windows version of the BLG
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// includes
//
/////////////////////////////////////////////////////

#include "resource.h"
#include "GeneralUI.h"
#include "MessageBoxes.h"
#include "MessageBoxesUI.h"
#include "MessageBoxesEventHandlers.h"

/////////////////////////////////////////////////////
//
// globals
//
/////////////////////////////////////////////////////

// a global storage place for the current message box's
// window handle -- NOTE: having this one HWND variable
// for message boxes means that a message box cannot
// invoke another message box, but that shouldn't happen
// anyway, since message boxes are just supposed to be
// short and to the point -- if more complex input is
// required, design a new dialog box
HWND g_hwndMsgBox;

/////////////////////////////////////////////////////
// declared in MessageBoxes.cpp
extern char g_szMBControlName[MAX_CONTROL_NAME_LEN + 1];
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// functions for Unescaped Quote message boxes
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// OnUnescapedQuoteMessageBoxWMCommand
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_COMMAND handler for the Unescaped Quote msg box
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_COMMAND message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_COMMAND message
// Parameter lParam:
//    the lParam sent with the WM_COMMAND message
//
/////////////////////////////////////////////////////

BOOL OnUnescapedQuoteMessageBoxWMCommand(HWND hDlg, WPARAM wParam,
                                         LPARAM lParam)
{
    switch(LOWORD(wParam))
    {
    case IDC_RADIO_INCLUDE_QUOTES:
        return OnRadioIncludeQuotes();
    case IDC_RADIO_REMOVE_QUOTES:
        return OnRadioRemoveQuotes();
    case IDC_RADIO_EDIT_QUOTES:
        return OnRadioEditQuotes();
    case IDOK:
        return OnUnescapedQuoteMessageBoxOK();
    case IDCANCEL:
        EndDialog(hDlg, IDCANCEL);
        return TRUE;
    }
    return FALSE;
}

/////////////////////////////////////////////////////
//
// OnUnescapedQuoteMessageBoxWMInitDialog
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_INITDIALOG handler for the Unescaped Quote msg box
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_INITDIALOG message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_INITDIALOG message
// Parameter lParam:
//    the lParam sent with the WM_INITDIALOG message
//
/////////////////////////////////////////////////////

BOOL OnUnescapedQuoteMessageBoxWMInitDialog(HWND hDlg, WPARAM wParam,
                                            LPARAM lParam)
{
    g_hwndMsgBox = hDlg;

    CenterDialogToParent(hDlg);

    SetRadioButton(hDlg, IDC_RADIO_INCLUDE_QUOTES, 
                   IDC_RADIO_INCLUDE_QUOTES, IDC_RADIO_EDIT_QUOTES);

    SetWindowText(GetDlgItem(hDlg, IDC_STATIC_MSG_FIELD_NAME),
                  g_szMBControlName);
    return TRUE;
}

/////////////////////////////////////////////////////
//
// functions for Escaped Quote message boxes
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// OnEscapedQuoteMessageBoxWMCommand
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_COMMAND handler for the Escaped Quote msg box
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_COMMAND message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_COMMAND message
// Parameter lParam:
//    the lParam sent with the WM_COMMAND message
//
/////////////////////////////////////////////////////

BOOL OnEscapedQuoteMessageBoxWMCommand(HWND hDlg, WPARAM wParam,
                                       LPARAM lParam)
{
    switch(LOWORD(wParam))
    {
    case IDC_RADIO_REMOVE_BACKSLASH:
        return OnEscapedQuoteMsgBoxRadioRemoveBackslash();
    case IDC_RADIO_INCLUDE_BACKSLASH:        
        return OnEscapedQuoteMsgBoxRadioIncludeBackslash();
    case IDC_RADIO_EDIT_QUOTES:
        return OnEscapedQuoteMsgBoxRadioEditQuotes();
    case IDOK:
        return OnEscapedQuoteMsgBoxOK();
    case IDCANCEL:
        EndDialog(hDlg, IDCANCEL);
        return TRUE;
    }
    return FALSE;
}

/////////////////////////////////////////////////////
//
// OnEscapedQuoteMessageBoxWMInitDialog
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_INITDIALOG handler for the Escaped Quote msg box
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_INITDIALOG message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_INITDIALOG message
// Parameter lParam:
//    the lParam sent with the WM_INITDIALOG message
//
/////////////////////////////////////////////////////

BOOL OnEscapedQuoteMessageBoxWMInitDialog(HWND hDlg, WPARAM wParam,
                                          LPARAM lParam)
{
    g_hwndMsgBox = hDlg;

    CenterDialogToParent(hDlg);

    SetRadioButton(hDlg, IDC_RADIO_REMOVE_BACKSLASH, 
                   IDC_RADIO_REMOVE_BACKSLASH, IDC_RADIO_EDIT_QUOTES);

    SetWindowText(GetDlgItem(hDlg, IDC_STATIC_MSG_FIELD_NAME),
                  g_szMBControlName);
    return TRUE;
}