/////////////////////////////////////////////////////
//
// FirstRoomCtrlDlgUI.cpp
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    provides event handlers for user-interface
//    events such as button presses, etc., for the
//    First Room Control dialog; also provides functions
//    that update the user interface as necessary to
//    reflect the current state of the application
//
// Portability information:
//    this file contains code written specifically for
//    a Win32 build of the BLG
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// includes
//
/////////////////////////////////////////////////////

#include "resource.h"
#include "GeneralUI.h"
#include "FirstRoomCtrlDlgUI.h"

/////////////////////////////////////////////////////
// defined in FirstRoomCtrlDlgEventHandlers.cpp
extern HWND g_hwndFirstRoomCtrlDlg;
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
// defined in FirstRoomControlDlg.cpp
extern CFirstRoomCtrl g_frctrlTemp;
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// OnFirstRoomCtrlDlgOK
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles event for the First Room Control dialog's
//    OK button (validates entries, etc.)
// Return value:
//    TRUE if event is handled; FALSE otherwise
//
/////////////////////////////////////////////////////

BOOL OnFirstRoomCtrlDlgOK()
{
    char szBuffer[MAX_DIGITS + 1];

    HWND hwndControl;

    // get the user's entry for ego's x position
    hwndControl = GetDlgItem(g_hwndFirstRoomCtrlDlg, IDC_EDIT_X_POS);
    GetWindowText(hwndControl, szBuffer, MAX_DIGITS + 1);

    if (strcmp(szBuffer, "") == 0)
    {
        // if the user didn't enter anything in this field, then ignore it
        g_frctrlTemp.m_nEgoX = NO_POS_X;
    }
    else
    {
        // bounds check this puppy
        g_frctrlTemp.m_nEgoX = atoi(szBuffer);

        if (g_frctrlTemp.m_nEgoX < 0 ||
            g_frctrlTemp.m_nEgoX > AGI_MAX_VALUE)
        {
            // the entry is invalid, make the user enter a valid value
            MessageBox(g_hwndFirstRoomCtrlDlg,
                       "The x position must be a value between 0 and 255.",
                       "Error", MB_OK);
            SetFocus(hwndControl);
            return TRUE;
        }
    }

    // get the user's entry for ego's y position
    hwndControl = GetDlgItem(g_hwndFirstRoomCtrlDlg, IDC_EDIT_Y_POS);
    GetWindowText(hwndControl, szBuffer, MAX_DIGITS + 1);

    if (strcmp(szBuffer, "") == 0)
    {
        // if the user didn't enter anything in this field, then ignore it
        g_frctrlTemp.m_nEgoY = NO_POS_Y;
    }
    else
    {
        // bounds check the field if the user put something in it
        g_frctrlTemp.m_nEgoY = atoi(szBuffer);

        if (g_frctrlTemp.m_nEgoY < 0 ||
            g_frctrlTemp.m_nEgoY > AGI_MAX_VALUE)
        {
            // the entry is invalid, make the user enter a valid value
            MessageBox(g_hwndFirstRoomCtrlDlg,
                       "The y position must be a value between 0 and 255.",
                       "Error", MB_OK);
            SetFocus(hwndControl);
            return TRUE;
        }
    }

    // make sure the user isn't trying to do something goofy like enter
    // an x position without also entering a y position
    if ((g_frctrlTemp.m_nEgoX == NO_POS_X &&
         g_frctrlTemp.m_nEgoY != NO_POS_Y) ||
        (g_frctrlTemp.m_nEgoX != NO_POS_X &&
         g_frctrlTemp.m_nEgoY == NO_POS_Y))
    {
        MessageBox(g_hwndFirstRoomCtrlDlg,
                   "Both x and y coordinates must be provided for "
                   "ego positioning.",
                   "Data needed",
                   MB_OK);
        if (g_frctrlTemp.m_nEgoX == NO_POS_X)
        {
            SetFocus(GetDlgItem(g_hwndFirstRoomCtrlDlg, IDC_EDIT_X_POS));
        }
        else
        {
            SetFocus(GetDlgItem(g_hwndFirstRoomCtrlDlg, IDC_EDIT_Y_POS));
        }

        return TRUE;
    }

    // the rest of this stuff doesn't require any error-checking, thankfully
    g_frctrlTemp.m_bStatusBarOn =
        IsCheckboxChecked(g_hwndFirstRoomCtrlDlg, IDC_CHECK_STATUS_BAR_ON);

    g_frctrlTemp.m_bAcceptInput =
        IsCheckboxChecked(g_hwndFirstRoomCtrlDlg, IDC_CHECK_ACCEPT_INPUT);

    // got here with no errors? then end the dialog
    EndDialog(g_hwndFirstRoomCtrlDlg, IDOK);
    return TRUE;
}