/////////////////////////////////////////////////////
//
// FirstRoomCtrlDlg.h
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    defines the public interface for the First Room
//    Control dialog
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

// make sure this header can't be included twice
#if !defined(FIRST_ROOM_CTRL_DLG_H_INCLUDED)
#define FIRST_ROOM_CTRL_DLG_H_INCLUDED

#include "BLGDefs.h"

/////////////////////////////////////////////////////
//
// FirstRoomCtrlDlgDoModal
//
/////////////////////////////////////////////////////
//
// Purpose:
//    provides a somewhat abstract interface to the
//    First Room Control dialog so that modules that need
//    to use this dialog don't have to worry about
//    any of the details of displaying the dialog box;
//    this function also takes care of the details of
//    applying changes when the user clicks OK and
//    discarding changes when the user clicks Cancel
// Parameter frctrl:
//    input/output parameter; when the function is
//    called, this parameter is used to initialize
//    the dialog box's controls; if the user dismisses
//    the dialog box with the OK button, then changes
//    will be saved to this parameter; if the user
//    clicks the Cancel button, then the parameter
//    will retain the value it had when the function
//    was called
// Return value:
//    IDOK if the user dismisses the dialog with
//    the OK button; IDCANCEL if the user dismisses
//    the dialog box any other way
//
/////////////////////////////////////////////////////

int FirstRoomCtrlDlgDoModal(CFirstRoomCtrl& frctrl);

#endif // !defined(FIRST_ROOM_CTRL_DLG_H_INCLUDED)