/////////////////////////////////////////////////////
//
// EgoPositionControlArray.h
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    declaration of the CEgoPositionControlArray class
//
// Portability information:
//    the code in this file should be portable without
//    modification; if it is not, feel free to modify
//    it so that it is portable; do not add non-portable
//    code to this file
//
/////////////////////////////////////////////////////

#if !defined(EGO_POSITION_CONTROL_ARRAY_H_INCLUDED)
#define EGO_POSITION_CONTROL_ARRAY_H_INCLUDED

#include "BLGDefs.h"

class CEgoPositionControlArray
{
public:
    CEgoPositionControlArray(int nInitialSize = 10, int nGrowBy = -1);
    virtual ~CEgoPositionControlArray();

    // changes the capacity and grow size of the array
    int SetSize(int nNewSize, int nGrowBy = -1);
    // returns the current capacity of the array
    int GetSize();
    // returns the number of actual elements in the array
    int GetElementCount();

    // NOTE: for all add/insert operations, if the item to be put in
    //       the array is an absolute positioning item, use
    //       SetAbsolutePositioningItem instead

    // adds an element to the end of the array
    void Add(const PEGOPOSITIONCONTROL pepcNewElement);
    // overwrites an existing array element
    void SetAt(const PEGOPOSITIONCONTROL pepcNewElement, int nPos);
    // inserts a new array element into the array
    void InsertAt(const PEGOPOSITIONCONTROL pepcNewElement, int nPos);
    
    
    // removes nCount elements from the array starting at index nPos
    void RemoveAt(int nPos, int nCount = 1);
    // removes all the elements from the array
    void RemoveAll();
    // returns the element at index nPos
    EGOPOSITIONCONTROL& GetAt(int nPos);
    // same as GetAt
    EGOPOSITIONCONTROL& operator[](int nPos);

    // records information for the single absolute positioning item
    // that may exist in the position control array; replaces the old
    // one if it exists
    void SetAbsolutePositioningItem(const PEGOPOSITIONCONTROL pepcItem);
    // returns a pointer to the information for the single absolute
    // positioning item in the array
    PEGOPOSITIONCONTROL GetAbsolutePositioningItem();

protected:
    // the 0-based index of the last element in the array
    int m_nLastElement;
    // the number of elements that the array capacity should be increased
    // by when the array grows
    int m_nGrowBy;
    // the current capacity of the array before a grow is necessary
    int m_nArraySize;
    // a pointer to the array
    PEGOPOSITIONCONTROL m_pepcTheArray;
    // the single absolute positioning item that exists in the array
    EGOPOSITIONCONTROL m_epcAbsolutePos;

    // called to reallocate the array when necessary
    void GrowArray();
};

#endif // !defined(EGO_POSITION_CONTROL_ARRAY_H_INCLUDED)