/////////////////////////////////////////////////////
//
// EditDefineNameDlgEventHandlers.cpp
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    implementation of event handlers for the Edit
//    Define Name dialog
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// includes
//
/////////////////////////////////////////////////////

#include "resource.h"
#include "BLGDefs.h"
#include "GeneralUI.h"
#include "EditDefineNameDlgUI.h"
#include "EditDefineNameDlgEventHandlers.h"

/////////////////////////////////////////////////////
//
// global variables
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
// defined in EditDefineNameDlg.cpp
extern char g_szDefineNameTemp[MAX_DEFINE_NAME_LEN + 1];
/////////////////////////////////////////////////////

HWND g_hwndEditDefineNameDlg;

/////////////////////////////////////////////////////
//
// OnEditDefineNameDlgWMCommand
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_COMMAND handler for the Edit Define Name dialog
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_COMMAND message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_COMMAND message
// Parameter lParam:
//    the lParam sent with the WM_COMMAND message
//
/////////////////////////////////////////////////////

BOOL OnEditDefineNameDlgWMCommand(HWND hDlg, WPARAM wParam, LPARAM lParam)
{
    switch(LOWORD(wParam))
    {
    case IDOK:
        return OnEditDefineNameDlgOK();
    case IDCANCEL:
        EndDialog(hDlg, LOWORD(wParam));
        return TRUE;
    }

    return FALSE;
}

/////////////////////////////////////////////////////
//
// OnEditDefineNameDlgWMInitDialog
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_INITDIALOG handler for the Edit Define Name
//    dialog
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_INITDIALOG message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_INITDIALOG message
// Parameter lParam:
//    the lParam sent with the WM_INITDIALOG message
//
/////////////////////////////////////////////////////

BOOL OnEditDefineNameDlgWMInitDialog(HWND hDlg, WPARAM wParam, LPARAM lParam)
{
    HWND hwndControl;

    g_hwndEditDefineNameDlg = hDlg;

    CenterDialogToParent(hDlg);

    SetWindowText(GetDlgItem(hDlg, IDC_STATIC_OLD_NAME), g_szDefineNameTemp);

    hwndControl = GetDlgItem(hDlg, IDC_EDIT_NEW_NAME);
    SendMessage(hwndControl, EM_LIMITTEXT, 
                static_cast<WPARAM>(MAX_DEFINE_NAME_LEN), 0);
    SetWindowText(hwndControl, g_szDefineNameTemp);
    return TRUE;
}