/////////////////////////////////////////////////////
//
// EdgeCodeAdvancedDlgUI.h
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    prototypes for Edge Code Advanced dialog's user 
//    interface functions
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

// make sure this file can't be included twice
#if !defined(EDGE_CODE_ADVANCED_DLG_UI_H_INCLUDED)
#define EDGE_CODE_ADVANCED_DLG_UI_H_INCLUDED

#include "BLGDefs.h"

/////////////////////////////////////////////////////
//
// TryToEnableEmptyCodeLeftEdge
//
/////////////////////////////////////////////////////
//
// Purpose:
//    this function attempts to enable the Empty Code
//    for Left Edge check box; it should be called
//    whenever changes are made to the settings in
//    the dialog box that might change the applicability
//    of the check box
// Postconditions:
//    if the check box can be enabled, it is; if it cannot
//    be enabled, it is disabled
//
/////////////////////////////////////////////////////

void TryToEnableEmptyCodeLeftEdge();

/////////////////////////////////////////////////////
//
// TryToEnableEmptyCodeRightEdge
//
/////////////////////////////////////////////////////
//
// Purpose:
//    this function attempts to enable the Empty Code
//    for Right Edge check box; it should be called
//    whenever changes are made to the settings in
//    the dialog box that might change the applicability
//    of the check box
// Postconditions:
//    if the check box can be enabled, it is; if it cannot
//    be enabled, it is disabled
//
/////////////////////////////////////////////////////

void TryToEnableEmptyCodeRightEdge();

/////////////////////////////////////////////////////
//
// TryToEnableEmptyCodeBottomEdge
//
/////////////////////////////////////////////////////
//
// Purpose:
//    this function attempts to enable the Empty Code
//    for Bottom Edge check box; it should be called
//    whenever changes are made to the settings in
//    the dialog box that might change the applicability
//    of the check box
// Postconditions:
//    if the check box can be enabled, it is; if it cannot
//    be enabled, it is disabled
//
/////////////////////////////////////////////////////

void TryToEnableEmptyCodeBottomEdge();

/////////////////////////////////////////////////////
//
// TryToEnableEmptyCodeHorizonEdge
//
/////////////////////////////////////////////////////
//
// Purpose:
//    this function attempts to enable the Empty Code
//    for Horizon Edge check box; it should be called
//    whenever changes are made to the settings in
//    the dialog box that might change the applicability
//    of the check box
// Postconditions:
//    if the check box can be enabled, it is; if it cannot
//    be enabled, it is disabled
//
/////////////////////////////////////////////////////

void TryToEnableEmptyCodeHorizonEdge();

/////////////////////////////////////////////////////
//
// OnCheckEmptyCodeLeftEdge
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles events for the Empty Code for Left Edge
//    check box
// Return value:
//    TRUE if event is handled; FALSE otherwise
//
/////////////////////////////////////////////////////

BOOL OnCheckEmptyCodeLeftEdge();

/////////////////////////////////////////////////////
//
// OnCheckEmptyCodeRightEdge
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles events for the Empty Code for Right Edge
//    check box
// Return value:
//    TRUE if event is handled; FALSE otherwise
//
/////////////////////////////////////////////////////

BOOL OnCheckEmptyCodeRightEdge();

/////////////////////////////////////////////////////
//
// OnCheckEmptyCodeBottomEdge
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles events for the Empty Code for Bottom Edge
//    check box
// Return value:
//    TRUE if event is handled; FALSE otherwise
//
/////////////////////////////////////////////////////

BOOL OnCheckEmptyCodeBottomEdge();

/////////////////////////////////////////////////////
//
// OnCheckEmptyCodeHorizonEdge
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles events for the Empty Code for Horizon Edge
//    check box
// Return value:
//    TRUE if event is handled; FALSE otherwise
//
/////////////////////////////////////////////////////

BOOL OnCheckEmptyCodeHorizonEdge();


/////////////////////////////////////////////////////
//
// OnEditLeftEdgeMsg
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles notifications related to the Left Edge
//    Message edit box
// Parameter wParam:
//    the wParam that was sent to the dialog box
//    procedure with the WM_COMMAND message; contains
//    the notification code
// Return value:
//    TRUE if event is handled; FALSE otherwise
//
/////////////////////////////////////////////////////

BOOL OnEditLeftEdgeMsg(WPARAM wParam);

/////////////////////////////////////////////////////
//
// OnEditLeftEdgeMsgENUpdate
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles the EN_UPDATE notification for the
//    Left Edge Message edit box
// Return value:
//    TRUE if event is handled; FALSE otherwise
//
/////////////////////////////////////////////////////

BOOL OnEditLeftEdgeMsgENUpdate();

/////////////////////////////////////////////////////
//
// OnEditRightEdgeMsg
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles notifications related to the Right Edge
//    Message edit box
// Parameter wParam:
//    the wParam that was sent to the dialog box
//    procedure with the WM_COMMAND message; contains
//    the notification code
// Return value:
//    TRUE if event is handled; FALSE otherwise
//
/////////////////////////////////////////////////////

BOOL OnEditRightEdgeMsg(WPARAM wParam);

/////////////////////////////////////////////////////
//
// OnEditRightEdgeMsgENUpdate
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles the EN_UPDATE notification for the
//    Right Edge Message edit box
// Return value:
//    TRUE if event is handled; FALSE otherwise
//
/////////////////////////////////////////////////////

BOOL OnEditRightEdgeMsgENUpdate();

/////////////////////////////////////////////////////
//
// OnEditBottomEdgeMsg
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles notifications related to the Bottom Edge
//    Message edit box
// Parameter wParam:
//    the wParam that was sent to the dialog box
//    procedure with the WM_COMMAND message; contains
//    the notification code
// Return value:
//    TRUE if event is handled; FALSE otherwise
//
/////////////////////////////////////////////////////

BOOL OnEditBottomEdgeMsg(WPARAM wParam);

/////////////////////////////////////////////////////
//
// OnEditBottomEdgeMsgENUpdate
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles the EN_UPDATE notification for the
//    Bottom Edge Message edit box
// Return value:
//    TRUE if event is handled; FALSE otherwise
//
/////////////////////////////////////////////////////

BOOL OnEditBottomEdgeMsgENUpdate();

/////////////////////////////////////////////////////
//
// OnEditHorizonEdgeMsg
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles notifications related to the Horizon Edge
//    Message edit box
// Parameter wParam:
//    the wParam that was sent to the dialog box
//    procedure with the WM_COMMAND message; contains
//    the notification code
// Return value:
//    TRUE if event is handled; FALSE otherwise
//
/////////////////////////////////////////////////////

BOOL OnEditHorizonEdgeMsg(WPARAM wParam);

/////////////////////////////////////////////////////
//
// OnEditHorizonEdgeMsgENUpdate
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles the EN_UPDATE notification for the
//    Horizon Edge Message edit box
// Return value:
//    TRUE if event is handled; FALSE otherwise
//
/////////////////////////////////////////////////////

BOOL OnEditHorizonEdgeMsgENUpdate();

/////////////////////////////////////////////////////
//
// OnEdgeCodeAdvancedDlgOK
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles event for the Edge Code Advanced dialog's
//    OK button
// Return value:
//    TRUE if event is handled; FALSE otherwise
//
/////////////////////////////////////////////////////

BOOL OnEdgeCodeAdvancedDlgOK();

#endif // !defined(EDGE_CODE_ADVANCED_DLG_UI_H_INCLUDED)