/////////////////////////////////////////////////////
//
// DefineNameDlg.h
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    defines the public interface for the Define
//    Name dialog
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

// make sure this file can't be included twice
#if !defined(DEFINE_NAME_DLG_H_INCLUDED)
#define DEFINE_NAME_DLG_H_INCLUDED

#include "BLGDefs.h"

/////////////////////////////////////////////////////
//
// DefineNameDlgDoModal
//
/////////////////////////////////////////////////////
//
// Purpose:
//    provides a somewhat abstract interface to the
//    Define Name dialog so that modules that need
//    to use this dialog don't have to worry about
//    any of the details of displaying the dialog box;
//    this function also takes care of the details of
//    applying changes when the user clicks OK and
//    discarding changes when the user clicks Cancel
// Parameter hwndParent:
//    the parent window for the Define Name dialog;
//    while the Define Name dialog is displayed, the
//    user is prevented from interacting with the parent
//    window
// Parameter deflist:
//    input/output parameter; when the function is
//    called, this parameter is used to initialize
//    the dialog box's controls; if the user dismisses
//    the dialog box with the OK button, then changes
//    will be saved to this parameter; if the user
//    clicks the Cancel button, then the parameter
//    will retain the value it had when the function
//    was called
// Return value:
//    IDOK if the user dismisses the dialog with
//    the OK button; IDCANCEL if the user dismisses
//    the dialog box any other way
//
/////////////////////////////////////////////////////

int DefineNameDlgDoModal(HWND hwndParent, CDefineNameList& deflist);

#endif // !defined(DEFINE_NAME_DLG_H_INCLUDED)