/////////////////////////////////////////////////////
//
// CompiledCodeDlgEventHandlers.cpp
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    implementation of event handlers for the
//    Compiled Code property page
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// includes
//
/////////////////////////////////////////////////////

#include "resource.h"
#include "BLGDefs.h"
#include "GeneralUI.h"
#include "CompiledCodeDlgEventHandlers.h"

/////////////////////////////////////////////////////
//
// global variables
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
// defined in OptionsDlg.cpp
extern COptions g_optionsTemp;
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// OnCompiledCodeDlgWMInitDialog
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_INITDIALOG handler for the Compiled code
//    property page
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_INITDIALOG message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_INITDIALOG message
// Parameter lParam:
//    the lParam sent with the WM_INITDIALOG message
//
/////////////////////////////////////////////////////

BOOL OnCompiledCodeDlgWMInitDialog(HWND hDlg, WPARAM wParam, LPARAM lParam)
{
    SetCheckboxChecked(hDlg, IDC_CHECK_ALLOW_EMPTY_CODE_BLOCKS,
                       g_optionsTemp.m_bAllowEmptyCompiledCodeBlocks);
    SetCheckboxChecked(hDlg, IDC_CHECK_GENERATE_COMPILED_CODE,
                       g_optionsTemp.m_bGenerateCompiledCode);
    return TRUE;
}

/////////////////////////////////////////////////////
//
// OnCommentsDlgWMNotify
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_NOTIFY handler for the Compiled Code property
//    page
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_NOTIFY message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_NOTIFY message
// Parameter lParam:
//    the lParam sent with the WM_NOTIFY message
//
/////////////////////////////////////////////////////

BOOL OnCompiledCodeDlgWMNotify(HWND hDlg, WPARAM wParam, LPARAM lParam)
{
    LPNMHDR pnmh = (LPNMHDR) lParam;

    switch(pnmh->code)
    {
    case PSN_APPLY:
        break;

    case PSN_KILLACTIVE:
        // in the case of a PSN_KILLACTIVE, if the changes are valid,
        // call SetWindowLong and set DWL_MSGRESULT to FALSE; if invalid,
        // set it to TRUE and notify user
        g_optionsTemp.m_bAllowEmptyCompiledCodeBlocks =
            IsCheckboxChecked(hDlg, IDC_CHECK_ALLOW_EMPTY_CODE_BLOCKS);
        g_optionsTemp.m_bGenerateCompiledCode =
            IsCheckboxChecked(hDlg, IDC_CHECK_GENERATE_COMPILED_CODE);

        SetWindowLong(hDlg, DWL_MSGRESULT, FALSE);
        break;
    }

    return TRUE;
}
