/////////////////////////////////////////////////////
//
// AboutBox.cpp
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    implements the interface for the About Box
//    dialog and contains its dialog box procedure
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// includes
//
/////////////////////////////////////////////////////

#include "AboutBox.h"
#include "resource.h"
#include "GeneralUI.h"

/////////////////////////////////////////////////////
// declared in AGIBLG.cpp
extern HINSTANCE g_hInstance;
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
// declared in MainDlgEventHandlers.cpp
extern HWND g_hwndMainDlg;
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// AboutBoxDlgProc
//
/////////////////////////////////////////////////////
//
// Purpose:
//    dialog box procedure for About Box dialog
// Parameters:
//    consult a Windows API reference for the meanings
//    of the parameters
// Return value:
//    TRUE if the BLG handled the event and Windows
//    doesn't need to; FALSE if Windows should handle
//    the event
// Remarks:
//    unlike the other dialog box procedures for the BLG,
//    the About Box does not call event handlers; this
//    is because the About Box requires a bare minimum
//    of dialog procedure sophistication and having
//    three files for a little bit of nothing would make
//    things more complex than they need to be
//
/////////////////////////////////////////////////////

BOOL CALLBACK AboutBoxDlgProc(HWND hDlg, UINT uiMsg, 
                              WPARAM wParam, LPARAM lParam)
{
    switch(uiMsg)
    {
    case WM_INITDIALOG:
        CenterDialogToParent(hDlg);
        return TRUE;

    case WM_COMMAND:
        switch(LOWORD(wParam))
        {
        case IDOK:
        case IDCANCEL:
            EndDialog(hDlg, LOWORD(wParam));
            return TRUE;
        }
        break;
    }

    return FALSE;

}

/////////////////////////////////////////////////////
//
// AboutBoxDoModal
//
/////////////////////////////////////////////////////
//
// Purpose:
//    provides a somewhat abstract interface to the
//    About Box dialog so that modules that need
//    to use this dialog don't have to worry about
//    any of the details of displaying the dialog box;
// Return value:
//    IDOK if the user dismisses the dialog with
//    the OK button; IDCANCEL if the user dismisses
//    the dialog box any other way
//
/////////////////////////////////////////////////////

int AboutBoxDoModal()
{
    return DialogBox(g_hInstance, MAKEINTRESOURCE(IDD_DLG_ABOUT),
                     g_hwndMainDlg, AboutBoxDlgProc);
}