'*===================================*
'*                                   *
'* Music Quest Programmer's ToolKit  *
'* Function/subroutine definitions   *
'*                                   *
'*===================================*
'*                                   *
'* Copyright (c) 1988, 1990          *
'* Music Quest, Inc.                 *
'*                                   *
'*===================================*

'*===================================*
'*                                   *
'* mcctkfb.asm functions             *
'*                                   *
'*===================================*
DECLARE FUNCTION mccopen CDECL ALIAS "_mcc_open" (BYVAL mccaddr%, BYVAL irqlevel%)
DECLARE FUNCTION mccirq CDECL ALIAS "_mcc_irq" (BYVAL mccaddr%)
DECLARE SUB mccclose CDECL ALIAS "_mcc_close"
DECLARE FUNCTION mcccommand CDECL ALIAS "_mcc_command" (BYVAL cmd%)
DECLARE FUNCTION mccget CDECL ALIAS "_mcc_get"
DECLARE SUB mccput CDECL ALIAS "_mcc_put" (BYVAL cmd%)
DECLARE SUB mccreceive CDECL ALIAS "_mcc_receive"
DECLARE SUB mccsetnoslih CDECL ALIAS "_mcc_set_noslih"
DECLARE SUB mccsetreceiveslih CDECL ALIAS "_mcc_set_receiveslih"
DECLARE SUB mccsetcoprocslih CDECL ALIAS "_mcc_set_coprocslih"
DECLARE SUB mccflush CDECL ALIAS "_mcc_flush"
DECLARE SUB mccreset CDECL ALIAS "_mcc_reset"

'*===================================*
'*                                   *
'* mcctkihb.asm functions            *
'*                                   *
'*===================================*
DECLARE SUB sppefw CDECL ALIAS "_spp_efw" (BYVAL efw as integer, BYVAL spp as  integer)
DECLARE SUB smpteefw CDECL ALIAS "_smpte_efw" (BYVAL efw as integer, BYVAL smptefid as integer)
DECLARE FUNCTION cuepointefw CDECL ALIAS "_cuepoint_efw"
DECLARE FUNCTION realtimeefw CDECL ALIAS "_realtime_efw"
DECLARE FUNCTION strkendefw CDECL ALIAS "_strk_end_efw"
DECLARE FUNCTION recordoverflow CDECL ALIAS "_rec_overflow"
DECLARE FUNCTION trackefw CDECL ALIAS "_track_efw" (BYVAL trackn%)
DECLARE FUNCTION clockefw CDECL ALIAS "_clock_efw"
DECLARE FUNCTION conductorefw CDECL ALIAS "_conductor_efw"
DECLARE FUNCTION acknefw CDECL ALIAS "_ackn_efw"
DECLARE FUNCTION playendefw CDECL ALIAS "_playend_efw"
DECLARE FUNCTION recordendefw CDECL ALIAS "_recordend_efw"
DECLARE FUNCTION measurendefw CDECL ALIAS "_measurend_efw"
DECLARE FUNCTION recbytes CDECL ALIAS "_rec_bytes"
DECLARE SUB recinit CDECL ALIAS "_rec_init" (BYVAL sa as integer, BYVAL so as integer, BYVAL lng as integer)

'*===================================*
'*                                   *
'* mcctkckb.asm functions            *
'*                                   *
'*===================================*
DECLARE SUB mclkinit CDECL ALIAS "_mclk_init" (BYVAL ticks%)
DECLARE SUB mclkstart CDECL ALIAS "_mclk_start"
DECLARE SUB mclkstop CDECL ALIAS "_mclk_stop"
DECLARE FUNCTION midiclock CDECL ALIAS "_midi_clock"
DECLARE FUNCTION settrq CDECL ALIAS "_set_trq"  (BYVAL efwaddr%, BYVAL tval%)
DECLARE SUB settrqtime CDECL ALIAS "_set_trq_time"  (BYVAL trqhandle%, BYVAL tval%)
DECLARE SUB addtrqtime CDECL ALIAS "_add_trq_time"  (BYVAL trqhandle%, BYVAL tval%)
DECLARE SUB endtrq CDECL ALIAS "_end_trq"  (BYVAL trqhandle%)
DECLARE SUB clearefw CDECL ALIAS "_clear_efw"  (BYVAL efwaddr%)
